/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.views.palette.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.ui.views.palette.editor.PaletteEditor;
import org.jboss.tools.common.model.ui.views.palette.model.IPaletteNode;
import org.jboss.tools.common.model.ui.views.palette.model.PaletteGroup;

public class PaletteModel {
    static String SUB_GROUP_ELEMENT_TYPE = "sub-group";
    static String GROUP_ELEMENT_TYPE = "group";
    private static PaletteModel instance = null;
    private static Object monitor = new Object();
    private PaletteEditor editor = new PaletteEditor();
    private static final URL BASE_URL = ModelUIPlugin.getDefault().getBundle().getEntry("/");
    private IPaletteNode root = null;

    private PaletteModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final PaletteModel getInstance() {
        if (instance != null) {
            return instance;
        }
        Object object = monitor;
        synchronized (object) {
            if (instance == null) {
                PaletteModel inst = new PaletteModel();
                inst.createModel();
                instance = inst;
            }
        }
        return instance;
    }

    public IPaletteNode getRoot() {
        return this.root;
    }

    public void reload() {
        ((PaletteGroup)this.root).clear();
        this.createModel();
    }

    private void createModel() {
        XModelObject[] xtabs;
        XModelObject xpalette = this.getXModelRoot();
        this.root = new PaletteGroup(xpalette);
        if (xpalette != null && (xtabs = this.findXObjects(xpalette, GROUP_ELEMENT_TYPE)) != null) {
            int i = 0;
            while (i < xtabs.length) {
                this.createTab(xtabs[i]);
                ++i;
            }
        }
    }

    private void createTab(XModelObject xtab) {
        if (!"yes".equals(xtab.getAttributeValue("hidden"))) {
            IPaletteNode tab = this.addTab(xtab, xtab.getAttributeValue("name"));
            int j = 0;
            while (j < xtab.getChildren().length) {
                XModelObject xelem = xtab.getChildAt(j);
                if (xelem.getAttributeValue("element type").equals("macro")) {
                    this.createElem(tab, xelem, true);
                }
                ++j;
            }
        }
    }

    private void createElem(IPaletteNode parent, XModelObject xelem, boolean asGroup) {
        Thread.dumpStack();
    }

    private IPaletteNode addTab(XModelObject xobject, String title) {
        PaletteGroup tab = new PaletteGroup(xobject, title);
        this.root.addChild(tab);
        return tab;
    }

    public ImageDescriptor createImageDescriptor(String fileName) {
        String imagePath = "images/xstudio/palette/";
        try {
            URL url = new URL(BASE_URL, String.valueOf(imagePath) + fileName);
            return ImageDescriptor.createFromURL((URL)url);
        }
        catch (MalformedURLException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private XModelObject[] findXObjects(XModelObject root, String elementType) {
        ArrayList<XModelObject> v = new ArrayList<XModelObject>();
        int i = 0;
        while (i < root.getChildren().length) {
            if (root.getChildAt(i).getAttributeValue("element type").equals(elementType)) {
                v.add(root.getChildAt(i));
            }
            ++i;
        }
        return v.size() == 0 ? null : v.toArray(new XModelObject[0]);
    }

    private XModelObject getXModelRoot() {
        return this.getXModel().getRoot("Palette");
    }

    public XModel getXModel() {
        return ModelUtilities.getPreferenceModel();
    }

    public void openEditor(Shell shell) {
        this.editor.setObject(shell);
        this.editor.execute();
    }

    public void runShowHideDialog() {
        XModelObject root = this.getXModelRoot();
        XActionInvoker.invoke((String)"HiddenTabs", (XModelObject)root, (Properties)new Properties());
    }

    public void addModelTreeListener(XModelTreeListener listener) {
        this.getXModel().addModelTreeListener(listener);
    }

    public void removeModelTreeListener(XModelTreeListener listener) {
        this.getXModel().removeModelTreeListener(listener);
    }
}

