/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.standard;

import java.util.Properties;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.SpecialWizardControlListener;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.action.impl.WizardDataValidator;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.wizards.standard.DefaultStandardStep;

public class DefaultStandardWizard
extends Wizard
implements SpecialWizardControlListener {
    protected SpecialWizardSupport support = null;
    protected DefaultStandardStep[] steps = new DefaultStandardStep[0];
    Composite pageContainer;
    boolean isFinishEnabled = true;

    public void setSupport(SpecialWizardSupport support) {
        this.support = support;
        support.setControlListener((SpecialWizardControlListener)this);
    }

    public boolean performFinish() {
        try {
            this.support.action(SpecialWizardSupport.FINISH);
            return this.support.isFinished();
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
            return false;
        }
    }

    public boolean canFinish() {
        return this.support.isActionEnabled(SpecialWizardSupport.FINISH) && this.isFinishEnabled;
    }

    public void addPages() {
        XEntityData[] data = this.support.getEntityData();
        this.steps = new DefaultStandardStep[data.length];
        int i = 0;
        while (i < data.length) {
            this.steps[i] = new DefaultStandardStep(this.support, i);
            this.steps[i].setWizard((IWizard)this);
            ++i;
        }
    }

    public void createPageControls(Composite pageContainer) {
        String helpContextId;
        String string = helpContextId = this.support == null ? null : this.support.getHelpContextId();
        if (helpContextId != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)pageContainer, helpContextId);
        }
        this.pageContainer = pageContainer;
        int i = 0;
        while (i < this.steps.length) {
            DefaultStandardStep page = this.steps[i];
            page.createControl(pageContainer);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.steps.length) {
            this.steps[i].dispose();
            ++i;
        }
        super.dispose();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        try {
            this.support.action(SpecialWizardSupport.NEXT);
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
        int id = this.support.getStepId();
        return this.steps[id];
    }

    public IWizardPage[] getPages() {
        return this.steps;
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        int id = this.support.getPreviousStepId();
        return id < 0 || id >= this.steps.length ? null : this.steps[id];
    }

    public IWizardPage getStartingPage() {
        return this.steps.length == 0 ? null : this.steps[0];
    }

    public boolean needsPreviousAndNextButtons() {
        return this.steps.length > 1;
    }

    public void dataChanged(WizardDataValidator validator, Properties data) {
        if (validator == null) {
            return;
        }
        this.updateValidationData(validator, data);
    }

    void updateValidationData(WizardDataValidator validator, Properties data) {
        boolean isNextEnabled;
        if (validator == null) {
            return;
        }
        validator.validate(data);
        String message = validator.getErrorMessage();
        this.isFinishEnabled = validator.isCommandEnabled(SpecialWizardSupport.FINISH);
        DefaultStandardStep wizardStep = this.steps[this.support.getStepId()];
        String m = this.support.getMessage(this.support.getStepId());
        if (wizardStep != null && !wizardStep.isDataChanged()) {
            if (m == null || m.length() == 0) {
                m = message;
            }
            wizardStep.setDescription(m);
            wizardStep.setErrorMessage(null);
        } else {
            wizardStep.setDescription(m);
            if (message == null && !this.isFinishEnabled && (message = this.support.getMessage(this.support.getStepId())) != null && message.trim().length() == 0) {
                message = null;
            }
            wizardStep.setErrorMessage(message);
        }
        wizardStep.isNextEnabled = isNextEnabled = validator.isCommandEnabled(SpecialWizardSupport.NEXT);
        this.getContainer().updateButtons();
    }

    public void action(String name) {
        try {
            DefaultStandardStep step = this.steps[this.support.getStepId()];
            step.save();
            this.support.action(name);
        }
        catch (XModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }
}

