/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.core.model.internal;

import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModelException;
import org.jboss.ide.eclipse.archives.core.model.EventManager;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModel;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNodeDelta;
import org.jboss.ide.eclipse.archives.core.model.internal.ArchiveNodeImpl;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XMLBinding;
import org.jboss.ide.eclipse.archives.core.model.internal.xb.XbPackages;

public class ArchiveModelNode
extends ArchiveNodeImpl
implements IArchiveModelRootNode {
    private IPath project;
    private IPath descriptor;
    private IArchiveModel model;

    public ArchiveModelNode(IPath project, XbPackages node) {
        this(project, null, node);
    }

    public ArchiveModelNode(IPath project, IPath descriptor, XbPackages node) {
        this(project, descriptor, node, null);
    }

    public ArchiveModelNode(IPath project, XbPackages node, IArchiveModel model) {
        this(project, null, node, model);
    }

    public ArchiveModelNode(IPath project, IPath descriptor, XbPackages node, IArchiveModel model) {
        super(node);
        this.project = project;
        this.descriptor = descriptor != null ? descriptor : project.append(".packages");
        this.model = model;
    }

    public IPath getDescriptor() {
        return this.descriptor;
    }

    public IArchiveModel getModel() {
        return this.model;
    }

    public IPath getProjectPath() {
        return this.project;
    }

    public XbPackages getXbPackages() {
        return (XbPackages)this.nodeDelegate;
    }

    protected boolean validateChild(IArchiveNode child) {
        return child.getNodeType() == 0;
    }

    public int getNodeType() {
        return -1;
    }

    public IArchiveNode getRoot() {
        return this;
    }

    public boolean connectedToModel() {
        return this.getModel() != null;
    }

    public IArchiveNode getParent() {
        return null;
    }

    public void setParent(IArchiveNode parent) {
    }

    public void setModel(IArchiveModel model) {
        this.model = model;
    }

    public double getDescriptorVersion() {
        return ((XbPackages)this.getNodeDelegate()).getVersion();
    }

    public void setDescriptorVersion(double d) {
        ((XbPackages)this.getNodeDelegate()).setVersion(d);
    }

    public IPath getRootArchiveRelativePath() {
        return null;
    }

    public void save(IProgressMonitor monitor) throws ArchivesModelException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        XbPackages packs = (XbPackages)this.getNodeDelegate();
        try {
            XMLBinding.marshallToFile(packs, this.getDescriptor(), monitor);
        }
        catch (XMLBinding.XbException xbe) {
            throw new ArchivesModelException(xbe);
        }
        IArchiveNodeDelta delta = this.getDelta();
        this.clearDelta();
        EventManager.fireDelta(delta);
    }

    public boolean validateModel() {
        if (this.getChildren(0).length < this.getAllChildren().length) {
            return false;
        }
        ArrayList<IPath> list = new ArrayList<IPath>();
        IArchiveNode[] children = this.getChildren(0);
        int i = 0;
        while (i < children.length) {
            IArchive child = (IArchive)children[i];
            if (child.getArchiveFilePath() == null) {
                return false;
            }
            IPath p = child.getArchiveFilePath();
            if (list.contains(p)) {
                return false;
            }
            list.add(p);
            ++i;
        }
        return super.validateModel();
    }
}

