/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.actions;

import java.io.FileNotFoundException;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.jboss.tools.hibernate.ui.diagram.DiagramViewerMessages;
import org.jboss.tools.hibernate.ui.diagram.UiPlugin;
import org.jboss.tools.hibernate.ui.diagram.editors.DiagramViewer;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Connection;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.view.DiagramEditorInput;

public class OpenSourceAction
extends SelectionAction {
    public static final String ACTION_ID = "org.jboss.tools.hibernate.ui.diagram.editors.actions.open.source";
    public static final ImageDescriptor img = UiPlugin.getImageDescriptor("icons/java.gif");

    public OpenSourceAction(IWorkbenchPart part) {
        super(part);
        this.setId(ACTION_ID);
        this.setText(DiagramViewerMessages.OpenSourceAction_open_source_file);
        this.setImageDescriptor(img);
    }

    public void run() {
        DiagramEditorInput objectEditorInput = (DiagramEditorInput)((DiagramViewer)this.getWorkbenchPart()).getEditorInput();
        ConsoleConfiguration consoleConfig = objectEditorInput.getConsoleConfig();
        DiagramViewer part = (DiagramViewer)this.getWorkbenchPart();
        Set<Shape> selectedElements = part.getSelectedElements();
        IEditorPart editorPart = null;
        Iterator<Shape> iterator = selectedElements.iterator();
        while (iterator.hasNext() && editorPart == null) {
            Shape shape = iterator.next();
            Object selection = shape.getOrmElement();
            if (selection instanceof Column || selection instanceof Table) {
                for (Connection connection : shape.getTargetConnections()) {
                    Shape sh1 = connection.getSource();
                    Shape sh2 = connection.getTarget();
                    if (shape == sh1 && sh2 != null) {
                        shape = sh2;
                        break;
                    }
                    if (shape != sh2 || sh1 == null) continue;
                    shape = sh1;
                    break;
                }
                selection = shape.getOrmElement();
            }
            PersistentClass rootClass = null;
            if (selection instanceof PersistentClass) {
                rootClass = (PersistentClass)selection;
            } else {
                if (!(selection instanceof Property)) continue;
                rootClass = ((Property)selection).getPersistentClass();
            }
            String fullyQualifiedName = rootClass.getClassName();
            try {
                editorPart = org.hibernate.eclipse.console.actions.OpenSourceAction.run((ConsoleConfiguration)consoleConfig, (Object)selection, (String)fullyQualifiedName);
            }
            catch (CoreException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenSourceAction_canot_open_source_file, (Throwable)e);
            }
            catch (FileNotFoundException e) {
                HibernateConsolePlugin.getDefault().logErrorMessage(DiagramViewerMessages.OpenSourceAction_canot_find_source_file, (Throwable)e);
            }
        }
    }

    protected boolean calculateEnabled() {
        DiagramViewer part = (DiagramViewer)this.getWorkbenchPart();
        return part.getSelectedElements().size() > 0;
    }
}

