/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.figures;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.RoundLineBorder;
import org.jboss.tools.hibernate.ui.diagram.editors.figures.TitleLabel;
import org.jboss.tools.hibernate.ui.diagram.editors.parts.ResourceManager;

public class TitleFigure
extends Figure {
    protected boolean expanded = true;
    protected TitleLabel titleLabel = null;

    public TitleFigure() {
        RoundLineBorder border = new RoundLineBorder();
        border.setColor(ResourceManager.getInstance().getColor(new RGB(160, 160, 160)));
        this.setBorder((Border)border);
        this.setSize(-1, -1);
    }

    public void createTitle(String text, Image icon, Color bg, float fontHeight) {
        Font font;
        this.removeTitle();
        TitleLabel label = new TitleLabel(fontHeight);
        label.setText(text);
        if (Display.getCurrent() != null && (font = Display.getCurrent().getSystemFont()) != null) {
            FontData[] fontData = font.getFontData();
            fontData[0].setStyle(1);
            fontData[0].height = fontHeight;
            label.setFont(ResourceManager.getInstance().getFont(fontData[0]));
        }
        label.setBackgroundColor(bg);
        label.setIcon(icon);
        label.setLabelAlignment(1);
        label.setBorder((Border)new MarginBorder(1, 2, 1, 2));
        label.setOpaque(true);
        this.add((IFigure)label, -2);
        this.titleLabel = label;
    }

    public void removeTitle() {
        if (this.titleLabel != null) {
            this.remove((IFigure)this.titleLabel);
            this.titleLabel = null;
        }
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (index != -1) {
            index = index == -2 ? 0 : ++index;
        }
        super.add(figure, constraint, index);
    }

    public List getChildren() {
        List res = super.getChildren();
        res = this.expanded ? res : res.subList(0, 1);
        return res;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.titleLabel != null) {
            this.titleLabel.setExpanded(expanded);
        }
        int width = expanded ? -1 : this.getPreferredSize().width;
        this.setSize(width, -1);
        this.repaint();
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public void refresh() {
        this.setExpanded(this.getExpanded());
    }
}

