/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu.action;

import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAnyData;
import org.jboss.tools.vpe.editor.template.VpeEditAnyDialog;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.w3c.dom.Node;

public class SetupTemplateAction
extends Action {
    private Node actionNode;
    private VpePageContext pageContext;
    private VpeAnyData data;

    public void setActionNode(Node actionNode) {
        this.actionNode = actionNode;
    }

    public void setPageContext(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    public void setData(VpeAnyData data) {
        this.data = data;
    }

    public SetupTemplateAction(String title, Node actionNode, VpeAnyData data, VpePageContext pageContext) {
        super(title);
        this.actionNode = actionNode;
        this.pageContext = pageContext;
        this.data = data;
    }

    public SetupTemplateAction(VpePageContext pageContext) {
        this.pageContext = pageContext;
    }

    public SetupTemplateAction() {
    }

    public void run() {
        boolean isCorrectNS = this.pageContext.isCorrectNS(this.actionNode);
        if (isCorrectNS) {
            this.data.setUri(this.pageContext.getSourceTaglibUri(this.actionNode));
            this.data.setName(this.actionNode.getNodeName());
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (isCorrectNS) {
            VpeEditAnyDialog editDialog = new VpeEditAnyDialog(shell, this.data, VpeTemplateManager.getInstance().getAnyTemplates());
            editDialog.open();
        } else {
            MessageBox message = new MessageBox(shell, 40);
            message.setMessage(VpeUIMessages.NAMESPACE_NOT_DEFINED);
            message.setText("Warning");
            message.open();
        }
        if (this.data != null && this.data.isChanged()) {
            VpeTemplateManager.getInstance().setAnyTemplate(this.data);
        }
    }
}

