/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpePseudoContentCreator;
import org.jboss.tools.vpe.editor.template.VpeTextCreator;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeHtmlPseudoContentCreator
extends VpePseudoContentCreator {
    private String name;
    private VpeCreator[] attrs;
    private VpeCreator[] nodes;

    public VpeHtmlPseudoContentCreator(Element htmlElement) {
        int len;
        NodeList htmlChildren;
        int len2;
        this.name = htmlElement.getNodeName();
        NamedNodeMap templAttrs = htmlElement.getAttributes();
        if (templAttrs != null && (len2 = templAttrs.getLength()) > 0) {
            ArrayList<VpeAttributeCreator> creatorAttrs = new ArrayList<VpeAttributeCreator>(len2);
            int i = 0;
            while (i < len2) {
                Attr templAttr = (Attr)templAttrs.item(i);
                creatorAttrs.add(new VpeAttributeCreator(templAttr.getName(), templAttr.getValue(), null, false));
                ++i;
            }
            this.attrs = creatorAttrs.toArray(new VpeCreator[len2]);
        }
        if ((htmlChildren = htmlElement.getChildNodes()) != null && (len = htmlChildren.getLength()) > 0) {
            ArrayList<Object> creatorNodes = new ArrayList<Object>(len);
            int i = 0;
            while (i < len) {
                Node innerNode = htmlChildren.item(i);
                switch (innerNode.getNodeType()) {
                    case 1: {
                        creatorNodes.add(new VpeHtmlPseudoContentCreator((Element)innerNode));
                        break;
                    }
                    case 3: {
                        if (innerNode.getNodeValue().trim().length() <= 0) break;
                        creatorNodes.add(new VpeTextCreator(innerNode, null, false));
                    }
                }
                ++i;
            }
            this.nodes = creatorNodes.toArray(new VpeCreator[creatorNodes.size()]);
        }
    }

    @Override
    public void setPseudoContent(VpePageContext pageContext, Node sourceContainer, nsIDOMNode visualContainer, nsIDOMDocument visualDocument) throws VpeExpressionException {
        int i;
        nsIDOMElement visualNewElement = visualDocument.createElement(this.name);
        VpeHtmlPseudoContentCreator.setPseudoAttribute(visualNewElement);
        if (this.attrs != null) {
            i = 0;
            while (i < this.attrs.length) {
                nsIDOMAttr newVisualAttribute;
                VpeCreatorInfo attributeInfo = this.attrs[i].create(pageContext, (Element)sourceContainer, visualDocument, visualNewElement, null);
                if (attributeInfo != null && (newVisualAttribute = (nsIDOMAttr)attributeInfo.getVisualNode()) != null) {
                    visualNewElement.setAttributeNode(newVisualAttribute);
                }
                ++i;
            }
        }
        if (this.nodes != null) {
            i = 0;
            while (i < this.nodes.length) {
                nsIDOMNode newVisualNode;
                VpeCreatorInfo nodeInfo = this.nodes[i].create(pageContext, sourceContainer, visualDocument, visualNewElement, null);
                if (nodeInfo != null && (newVisualNode = nodeInfo.getVisualNode()) != null) {
                    visualNewElement.appendChild(newVisualNode);
                }
                ++i;
            }
        }
        visualContainer.appendChild((nsIDOMNode)visualNewElement);
    }
}

