/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.Environment;
import org.hibernate.cfg.Settings;
import org.hibernate.console.ConfigurationFactory;
import org.hibernate.console.ConsoleConfigClassLoader;
import org.hibernate.console.ConsoleConfigurationListener;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.FakeDelegatingDriver;
import org.hibernate.console.HQLQueryPage;
import org.hibernate.console.HibernateConsoleRuntimeException;
import org.hibernate.console.JavaPage;
import org.hibernate.console.QueryInputModel;
import org.hibernate.console.QueryPage;
import org.hibernate.console.execution.DefaultExecutionContext;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.console.execution.ExecutionContextHolder;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.console.preferences.PreferencesClassPathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConsoleConfiguration
implements ExecutionContextHolder {
    private ExecutionContext executionContext;
    private ConsoleConfigClassLoader classLoader = null;
    private Map<String, FakeDelegatingDriver> fakeDrivers = new HashMap<String, FakeDelegatingDriver>();
    private Configuration configuration;
    private SessionFactory sessionFactory;
    public ConsoleConfigurationPreferences prefs = null;
    int execcount;
    ArrayList<ConsoleConfigurationListener> consoleCfgListeners = new ArrayList();

    public String getName() {
        return this.prefs.getName();
    }

    public ConsoleConfiguration(ConsoleConfigurationPreferences config) {
        this.prefs = config;
    }

    public Object execute(ExecutionContext.Command c) {
        if (this.executionContext != null) {
            return this.executionContext.execute(c);
        }
        String msg = NLS.bind((String)ConsoleMessages.ConsoleConfiguration_null_execution_context, (Object)this.getName());
        throw new HibernateConsoleRuntimeException(msg);
    }

    public boolean reset() {
        boolean res = false;
        if (this.configuration != null) {
            this.configuration = null;
            res = true;
        }
        boolean tmp = this.closeSessionFactory();
        boolean bl = res = res || tmp;
        if (this.executionContext != null) {
            this.executionContext.execute(new ExecutionContext.Command(){

                public Object execute() {
                    Iterator it = ConsoleConfiguration.this.fakeDrivers.values().iterator();
                    while (it.hasNext()) {
                        try {
                            DriverManager.deregisterDriver((Driver)it.next());
                        }
                        catch (SQLException sQLException) {}
                    }
                    return null;
                }
            });
        }
        if (this.fakeDrivers.size() > 0) {
            this.fakeDrivers.clear();
            res = true;
        }
        tmp = this.cleanUpClassLoader();
        boolean bl2 = res = res || tmp;
        if (res) {
            this.fireConfigurationReset();
        }
        this.executionContext = null;
        return res;
    }

    protected boolean cleanUpClassLoader() {
        boolean res = false;
        ClassLoader classLoaderTmp = this.classLoader;
        while (classLoaderTmp != null) {
            if (classLoaderTmp instanceof ConsoleConfigClassLoader) {
                classLoaderTmp.close();
                res = true;
            }
            classLoaderTmp = classLoaderTmp.getParent();
        }
        if (this.classLoader != null) {
            this.classLoader = null;
            res = true;
        }
        return res;
    }

    protected void reinitClassLoader() {
        URL[] oldURLS;
        boolean recreateFlag = true;
        URL[] customClassPathURLs = PreferencesClassPathUtils.getCustomClassPathURLs(this.prefs);
        if (this.classLoader != null && customClassPathURLs.length == (oldURLS = this.classLoader.getURLs()).length) {
            int i = 0;
            while (i < oldURLS.length) {
                if (!customClassPathURLs[i].sameFile(oldURLS[i])) break;
                ++i;
            }
            if (i == oldURLS.length) {
                recreateFlag = false;
            }
        }
        if (recreateFlag) {
            this.reset();
            this.classLoader = this.createClassLoader(customClassPathURLs);
        }
    }

    public void build() {
        this.configuration = this.buildWith(null, true);
        this.fireConfigurationBuilt();
    }

    protected ConsoleConfigClassLoader createClassLoader(final URL[] customClassPathURLs) {
        ConsoleConfigClassLoader classLoader = AccessController.doPrivileged(new PrivilegedAction<ConsoleConfigClassLoader>(){

            @Override
            public ConsoleConfigClassLoader run() {
                return new ConsoleConfigClassLoader(customClassPathURLs, ConsoleConfiguration.this.getParentClassLoader()){

                    @Override
                    protected Class<?> findClass(String name) throws ClassNotFoundException {
                        return super.findClass(name);
                    }

                    @Override
                    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        return super.loadClass(name, resolve);
                    }

                    @Override
                    public Class<?> loadClass(String name) throws ClassNotFoundException {
                        return super.loadClass(name);
                    }
                };
            }
        });
        return classLoader;
    }

    public Configuration buildWith(final Configuration cfg, final boolean includeMappings) {
        this.reinitClassLoader();
        this.executionContext = new DefaultExecutionContext(this.getName(), this.classLoader);
        Configuration result = (Configuration)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                ConfigurationFactory csf = new ConfigurationFactory(ConsoleConfiguration.this.prefs, ConsoleConfiguration.this.fakeDrivers);
                return csf.createConfiguration(cfg, includeMappings);
            }
        });
        return result;
    }

    protected ClassLoader getParentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        return cl;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public void buildSessionFactory() {
        this.execute(new ExecutionContext.Command(){

            public Object execute() {
                if (ConsoleConfiguration.this.sessionFactory != null) {
                    throw new HibernateConsoleRuntimeException(ConsoleMessages.ConsoleConfiguration_factory_not_closed_before_build_new_factory);
                }
                ConsoleConfiguration.this.sessionFactory = ConsoleConfiguration.this.getConfiguration().buildSessionFactory();
                ConsoleConfiguration.this.fireFactoryBuilt();
                return null;
            }
        });
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public QueryPage executeHQLQuery(String hql) {
        return this.executeHQLQuery(hql, new QueryInputModel());
    }

    public QueryPage executeHQLQuery(final String hql, final QueryInputModel queryParameters) {
        return (QueryPage)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                HQLQueryPage qp = new HQLQueryPage(ConsoleConfiguration.this, hql, queryParameters);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    public QueryPage executeBSHQuery(final String queryString, final QueryInputModel model) {
        return (QueryPage)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                org.hibernate.classic.Session session = ConsoleConfiguration.this.getSessionFactory().openSession();
                JavaPage qp = new JavaPage(ConsoleConfiguration.this, queryString, model);
                qp.setSession((Session)session);
                qp.setId(++ConsoleConfiguration.this.execcount);
                ConsoleConfiguration.this.fireQueryPageCreated(qp);
                return qp;
            }
        });
    }

    private ArrayList<ConsoleConfigurationListener> cloneConsoleCfgListeners() {
        return (ArrayList)this.consoleCfgListeners.clone();
    }

    private void fireConfigurationBuilt() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.configurationBuilt(this);
        }
    }

    private void fireConfigurationReset() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.configurationReset(this);
        }
    }

    private void fireQueryPageCreated(QueryPage qp) {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.queryPageCreated(qp);
        }
    }

    private void fireFactoryBuilt() {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.sessionFactoryBuilt(this, this.sessionFactory);
        }
    }

    private void fireFactoryClosing(SessionFactory sessionFactory2) {
        for (ConsoleConfigurationListener view : this.cloneConsoleCfgListeners()) {
            view.sessionFactoryClosing(this, sessionFactory2);
        }
    }

    public void addConsoleConfigurationListener(ConsoleConfigurationListener v) {
        this.consoleCfgListeners.add(v);
    }

    public void removeConsoleConfigurationListener(ConsoleConfigurationListener sfListener) {
        this.consoleCfgListeners.remove(sfListener);
    }

    public ConsoleConfigurationListener[] getConsoleConfigurationListeners() {
        return this.consoleCfgListeners.toArray(new ConsoleConfigurationListener[this.consoleCfgListeners.size()]);
    }

    public boolean isSessionFactoryCreated() {
        return this.sessionFactory != null;
    }

    public ConsoleConfigurationPreferences getPreferences() {
        return this.prefs;
    }

    public File getConfigXMLFile() {
        URI uri;
        URL url;
        File configXMLFile = null;
        if (this.prefs != null) {
            configXMLFile = this.prefs.getConfigXMLFile();
        }
        if (configXMLFile == null) {
            url = null;
            this.reinitClassLoader();
            if (this.classLoader != null) {
                url = this.classLoader.findResource("hibernate.cfg.xml");
            }
            if (url != null) {
                uri = null;
                try {
                    uri = url.toURI();
                    configXMLFile = new File(uri);
                }
                catch (URISyntaxException uRISyntaxException) {}
            }
        }
        if (configXMLFile == null && (url = Environment.class.getClassLoader().getResource("hibernate.cfg.xml")) != null) {
            uri = null;
            try {
                uri = url.toURI();
                configXMLFile = new File(uri);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        return configXMLFile;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ":" + this.getName();
    }

    @Override
    public ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    public boolean closeSessionFactory() {
        boolean res = false;
        if (this.sessionFactory != null) {
            this.fireFactoryClosing(this.sessionFactory);
            this.sessionFactory.close();
            this.sessionFactory = null;
            res = true;
        }
        return res;
    }

    public Settings getSettings(final Configuration cfg) {
        return (Settings)this.execute(new ExecutionContext.Command(){

            public Object execute() {
                return cfg.buildSettings();
            }
        });
    }
}

