/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.constraint.impl;

import java.text.MessageFormat;
import org.jboss.tools.common.meta.constraint.impl.XAttributeConstraintProperties;
import org.w3c.dom.Element;

public class XAttributeConstraintInt
extends XAttributeConstraintProperties {
    protected boolean mandatory = false;
    protected int min = Integer.MIN_VALUE;
    protected int max = Integer.MAX_VALUE;

    public void load(Element element) {
        super.load(element);
        this.mandatory = this.getBoolean("mandatory", false);
        this.min = this.getInt("minimum", Integer.MIN_VALUE);
        this.max = this.getInt("maximum", Integer.MAX_VALUE);
    }

    public boolean accepts(String value) {
        if (value == null || value.length() == 0) {
            return !this.mandatory;
        }
        try {
            int i = Integer.parseInt(value);
            return i >= this.min && i <= this.max;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public String getError(String value) {
        if (this.accepts(value)) {
            return null;
        }
        if (this.min == Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            return "must be an integer.";
        }
        if (this.min == 0 && this.max == Integer.MAX_VALUE) {
            return "must be a non-negative integer.";
        }
        if (this.min > Integer.MIN_VALUE && this.max == Integer.MAX_VALUE) {
            return MessageFormat.format("must be an integer not less than {0}.", this.min);
        }
        if (this.min == Integer.MIN_VALUE && this.max < Integer.MAX_VALUE) {
            return MessageFormat.format("must be an integer not greater than {0}.", this.max);
        }
        return MessageFormat.format("must be an integer from {0} to {1}.", this.min, this.max);
    }
}

