/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.nature;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCMetaDataConfiguration;
import org.hibernate.cfg.reveng.TableIdentifier;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.execution.ExecutionContext;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.mapping.Table;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateNature
implements IProjectNature {
    public static final String ID = "org.hibernate.eclipse.console.hibernateNature";
    private IProject project;
    List<Table> tables = null;
    private ReadDatabaseMetaData job;

    public void configure() throws CoreException {
        IProjectDescription desc = this.project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.hibernate.eclipse.console.hibernateBuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        if (!found) {
            ICommand command = desc.newCommand();
            command.setBuilderName("org.hibernate.eclipse.console.hibernateBuilder");
            ArrayList<ICommand> list = new ArrayList<ICommand>();
            list.addAll(Arrays.asList(commands));
            list.add(command);
            desc.setBuildSpec(list.toArray(new ICommand[0]));
            this.project.setDescription(desc, (IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void deconfigure() throws CoreException {
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }

    public ConsoleConfiguration getDefaultConsoleConfiguration() {
        String cfg = this.getDefaultConsoleConfigurationName();
        ConsoleConfiguration configuration = KnownConfigurations.getInstance().find(cfg);
        return configuration;
    }

    public String getDefaultConsoleConfigurationName() {
        IJavaProject prj = JavaCore.create((IProject)this.project);
        ProjectScope scope = new ProjectScope(prj.getProject());
        IEclipsePreferences node = scope.getNode("org.hibernate.eclipse.console");
        if (node != null) {
            String cfg = node.get("default.configuration", prj.getProject().getName());
            return cfg;
        }
        return null;
    }

    public List<Table> getTables() {
        ConsoleConfiguration ccfg = this.getDefaultConsoleConfiguration();
        if (ccfg == null) {
            return Collections.emptyList();
        }
        if (this.tables != null) {
            return this.tables;
        }
        if (this.job == null) {
            this.job = new ReadDatabaseMetaData(ccfg);
            this.job.setPriority(50);
            this.job.schedule();
        } else if (this.job.getState() == 0) {
            this.job.schedule();
        }
        return Collections.emptyList();
    }

    public List<Table> getMatchingTables(String tableName) {
        ArrayList<Table> result = new ArrayList<Table>();
        for (Table table : this.getTables()) {
            if (!table.getName().toUpperCase().startsWith(tableName.toUpperCase())) continue;
            result.add(table);
        }
        return result;
    }

    public Table getTable(TableIdentifier nearestTableName) {
        for (Table table : this.getTables()) {
            if (!nearestTableName.getName().equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    public static HibernateNature getHibernateNature(IJavaProject project) {
        try {
            if (project != null && project.getProject().isOpen() && project.getProject().hasNature(ID)) {
                HibernateNature nature = (HibernateNature)project.getProject().getNature(ID);
                return nature;
            }
        }
        catch (CoreException e) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.HibernateNature_exception_when_trying_to_locate_hibernate_nature, e);
        }
        return null;
    }

    public class ReadDatabaseMetaData
    extends Job {
        private ConsoleConfiguration ccfg;

        public ReadDatabaseMetaData(ConsoleConfiguration ccfg) {
            super(String.valueOf(HibernateConsoleMessages.HibernateNature_reading_database_metadata_for) + HibernateNature.this.getProject().getName());
            this.ccfg = ccfg;
        }

        protected IStatus run(IProgressMonitor monitor) {
            Configuration cfg = this.ccfg.buildWith(null, false);
            final JDBCMetaDataConfiguration jcfg = new JDBCMetaDataConfiguration();
            jcfg.setProperties(cfg.getProperties());
            monitor.beginTask(HibernateConsoleMessages.HibernateNature_reading_database_metadata, -1);
            try {
                this.ccfg.execute(new ExecutionContext.Command(){

                    public Object execute() {
                        jcfg.readFromJDBC();
                        return null;
                    }
                });
                ArrayList<Table> result = new ArrayList<Table>();
                Iterator tabs = jcfg.getTableMappings();
                while (tabs.hasNext()) {
                    Table table = (Table)tabs.next();
                    monitor.subTask(table.getName());
                    result.add(table);
                }
                HibernateNature.this.tables = result;
                monitor.done();
                return Status.OK_STATUS;
            }
            catch (Throwable t) {
                return new Status(4, "org.hibernate.eclipse.console", 1, HibernateConsoleMessages.HibernateNature_error_while_performing_background_reading_of_database_schema, t);
            }
        }
    }
}

