/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XChild;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.options.SharableElement;
import org.jboss.tools.common.model.options.impl.SharableComparator;
import org.jboss.tools.common.model.options.impl.XScope;
import org.jboss.tools.common.model.options.impl.XStudioLoaderPeer;

public class SharableElementImpl
extends XModelObjectImpl
implements SharableElement {
    private static final long serialVersionUID = 7922861006119791921L;
    private static final Map<String, String> singular = new HashMap<String, String>(3);
    protected XScope general_ = new XScope("general");
    protected XScope project_ = new XScope("project");
    protected Map<String, XScope> scopes = new HashMap<String, XScope>();
    protected XScope scope = this.project_;
    private Map<String, SharableElement> children = new HashMap<String, SharableElement>();
    private SharableComparator comparator = null;
    protected String name = "";

    static {
        singular.put("scope", "scope");
        singular.put("sharing", "sharing");
    }

    static boolean isSingular(String property) {
        return singular.get(property) != null;
    }

    public SharableElementImpl() {
        this.scopes.put("general", this.general_);
        this.scopes.put("project", this.project_);
    }

    @Override
    public SharableElement getSharableParent() {
        XModelObject p = this.getParent();
        return p instanceof SharableElement ? (SharableElement)p : null;
    }

    @Override
    public SharableElement[] getSharableChildren() {
        return this.children.values().toArray(new SharableElement[0]);
    }

    private int getChildrenCount(String entity) {
        SharableElement[] cs = this.getSharableChildren();
        int k = 0;
        int i = 0;
        while (i < cs.length) {
            if (entity.equals(cs[i].getModelEntity().getName())) {
                ++k;
            }
            ++i;
        }
        return k;
    }

    private void setScope0(String scopename) {
        this.scope = this.scopes.get(scopename);
        if (this.scope == null) {
            this.scope = this.project_;
        }
    }

    @Override
    public void setScope(String scopename) {
        this.setScope0(scopename);
        if (!this.scope.exists()) {
            this.scope.setExists(true);
        }
    }

    @Override
    public String getScope() {
        return this.scope.getName();
    }

    @Override
    public boolean exists() {
        return this.general_.exists() || this.project_.exists();
    }

    XScope getXScope(String scopename) {
        return this.scopes.get(scopename);
    }

    @Override
    public boolean scopeExists(String scopename) {
        XScope s = this.getXScope(scopename);
        return s != null && s.exists();
    }

    @Override
    public void setScopeExists(String scopename, boolean b) {
        XScope s = this.getXScope(scopename);
        if (s == null || s.exists() == b || !XStudioLoaderPeer.instance().isScopeEditable(scopename)) {
            return;
        }
        this.setScopeExists0(scopename, b);
    }

    void setScopeExists0(String scopename, boolean b) {
        XScope s = this.getXScope(scopename);
        if (s == null || s.exists() == b) {
            return;
        }
        s.setExists(b);
        if (!b) {
            SharableElement[] cs = this.getSharableChildren();
            int i = 0;
            while (i < cs.length) {
                SharableElementImpl c = (SharableElementImpl)cs[i];
                if (c != null) {
                    c.setScopeExists0(scopename, false);
                }
                ++i;
            }
        } else {
            SharableElementImpl p = (SharableElementImpl)this.getSharableParent();
            if (p != null) {
                p.setScopeExists0(scopename, true);
            }
        }
    }

    @Override
    protected void onSetEntity(String entityName) {
        XModelEntity entity = this.getModel().getMetaData().getEntity(entityName);
        XAttribute[] as = entity.getAttributes();
        int i = 0;
        while (i < LIST.length) {
            this.scope = this.scopes.get(LIST[i]);
            int j = 0;
            while (j < as.length) {
                if (!SharableElementImpl.isSingular(as[j].getName())) {
                    this.setAttributeValue(as[j].getName(), as[j].getDefaultValue());
                }
                ++j;
            }
            ++i;
        }
        this.comparator = new SharableComparator(entity.getChildren());
    }

    @Override
    public boolean addSharableChild(SharableElement child) {
        String childname = child.name();
        if (this.findSharableChild(childname) != null) {
            return false;
        }
        this.children.put(childname, child);
        return true;
    }

    @Override
    public void removeSharableChild(String name) {
        if (this.canRemoveChild(name)) {
            this.children.remove(name);
        }
    }

    public boolean canRemoveChild(String name) {
        SharableElementImpl s = (SharableElementImpl)this.children.get(name);
        if (s == null) {
            return false;
        }
        int i = 0;
        while (i < LIST.length) {
            XScope sc = s.getXScope(LIST[i]);
            if (sc.exists() && !XStudioLoaderPeer.instance().isScopeEditable(LIST[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public SharableElement findSharableChild(String childname) {
        return this.children.get(childname);
    }

    @Override
    public String get(String name) {
        if ("scope".equals(name)) {
            return this.getScope();
        }
        if ("sharing".equals(name)) {
            String x = String.valueOf(this.general_.exists() ? "general," : "") + (this.project_.exists() ? "project," : "");
            int c = x.length() - 1;
            return c < 0 ? "" : x.substring(0, c);
        }
        return "NAME".equals(name) ? this.name() : this.scope.getProperty(name);
    }

    @Override
    public void set(String name, String value) {
        if ("scope".equals(name)) {
            String ov = this.get(name);
            if (ov.equals(value)) {
                return;
            }
            String max = XStudioLoaderPeer.getMaxScope(ov, value);
            if (!XStudioLoaderPeer.instance().isScopeEditable(max)) {
                return;
            }
            this.setScope0(value);
            if (!this.scope.exists()) {
                this.setScopeExists(this.scope.getName(), true);
            }
        } else if ("sharing".equals(name)) {
            this.setScopeExists("general", value.indexOf("general") >= 0);
            this.setScopeExists("project", value.indexOf("project") >= 0);
        } else if ("NAME".equals(name)) {
            this.setName(value);
        } else {
            this.scope.setProperty(name, value);
        }
    }

    @Override
    public String getAttributeValue(String name, String scopename) {
        XScope current = this.scope;
        this.setScope0(scopename);
        String res = this.getAttributeValue(name);
        this.scope = current;
        return res;
    }

    public String getDefaultValue(String name) {
        XAttribute a = this.getModelEntity().getAttribute(name);
        if (a == null) {
            return null;
        }
        if (a.getXMLName() == null || a.getXMLName().length() == 0) {
            return a.getDefaultValue();
        }
        String v = this.getAttributeValue(name, "general");
        if (v == null || v.length() == 0) {
            v = a.getDefaultValue();
        }
        return v;
    }

    protected String getEntityName() {
        return "SharableDefault";
    }

    @Override
    public String name() {
        return this.name;
    }

    public void setName_0(String value) {
        this.name = value;
    }

    @Override
    public boolean setName(String value) {
        if (value == null) {
            return false;
        }
        String oldvalue = this.name();
        if (value.equals(oldvalue)) {
            return true;
        }
        SharableElement p = this.getSharableParent();
        if (p != null && p.findSharableChild(value) != null) {
            return false;
        }
        if (p != null && p.findSharableChild(oldvalue) == null) {
            return false;
        }
        String op = this.getPath();
        this.setName_0(value);
        if (p != null) {
            SharableElementImpl sp = (SharableElementImpl)p;
            sp.children.remove(oldvalue);
            sp.children.put(value, this);
            ((XModelImpl)this.getModel()).fireNodeChanged(this, op);
            this.fireUpdateChilds();
        }
        return true;
    }

    protected void fireUpdateChilds() {
    }

    @Override
    public boolean addChild_0(XModelObject child) {
        SharableElementImpl sc;
        if (child == null) {
            return false;
        }
        boolean res = false;
        String ce = child.getModelEntity().getName();
        XChild c_ent = this.getModelEntity().getChild(ce);
        if (c_ent == null) {
            return false;
        }
        if (c_ent.getMaxCount() < Integer.MAX_VALUE && this.getChildrenCount(ce) >= c_ent.getMaxCount()) {
            return false;
        }
        if (child instanceof SharableElement && (res = this.addSharableChild(sc = (SharableElementImpl)child))) {
            sc.setParent_0(this);
            int i = 0;
            while (i < LIST.length) {
                if (sc.scopeExists(LIST[i])) {
                    this.setScopeExists(LIST[i], true);
                }
                if (!this.scopeExists(LIST[i])) {
                    sc.scopes.get(LIST[i]).setExists(false);
                }
                ++i;
            }
        }
        return res;
    }

    @Override
    public void removeChild_0(XModelObject o) {
        if (o instanceof SharableElement) {
            this.removeSharableChild(((SharableElement)o).name());
        }
    }

    @Override
    public XModelObject[] getChildren() {
        XModelObject[] cs = this.getSharableChildren();
        Arrays.sort(cs, this.comparator);
        return cs;
    }

    @Override
    public boolean isObjectEditable() {
        return this.isScopeEditable(this.scope.getName());
    }

    public boolean isScopeEditable(String scopename) {
        return XStudioLoaderPeer.instance().isScopeEditable(scopename);
    }

    public boolean isScopeExists(String scopename) {
        XScope s = this.getXScope(scopename);
        return s != null && s.exists();
    }

    @Override
    public boolean isAttributeEditable(String attributeName) {
        return SharableElementImpl.isSingular(attributeName) || this.isObjectEditable();
    }

    private void shareProperties0(XScope fs, XScope ts) {
        Properties fp = fs.properties();
        Properties tp = ts.properties();
        Enumeration<Object> en = fp.keys();
        while (en.hasMoreElements()) {
            String key = (String)en.nextElement();
            String val = fp.getProperty(key);
            tp.setProperty(key, val);
        }
    }

    public void sharing(String fromscope, String toscope) {
        XScope fs = this.getXScope(fromscope);
        XScope ts = this.getXScope(toscope);
        if (!ts.exists()) {
            this.setScopeExists(toscope, true);
        }
        if (!ts.exists()) {
            return;
        }
        this.shareProperties0(fs, ts);
        this.childsharing(fromscope, toscope);
    }

    protected void childsharing(String fromscope, String toscope) {
        ((XModelImpl)this.getModel()).fireNodeChanged(this, this.getPath());
    }

    public void merge(String fromscope, String toscope, boolean merge_all) {
        XScope fs = this.getXScope(fromscope);
        XScope ts = this.getXScope(toscope);
        boolean existed = ts.exists();
        if (!existed) {
            this.setScopeExists(toscope, true);
        }
        if (!ts.exists()) {
            return;
        }
        if (!existed || merge_all) {
            this.shareProperties0(fs, ts);
        }
        this.mergeChildren(fromscope, toscope, existed, merge_all);
        this.setScope("project");
    }

    protected void mergeChildren(String fromscope, String toscope, boolean existed, boolean merge_all) {
        SharableElement[] cs = this.getSharableChildren();
        int i = 0;
        while (i < cs.length) {
            ((SharableElementImpl)cs[i]).merge(fromscope, toscope, merge_all);
            ++i;
        }
    }
}

