/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.mapper.factory;

import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.hibernate.eclipse.mapper.factory.UnknownNodeAdapter;
import org.hibernate.eclipse.mapper.model.DOMAdapter;
import org.hibernate.eclipse.mapper.model.DOMReverseEngineeringDefinition;
import org.hibernate.eclipse.mapper.model.RevEngColumnAdapter;
import org.hibernate.eclipse.mapper.model.RevEngGeneratorAdapter;
import org.hibernate.eclipse.mapper.model.RevEngParamAdapter;
import org.hibernate.eclipse.mapper.model.RevEngPrimaryKeyAdapter;
import org.hibernate.eclipse.mapper.model.RevEngTableAdapter;
import org.hibernate.eclipse.mapper.model.TableFilterAdapter;
import org.hibernate.eclipse.mapper.model.TypeMappingAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ObserverAdapterFactory
extends AbstractAdapterFactory {
    DOMReverseEngineeringDefinition revEngDefinition;

    public ObserverAdapterFactory(DOMReverseEngineeringDefinition revEngDefinition) {
        this.setAdapterKey(DOMAdapter.class);
        this.setShouldRegisterAdapter(true);
        this.revEngDefinition = revEngDefinition;
    }

    protected INodeAdapter createAdapter(INodeNotifier target) {
        Node n = (Node)target;
        String nodeName = n.getNodeName();
        Object result = null;
        Class<DOMAdapter> key = DOMAdapter.class;
        if ("hibernate-reverse-engineering".equals(nodeName)) {
            result = new UnknownNodeAdapter(key, this.revEngDefinition){

                public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                    this.observer.hibernateMappingChanged();
                }
            };
        } else if ("table-filter".equals(nodeName)) {
            result = new TableFilterAdapter((Node)target, this.revEngDefinition);
        } else if ("type-mapping".equals(nodeName)) {
            result = new UnknownNodeAdapter(key, this.revEngDefinition){

                public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                    this.observer.typeMappingChanged(notifier);
                }
            };
        } else if ("sql-type".equals(nodeName)) {
            result = new TypeMappingAdapter((Node)target, this.revEngDefinition);
        } else if ("table".equals(nodeName)) {
            result = new RevEngTableAdapter((Node)target, this.revEngDefinition);
        } else if ("column".equals(nodeName) || "key-column".equals(nodeName)) {
            result = new RevEngColumnAdapter((Node)target, this.revEngDefinition);
        } else if ("primary-key".equals(nodeName)) {
            result = new RevEngPrimaryKeyAdapter((Node)target, this.revEngDefinition);
        } else if ("generator".equals(nodeName)) {
            result = new RevEngGeneratorAdapter((Node)target, this.revEngDefinition);
        } else if ("param".equals(nodeName)) {
            result = new RevEngParamAdapter((Node)target, this.revEngDefinition);
        } else if ("foreign-key".equals(nodeName) || "column-ref".equals(nodeName)) {
            result = new UnknownNodeAdapter(key, this.revEngDefinition){

                public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
                    this.observer.tablesChanged(notifier);
                }
            };
        }
        if (result == null) {
            result = new UnknownNodeAdapter(key, this.revEngDefinition);
        }
        if (result != null) {
            this.adaptChildren((Node)target);
        }
        return result;
    }

    private void adaptChildren(Node node) {
        NodeList nodes = node.getChildNodes();
        int i = 0;
        while (i < nodes.getLength()) {
            this.adapt((INodeNotifier)nodes.item(i));
            ++i;
        }
    }

    protected UnknownNodeAdapter doAdapt(Object object) {
        UnknownNodeAdapter result = null;
        if (object instanceof INodeNotifier) {
            result = (UnknownNodeAdapter)this.adapt((INodeNotifier)object);
        }
        return result;
    }
}

