/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.actions;

import java.util.Iterator;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;

public class PMDRemoveMarkersAction
implements IViewActionDelegate,
IObjectActionDelegate {
    private static final String VIEW_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveAllMarkersAction";
    private static final String OBJECT_ACTION = "net.sourceforge.pmd.eclipse.ui.pmdRemoveMarkersAction";
    private static final Logger log;
    private IWorkbenchPart targetPart;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.ui.actions.PMDRemoveMarkersAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public void init(IViewPart iViewPart) {
    }

    public void run(IAction iAction) {
        log.info((Object)"Remove Markers action requested");
        try {
            if (iAction.getId().equals(VIEW_ACTION)) {
                ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
                ResourcesPlugin.getWorkspace().getRoot().deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdDFAMarker", true, 2);
                log.debug((Object)"Remove markers on the entire workspace");
            } else if (iAction.getId().equals(OBJECT_ACTION)) {
                this.processResource();
            } else {
                log.warn((Object)"Cannot remove markers, action ID is not supported");
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.core_exception"), coreException);
        }
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
    }

    public void setActivePart(IAction iAction, IWorkbenchPart iWorkbenchPart) {
        this.targetPart = iWorkbenchPart;
    }

    private void processResource() {
        log.debug((Object)"Processing a resource");
        try {
            if (this.targetPart instanceof IViewPart) {
                ISelection iSelection = this.targetPart.getSite().getSelectionProvider().getSelection();
                if (iSelection instanceof IStructuredSelection) {
                    IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                    Iterator iterator = iStructuredSelection.iterator();
                    while (iterator.hasNext()) {
                        Object e = iterator.next();
                        this.processElement(e);
                    }
                } else {
                    log.warn((Object)"The view part selection is not a structured selection !");
                }
            } else if (this.targetPart instanceof IEditorPart) {
                IEditorInput iEditorInput = ((IEditorPart)this.targetPart).getEditorInput();
                if (iEditorInput instanceof IFileEditorInput) {
                    ((IFileEditorInput)iEditorInput).getFile().deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
                    log.debug((Object)("Remove markers net.sourceforge.pmd.eclipse.plugin.pmdMarker on currently edited file " + ((IFileEditorInput)iEditorInput).getFile().getName()));
                } else {
                    log.debug((Object)("The kind of editor input is not supported. The editor input if of type: " + iEditorInput.getClass().getName()));
                }
            } else {
                log.debug((Object)("This action is not supported on that part. This part type is: " + this.targetPart.getClass().getName()));
            }
        }
        catch (CoreException coreException) {
            PMDPlugin.getDefault().showError(this.getString("message.error.core_exception"), coreException);
        }
    }

    private void processElement(Object object) throws CoreException {
        if (object instanceof AbstractPMDRecord) {
            AbstractPMDRecord abstractPMDRecord = (AbstractPMDRecord)object;
            IResource iResource = abstractPMDRecord.getResource();
            if (this.targetPart instanceof ViolationOverview) {
                ((ViolationOverview)this.targetPart).deleteMarkers(abstractPMDRecord);
            }
            log.debug((Object)("Remove markers on resource " + iResource.getName()));
        } else if (object instanceof IAdaptable) {
            IResource iResource;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((iResource = (IResource)iAdaptable.getAdapter((Class)clazz)) == null) {
                log.warn((Object)"The selected object cannot adapt to a resource");
                log.debug((Object)("   -> selected object : " + object));
            } else {
                iResource.deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
                log.debug((Object)("Remove markers on resrouce " + iResource.getName()));
            }
        } else {
            log.warn((Object)"The selected object is not adaptable");
            log.debug((Object)("   -> selected object : " + object));
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

