/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.handlers.page;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.jboss.tools.common.meta.action.impl.AbstractHandler;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.jst.web.browser.AbstractBrowserContext;
import org.jboss.tools.struts.StrutsConstants;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.model.handlers.page.IPathSourceImpl;
import org.jboss.tools.struts.model.helpers.StrutsProcessStructureHelper;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;

public abstract class RunHandler
extends AbstractHandler
implements StrutsConstants {
    public boolean isEnabled(XModelObject object) {
        if (object == null || !object.isActive()) {
            return false;
        }
        if (object == object.getModel().getRoot()) {
            return true;
        }
        String type = object.getAttributeValue("type");
        String entity = object.getModelEntity().getName();
        if ("page".equals(type)) {
            if (!"true".equals(object.get("confirmed"))) {
                return false;
            }
            if ((object = StrutsProcessStructureHelper.instance.getPhysicalPage(object)) == null) {
                return false;
            }
        }
        if (object.getFileType() == 1) {
            String ext = "." + object.getAttributeValue("extension") + ".";
            return ".jsp.htm.html.tld.".indexOf(ext) >= 0 && this.isWebPage(object);
        }
        if ("action".equals(type)) {
            return !"unknown".equals(object.getAttributeValue("subtype"));
        }
        if (entity.startsWith("StrutsAction")) {
            return true;
        }
        return IPathSourceImpl.isForward(object);
    }

    public void executeHandler(XModelObject object, Properties p) throws XModelException {
        if (!this.isEnabled(object)) {
            return;
        }
        this.getContext().execute(object);
    }

    protected abstract AbstractBrowserContext getContext();

    private boolean isWebPage(XModelObject o) {
        XModelObject fs = o;
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        return this.isRootUnderWebRoot(fs);
    }

    private boolean isRootUnderWebRoot(XModelObject fs) {
        if (fs == null) {
            return false;
        }
        XModelObject wr = WebModulesHelper.getInstance(fs.getModel()).getFileSystem("");
        if (wr == null) {
            return false;
        }
        if (wr == fs) {
            return true;
        }
        Map<String, XModelObject> map = WebModulesHelper.getInstance(fs.getModel()).getWebFileSystems();
        if (!map.containsValue(fs)) {
            return false;
        }
        String p1 = this.getCanonicalLocation(wr);
        String p2 = this.getCanonicalLocation(fs);
        return p1 != null && p2 != null && p2.startsWith(String.valueOf(p1) + "/");
    }

    private String getCanonicalLocation(XModelObject fs) {
        String path = XModelObjectUtil.getExpandedValue((XModelObject)fs, (String)"location", null);
        try {
            return new File(path).getCanonicalPath().replace('\\', '/').toLowerCase();
        }
        catch (Exception e) {
            StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }
}

