/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsLoader;
import org.jboss.tools.common.model.filesystems.impl.JarSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.LibraryNames;
import org.jboss.tools.common.model.filesystems.impl.LibsListener;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;

public class Libs
implements IElementChangedListener {
    protected FileSystemsImpl object;
    protected List<String> paths = null;
    Map<IPath, String> paths2 = new HashMap<IPath, String>();
    Set<String> projects = new HashSet<String>();
    LibraryNames libraryNames = new LibraryNames();
    int excudedState = 0;
    List<LibsListener> listeners = new ArrayList<LibsListener>();
    public static String LIB_PREFIX = "lib-";
    int classpathVersion = 0;
    int pathsVersion = -1;
    int fsVersion = -1;

    public Libs(FileSystemsImpl object) {
        this.object = object;
    }

    public void init() {
        JavaCore.addElementChangedListener((IElementChangedListener)this);
    }

    private IProject getProjectResource() {
        return EclipseResourceUtil.getProject(this.object);
    }

    public XModelObject getLibrary(String path) {
        String libName = this.libraryNames.getName(path);
        if (libName == null) {
            libName = String.valueOf(LIB_PREFIX) + new File(path).getName();
        }
        return this.object.getChildByPath(libName);
    }

    public XModelObject getLibrary(File f) {
        XModelObject result = null;
        if (f.exists()) {
            String path = f.getAbsolutePath().replace('\\', '/');
            result = this.getLibrary(path);
        }
        return result;
    }

    public boolean update() {
        boolean result = false;
        int cpv = this.classpathVersion;
        if (this.hasToUpdatePaths()) {
            result = this.updatePaths(this.getNewPaths(), cpv);
            if (this.isExcludedStateChanged()) {
                result = true;
            }
            if (result) {
                this.fire();
            }
            if (this.paths == null && result) {
                return true;
            }
        }
        if (this.paths != null) {
            this.updateFileSystems(this.paths);
        }
        this.fsVersion = this.pathsVersion;
        return result;
    }

    public void requestForUpdate() {
        ++this.classpathVersion;
    }

    synchronized boolean hasToUpdatePaths() {
        return this.classpathVersion > this.pathsVersion;
    }

    private List<String> getNewPaths() {
        List<String> result = null;
        try {
            result = EclipseResourceUtil.getAllVisibleLibraries(this.getProjectResource());
            List<String> jre = EclipseResourceUtil.getJREClassPath(this.getProjectResource());
            if (jre != null) {
                result.removeAll(jre);
            }
            this.updateProjects();
        }
        catch (CoreException e) {
            ModelPlugin.getDefault().logError(e);
        }
        return result;
    }

    private void updateProjects() throws JavaModelException {
        HashSet<String> result = new HashSet<String>();
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)this.getProjectResource());
        if (javaProject != null) {
            result.add(this.getProjectResource().getName());
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IProject p;
                if (es[i].getEntryKind() == 2 && (p = ResourcesPlugin.getWorkspace().getRoot().getProject(es[i].getPath().lastSegment())) != null && p.isAccessible()) {
                    result.add(p.getName());
                }
                ++i;
            }
        }
        this.projects = result;
    }

    private boolean isExcludedStateChanged() {
        try {
            int es = this.computeExcludedState();
            if (es != this.excudedState) {
                this.excudedState = es;
                return true;
            }
        }
        catch (JavaModelException e) {
            ModelPlugin.getDefault().logError(e);
        }
        return false;
    }

    private int computeExcludedState() throws JavaModelException {
        int result = 0;
        IJavaProject javaProject = EclipseResourceUtil.getJavaProject((IProject)this.getProjectResource());
        if (javaProject != null) {
            IClasspathEntry[] es = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < es.length) {
                IPath p = es[i].getPath();
                IPath[] ps = es[i].getExclusionPatterns();
                if (ps != null && ps.length > 0) {
                    int j = 0;
                    while (j < ps.length) {
                        String key = String.valueOf(p.toString()) + "/" + ps[j].toString();
                        result += key.hashCode();
                        ++j;
                    }
                }
                ++i;
            }
        }
        return result;
    }

    private synchronized boolean updatePaths(List<String> newPaths, int cpv) {
        if (cpv <= this.pathsVersion) {
            return false;
        }
        this.pathsVersion = cpv;
        if (this.paths == null && newPaths == null) {
            return false;
        }
        if (newPaths != null && this.paths != null && this.paths.size() == newPaths.size()) {
            boolean b = false;
            int i = 0;
            while (i < this.paths.size() && !b) {
                if (!this.paths.get(i).equals(newPaths.get(i))) {
                    b = true;
                }
                ++i;
            }
            if (!b) {
                return false;
            }
        }
        this.paths = newPaths;
        this.createMap();
        return true;
    }

    void updateFileSystems(List<String> paths) {
        if (this.fsVersion >= this.pathsVersion) {
            return;
        }
        Set<String> oldPaths = this.libraryNames.getPaths();
        for (String p : oldPaths) {
            if (paths.contains(p)) continue;
            String n = this.libraryNames.getName(p);
            XModelObject o = this.object.getChildByPath(n);
            if (o != null) {
                o.removeFromParent();
            }
            this.libraryNames.removePath(p);
        }
        XModelObject[] fs = this.object.getChildren();
        HashSet<XModelObject> fss = new HashSet<XModelObject>();
        int i = 0;
        while (i < fs.length) {
            if (fs[i].getAttributeValue("name").startsWith(LIB_PREFIX)) {
                fss.add(fs[i]);
            }
            ++i;
        }
        if (paths != null) {
            i = 0;
            while (i < paths.size()) {
                String path = paths.get(i);
                boolean isJar = EclipseResourceUtil.isJar(path);
                String libEntity = isJar ? "FileSystemJar" : "FileSystemFolder";
                String fileName = new File(path).getName();
                if (!isJar || !EclipseResourceUtil.SYSTEM_JAR_SET.contains(fileName)) {
                    XModelObject o;
                    String jsname = this.libraryNames.getName(path);
                    if (jsname == null) {
                        jsname = String.valueOf(LIB_PREFIX) + fileName;
                        int q = 0;
                        while (this.libraryNames.hasName(jsname)) {
                            jsname = String.valueOf(LIB_PREFIX) + fileName + "-" + ++q;
                        }
                    }
                    if ((o = this.object.getChildByPath(jsname)) != null) {
                        fss.remove(o);
                        if (o instanceof JarSystemImpl) {
                            ((JarSystemImpl)o).update();
                        }
                    } else {
                        o = this.object.getModel().createModelObject(libEntity, null);
                        o.setAttributeValue("name", jsname);
                        o.setAttributeValue("location", path);
                        o.set(FileSystemsLoader.IS_ADDED_TO_CLASSPATH, "true");
                        this.object.addChild(o);
                    }
                    this.libraryNames.put(path, jsname);
                }
                ++i;
            }
        }
        for (XModelObject o : fss) {
            String path = XModelObjectUtil.expand(o.getAttributeValue("location"), o.getModel(), null);
            if ("true".equals(o.get(FileSystemsLoader.IS_ADDED_TO_CLASSPATH))) {
                o.removeFromParent();
                continue;
            }
            if (new File(path).exists()) continue;
            o.removeFromParent();
        }
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public Map<IPath, String> getPathsAsMap() {
        return this.paths2;
    }

    private void createMap() {
        this.paths2.clear();
        if (this.paths != null) {
            for (String p : this.paths) {
                this.paths2.put((IPath)new Path(p), p);
            }
        }
    }

    public synchronized void addListener(LibsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(LibsListener listener) {
        this.listeners.remove(listener);
    }

    void fire() {
        LibsListener[] libsListenerArray = this.getListeners();
        int n = libsListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibsListener listener = libsListenerArray[n2];
            listener.pathsChanged(this.paths);
            ++n2;
        }
    }

    private synchronized LibsListener[] getListeners() {
        return this.listeners.toArray(new LibsListener[0]);
    }

    public void elementChanged(ElementChangedEvent event) {
        IProject project = this.getProjectResource();
        if (project == null || !project.exists()) {
            JavaCore.removeElementChangedListener((IElementChangedListener)this);
            return;
        }
        IJavaElementDelta[] iJavaElementDeltaArray = event.getDelta().getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta dc = iJavaElementDeltaArray[n2];
            if (dc.getElement() instanceof IJavaProject && this.isReleventProject(((IJavaProject)dc.getElement()).getProject())) {
                int f = dc.getFlags();
                if ((f & 0x220000) != 0) {
                    this.requestForUpdate();
                    return;
                }
                IJavaElementDelta[] iJavaElementDeltaArray2 = dc.getAffectedChildren();
                int n3 = iJavaElementDeltaArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IJavaElementDelta d1 = iJavaElementDeltaArray2[n4];
                    d1.getElement();
                    if (d1.getKind() == 1) {
                        this.requestForUpdate();
                        return;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private boolean isReleventProject(IProject p) {
        return this.projects.contains(p.getName());
    }

    public void libraryChanged(JarSystemImpl jar) {
        LibsListener[] libsListenerArray = this.getListeners();
        int n = libsListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            LibsListener listener = libsListenerArray[n2];
            listener.libraryChanged(jar.getLocation());
            ++n2;
        }
    }
}

