/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.model.pv;

import java.util.ArrayList;
import java.util.HashSet;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.impl.XModelImpl;
import org.jboss.tools.common.model.impl.trees.FileSystemsTree;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.jst.web.model.pv.WebProjectNode;
import org.jboss.tools.struts.model.pv.StrutsProjectsRoot;

public class StrutsProjectsTree
extends FileSystemsTree
implements XModelTreeListener {
    StrutsProjectsRoot root = null;
    XModelObject webinf = null;

    protected boolean isConstraintRelevant(String key) {
        return super.isConstraintRelevant(key) || key.startsWith("StrutsProjects$");
    }

    public void setModel(XModel model) {
        super.setModel(model);
        this.root = (StrutsProjectsRoot)model.getByPath("root:StrutsProjects");
        if (this.root == null) {
            this.root = (StrutsProjectsRoot)model.createModelObject("StrutsProjectsRoot", null);
            ((XModelImpl)model).setExtraRoot((XModelObject)this.root);
            model.addModelTreeListener((XModelTreeListener)this);
        } else {
            this.root.invalidate();
        }
    }

    public static StrutsProjectsRoot getProjectsRoot(XModel model) {
        StrutsProjectsRoot root = (StrutsProjectsRoot)model.getByPath("root:StrutsProjects");
        if (root == null) {
            root = (StrutsProjectsRoot)XModelObjectLoaderUtil.createValidObject((XModel)model, (String)"StrutsProjectsRoot");
            ((XModelImpl)model).setExtraRoot((XModelObject)root);
        }
        return root;
    }

    public XModelObject getRoot() {
        return this.root;
    }

    public XModelObject[] getChildren(XModelObject object) {
        if (object instanceof WebProjectNode) {
            return ((WebProjectNode)object).getTreeChildren();
        }
        if (object == this.root.webroot) {
            XModelObject[] cs = super.getChildren(object);
            XModelObject web = object.getModel().getByPath("Web");
            XModelObject[] ws = web == null ? new XModelObject[]{} : web.getChildren();
            this.webinf = FileSystemsHelper.getWebInf((XModel)object.getModel());
            ArrayList<XModelObject> l = new ArrayList<XModelObject>();
            if (this.webinf != null) {
                l.add(this.webinf);
            }
            HashSet<String> roots = new HashSet<String>();
            roots.add(this.root.webroot.getAttributeValue("name"));
            int i = 0;
            while (i < ws.length) {
                String fsn;
                String module = ws[i].getAttributeValue("name");
                if (module.length() != 0 && !roots.contains(fsn = ws[i].getAttributeValue("root file system"))) {
                    roots.add(fsn);
                    XModelObject fs = FileSystemsHelper.getFileSystem((XModel)object.getModel(), (String)fsn);
                    if (fs != null) {
                        l.add(fs);
                    }
                }
                ++i;
            }
            i = 0;
            while (i < cs.length) {
                l.add(cs[i]);
                ++i;
            }
            cs = l.toArray(new XModelObject[0]);
            return cs;
        }
        return super.getChildren(object);
    }

    public XModelObject getParent(XModelObject object) {
        return object == this.root ? null : (object == this.webinf ? this.root.webroot : ("FileSystemFolder".equals(object.getModelEntity().getName()) && object != this.root.webroot ? this.root.webroot : this.root.getTreeParent(object)));
    }

    public boolean hasChildren(XModelObject object) {
        return object instanceof WebProjectNode || super.hasChildren(object);
    }

    public void nodeChanged(XModelTreeEvent event) {
    }

    public void structureChanged(XModelTreeEvent event) {
        XModelObject source = event.getModelObject();
        String entity = source.getModelEntity().getName();
        if (event.kind() == 3 && "FileSystemJar".equals(entity) && this.root != null) {
            this.root.invalidate();
        }
    }
}

