/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.adopt;

import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.impl.Libs;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.context.IImportWebProjectContext;
import org.jboss.tools.jst.web.project.helpers.NewWebProjectHelper;
import org.jboss.tools.struts.webprj.model.helpers.sync.SortFileSystems;

public class AdoptProjectFinisher {
    protected IImportWebProjectContext context = null;
    protected XModel model = null;
    protected XModelObject web;
    protected XModelObject fss;
    protected String workspace = null;
    protected String srclocation = "";
    protected Map<String, XModelObject> filesystems = new HashMap<String, XModelObject>();

    public void setContext(XModel model, IImportWebProjectContext context) {
        this.context = context;
        this.model = model;
    }

    public void execute() throws XModelException {
        this.filesystems.clear();
        this.workspace = this.context.getWebInfLocation();
        this.fss = this.model.getByPath("FileSystems");
        this.web = this.model.getByPath("Web");
        this.createBuildFileSystem();
        this.createWebInfFileSystem();
        this.createWebXMLFileSystem();
        this.createInfFileSystems();
        this.createWebRootFileSystem();
        this.createModuleFileSystems();
        this.createSrcFileSystems();
        this.createClassesFileSystem();
        this.createLibFileSystems();
        String an = this.context.getApplicationName();
        if (an == null) {
            an = this.context.getProjectName();
        }
        this.fss.setAttributeValue("application name", an);
        this.fss.setModified(true);
        this.appendModules();
        SortFileSystems.sort(this.model);
        this.model.save();
        NewWebProjectHelper.updateOverlapped((XModel)this.model);
    }

    private XModelObject getOrCreateFileSystem(String name, String location, boolean req) {
        return this.getOrCreateFileSystem(name, location, null, req, false);
    }

    private XModelObject getOrCreateFileSystem(String name, String location, String info) {
        return this.getOrCreateFileSystem(name, location, info, true, false);
    }

    private XModelObject getOrCreateFileSystem(String name, String location, String info, boolean req, boolean jar) {
        XModelObject fs;
        XModelObject xModelObject = fs = req ? null : this.filesystems.get(location);
        if (fs != null) {
            return fs;
        }
        String entity = !jar ? "FileSystemFolder" : "FileSystemJar";
        fs = this.model.createModelObject(entity, null);
        fs.setAttributeValue("name", name);
        fs.setAttributeValue("location", location);
        if (info != null) {
            fs.setAttributeValue("info", info);
        }
        this.fss.addChild(fs);
        this.filesystems.put(location, fs);
        return fs;
    }

    private void createWebInfFileSystem() {
        this.getOrCreateFileSystem("WEB-INF", XModelConstants.WORKSPACE_REF, true);
    }

    private void createWebXMLFileSystem() {
        File webxml = new File(this.context.getWebXmlLocation());
        String webxmlfolder = webxml.getParent();
        String relative = AdoptProjectFinisher.getRelativePath(this.workspace, webxmlfolder);
        if (relative == null || relative.startsWith("/..")) {
            String loc = relative == null ? webxmlfolder : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
            this.getOrCreateFileSystem("web-xml", loc, true);
            this.web.setAttributeValue("model path", "/" + webxml.getName());
        } else {
            this.web.setAttributeValue("model path", String.valueOf(relative) + "/" + webxml.getName());
        }
    }

    private void createInfFileSystems() {
        XModelObject m = this.getDefaultModule();
        if (m != null) {
            this.createInfFileSystem(m, "default");
        }
        XModelObject[] ms = this.context.getModules();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("name").length() != 0) {
                this.createInfFileSystem(ms[i], ms[i].getAttributeValue("name").substring(1));
            }
            ++i;
        }
    }

    private void createInfFileSystem(XModelObject m, String fsn) {
        File config = new File(m.getAttributeValue("path on disk"));
        String configLoc = config.getParent();
        String relative = AdoptProjectFinisher.getRelativePath(this.workspace, configLoc);
        if (relative == null || relative.startsWith("/..")) {
            String loc = relative == null ? configLoc : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
            this.getOrCreateFileSystem(String.valueOf(fsn) + "-config-xml", loc, false);
            m.setAttributeValue("model path", "/" + config.getName());
        } else {
            m.setAttributeValue("model path", String.valueOf(relative) + "/" + config.getName());
        }
        XModelObject[] cs = m.getChildren();
        int i = 0;
        while (i < cs.length) {
            this.createInfFileSystem(cs[i], fsn);
            ++i;
        }
    }

    private XModelObject getDefaultModule() {
        XModelObject[] ms = this.context.getModules();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("name").length() == 0) {
                return ms[i];
            }
            ++i;
        }
        return null;
    }

    private void createWebRootFileSystem() {
        XModelObject m = this.getDefaultModule();
        if (m == null) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, m.getAttributeValue("root"));
        m.setAttributeValue("root file system", "WEB-ROOT");
        this.getOrCreateFileSystem("WEB-ROOT", loc, "Content-Type=Web");
    }

    private void createModuleFileSystems() {
        XModelObject[] ms = this.context.getModules();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("name").length() != 0) {
                this.createModuleFileSystem(ms[i]);
            }
            ++i;
        }
    }

    private void createModuleFileSystem(XModelObject m) {
        String n = m.getAttributeValue("name");
        String fsn = n.substring(1).replace('/', '#');
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, m.getAttributeValue("root"));
        m.setAttributeValue("root file system", fsn);
        this.getOrCreateFileSystem(fsn, loc, "Content-Type=Web,Struts-Module=" + n);
    }

    private void createSrcFileSystems() {
        this.createWebRootSrcFileSystem();
        XModelObject[] ms = this.context.getModules();
        int i = 0;
        while (i < ms.length) {
            if (ms[i].getAttributeValue("name").length() != 0) {
                this.createModuleSrcFileSystem(ms[i]);
            }
            ++i;
        }
    }

    private void createWebRootSrcFileSystem() {
        XModelObject m = this.getDefaultModule();
        this.srclocation = m.getAttributeValue("java src");
        if (this.srclocation.length() == 0) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, this.srclocation);
        String fsn = "src";
        m.setAttributeValue("src file system", fsn);
        this.getOrCreateFileSystem("src", loc, false);
    }

    private void createModuleSrcFileSystem(XModelObject m) {
        String src = m.getAttributeValue("java src");
        String n = m.getAttributeValue("name").substring(1);
        if (src.length() == 0 || src.equalsIgnoreCase(this.srclocation)) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, src);
        String fsn = "src-" + n;
        m.setAttributeValue("src file system", fsn);
        this.getOrCreateFileSystem(fsn, loc, false);
    }

    private void createLibFileSystems() {
        String lib = this.context.getLibLocation();
        if (lib == null || lib.length() == 0) {
            return;
        }
        File f = new File(lib);
        if (!f.isDirectory()) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, lib);
        this.getOrCreateFileSystem("lib", loc, true);
        File[] jars = f.listFiles(new FileFilter(){

            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String name = file.getName().toLowerCase();
                return name.endsWith(".jar") || name.endsWith(".zip");
            }
        });
        if (jars != null) {
            int i = 0;
            while (i < jars.length) {
                String n = jars[i].getName();
                this.getOrCreateFileSystem(String.valueOf(Libs.LIB_PREFIX) + n, String.valueOf(loc) + "/" + n, "hidden=yes", true, true);
                ++i;
            }
        }
    }

    private void createClassesFileSystem() {
        String classes = this.context.getClassesLocation();
        if (classes == null || classes.length() == 0) {
            return;
        }
        if (!new File(classes).isDirectory()) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, classes);
        this.getOrCreateFileSystem("classes", loc, false);
    }

    private void createBuildFileSystem() {
        String build = this.context.getBuildXmlLocation();
        if (build == null || build.length() == 0) {
            return;
        }
        File f = new File(build);
        if (f.isFile()) {
            f = f.getParentFile();
            build = f.getAbsolutePath();
        }
        if (!new File(build).isDirectory()) {
            return;
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, build);
        this.getOrCreateFileSystem("build", loc, false);
    }

    protected void appendModules() {
        XModelObject[] ms = this.web.getChildren("JstWebModule");
        int i = 0;
        while (i < ms.length) {
            ms[i].removeFromParent();
            ++i;
        }
        ms = this.context.getModules();
        i = 0;
        while (i < ms.length) {
            this.web.addChild(ms[i]);
            ++i;
        }
        this.web.setModified(true);
    }

    public static String getRelativePath(String rootpath, String path) {
        return FileUtil.getRelativePath((String)rootpath, (String)path);
    }

    public static String getFileSystemLocation(String rootpath, String path) {
        String relative = AdoptProjectFinisher.getRelativePath(rootpath, path = path.replace('\\', '/'));
        return relative == null ? path : String.valueOf(XModelConstants.WORKSPACE_REF) + relative;
    }
}

