/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.struts.webprj.model.helpers.sync;

import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.action.SpecialWizard;
import org.jboss.tools.common.meta.action.SpecialWizardFactory;
import org.jboss.tools.common.meta.action.XActionInvoker;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultCreateHandler;
import org.jboss.tools.common.meta.action.impl.handlers.DefaultRemoveHandler;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.project.IWatcherContributor;
import org.jboss.tools.common.model.undo.XTransactionUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.undo.XUndoable;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.model.util.XModelObjectUtil;
import org.jboss.tools.common.util.FileUtil;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebModuleConstants;
import org.jboss.tools.jst.web.project.WebModuleImpl;
import org.jboss.tools.struts.StrutsModelPlugin;
import org.jboss.tools.struts.messages.StrutsUIMessages;
import org.jboss.tools.struts.webprj.model.helpers.WebModulesHelper;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectContext;
import org.jboss.tools.struts.webprj.model.helpers.adopt.AdoptProjectFinisher;
import org.jboss.tools.struts.webprj.model.helpers.sync.ModulesDataValidator;
import org.jboss.tools.struts.webprj.model.helpers.sync.SortFileSystems;
import org.jboss.tools.struts.webprj.model.helpers.sync.StrutsWebHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyncProjectContext
implements WebModuleConstants,
IWatcherContributor {
    AdoptProjectContext adoptContext = new AdoptProjectContext();
    protected XModel model;
    protected XModelObject webxml;
    protected XModelObject web;
    protected File webinf;
    protected Properties data = new Properties();
    protected Map<String, String> describedModules = new HashMap<String, String>();
    protected Map<String, XModelObject> installedModules = new HashMap<String, XModelObject>();
    protected ArrayList<XModelObject> modules = new ArrayList();
    protected Map<String, XModelObject> modulesMap = new TreeMap<String, XModelObject>();
    protected String workspace;
    XModelObject servlet = null;
    HashMap<String, XModelObject> oldFileSystems = new HashMap();
    HashMap<String, XModelObject> newFileSystems = new HashMap();
    Map<String, String> replacedSrc = new HashMap<String, String>();
    ModulesDataValidator modulesValidator = new ModulesDataValidator();

    public SyncProjectContext() {
        this.data.put("describedModules", this.describedModules);
        this.data.put("installedModules", this.installedModules);
        this.data.put("modules", this.modules);
    }

    public void setModel(XModel model) {
        this.model = model;
        this.webxml = WebAppHelper.getWebApp((XModel)model);
        this.web = model.getByPath("Web");
        this.workspace = new File(XModelConstants.getWorkspace((XModel)model)).getAbsolutePath().replace('\\', '/');
        this.webinf = new File(XModelConstants.getWorkspace((XModel)model));
    }

    XModelObject getWebObject() {
        if (this.web != null || this.model == null) {
            return this.web;
        }
        this.web = this.model.getByPath("Web");
        return this.web;
    }

    public XModelObject getWebXML() {
        return this.webxml;
    }

    public void update(boolean merge) {
        this.updateDescribedModulesInfo();
        this.updateInstalledModulesInfo();
        if (merge) {
            this.updateModulesInfo();
        }
    }

    public boolean isWebXMLFound() {
        return this.webxml != null;
    }

    public boolean isWebXMLCorrect() {
        return this.webxml != null && !"yes".equals(this.webxml.get("isIncorrect"));
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateDescribedModulesInfo() {
        modified = false;
        ms = AdoptProjectContext.getModules(this.webxml);
        d = new HashMap<String, String>();
        d.putAll(this.describedModules);
        i = 0;
        while (i < ms.length) {
            s = (String)d.remove(ms[i][0]);
            if (s == null || !s.equals(ms[i][1])) {
                modified = true;
                this.describedModules.put(ms[i][0], ms[i][1]);
            }
            ++i;
        }
        modified |= d.size() > 0;
        it = d.keySet().iterator();
        if (it != null) ** GOTO lbl20
        return false;
lbl-1000:
        // 1 sources

        {
            this.describedModules.remove(it.next());
lbl20:
            // 2 sources

            ** while (it.hasNext())
        }
lbl21:
        // 1 sources

        return modified;
    }

    private boolean updateInstalledModulesInfo() {
        boolean modified = false;
        if (this.getWebObject() == null) {
            return false;
        }
        XModelObject[] cs = this.web.getChildren(WebModulesHelper.ENT_STRUTS_WEB_MODULE);
        HashMap<String, XModelObject> d = new HashMap<String, XModelObject>();
        d.putAll(this.installedModules);
        int i = 0;
        while (i < cs.length) {
            String n = cs[i].getAttributeValue("name");
            XModelObject c = (XModelObject)d.remove(n);
            if (c != cs[i]) {
                modified = true;
                this.installedModules.put(n, cs[i]);
            }
            ++i;
        }
        modified |= d.size() > 0;
        Iterator it = d.keySet().iterator();
        while (it.hasNext()) {
            this.installedModules.remove(it.next());
        }
        return modified;
    }

    private void updateModulesInfo() {
        this.modulesMap.clear();
        HashMap<String, XModelObject> d = new HashMap<String, XModelObject>();
        d.putAll(this.installedModules);
        for (String n : this.describedModules.keySet()) {
            String uri = this.describedModules.get(n);
            WebModuleImpl m = (WebModuleImpl)d.remove(n);
            if (m == null) {
                m = (WebModuleImpl)this.adoptContext.createModuleInfo(this.model, n, uri, this.webinf, false);
                m.set("state", "not installed");
            } else {
                this.setAbsolutePaths((XModelObject)m);
                m = (WebModuleImpl)m.copy();
                m.setURI(uri);
                m.set("state", "installed");
            }
            this.modulesMap.put(n, (XModelObject)m);
        }
        for (String n : d.keySet()) {
            XModelObject m = (XModelObject)d.get(n);
            this.setAbsolutePaths(m);
            m = m.copy();
            m.set("state", "deleted");
            this.modulesMap.put(n, m);
        }
        this.refillModuleList();
    }

    private void refillModuleList() {
        this.modules.clear();
        String[] ms = this.modulesMap.keySet().toArray(new String[0]);
        int i = 0;
        while (i < ms.length) {
            XModelObject o = this.modulesMap.get(ms[i]);
            this.modules.add(o);
            XModelObject[] oc = o.getChildren();
            int k = 0;
            while (k < oc.length) {
                this.modules.add(oc[k]);
                ++k;
            }
            ++i;
        }
    }

    private void setAbsolutePaths(XModelObject m) {
        String rfs = m.getAttributeValue("root file system");
        XModelObject fs = this.model.getByPath("FileSystems/" + rfs);
        String rp = fs == null ? "" : XModelObjectUtil.getExpandedValue((XModelObject)fs, (String)"location", null);
        m.setAttributeValue("root", SyncProjectContext.toCanonicalPath(rp));
        String dp = this.getPathOnDisk(m.getAttributeValue("model path"));
        m.setAttributeValue("path on disk", SyncProjectContext.toCanonicalPath(dp));
        String sfs = m.getAttributeValue("src file system");
        fs = sfs == null ? null : this.model.getByPath("FileSystems/" + sfs);
        String sp = fs == null ? this.getDefaultJavaSrc() : XModelObjectUtil.getExpandedValue((XModelObject)fs, (String)"location", null);
        m.setAttributeValue("java src", SyncProjectContext.toCanonicalPath(sp));
        XModelObject[] cs = m.getChildren();
        int i = 0;
        while (i < cs.length) {
            dp = this.getPathOnDisk(cs[i].getAttributeValue("model path"));
            cs[i].setAttributeValue("path on disk", SyncProjectContext.toCanonicalPath(dp));
            ++i;
        }
    }

    private String getDefaultJavaSrc() {
        String[] src = EclipseResourceUtil.getJavaProjectSrcLocations((IProject)((IProject)this.model.getProperties().get("project")));
        return src.length == 1 ? src[0] : "";
    }

    private static String toCanonicalPath(String path) {
        if (path == null) {
            return path;
        }
        int k = -1;
        while ((k = path.indexOf("//")) >= 0) {
            path = String.valueOf(path.substring(0, k)) + path.substring(k + 1);
        }
        if (path.indexOf("/..") < 0) {
            return path;
        }
        int i;
        while ((i = path.indexOf("/..")) >= 0) {
            String pp = path.substring(0, i);
            int j = pp.lastIndexOf("/");
            if (j < 0) {
                return path;
            }
            path = String.valueOf(path.substring(0, j)) + path.substring(i + 3);
        }
        return path;
    }

    String getPathOnDisk(String modelPath) {
        XModelObject o;
        XModelObject fs = o = this.model.getByPath(modelPath);
        while (fs != null && fs.getFileType() != 3) {
            fs = fs.getParent();
        }
        if (fs == null) {
            return "";
        }
        return String.valueOf(XModelObjectUtil.getExpandedValue((XModelObject)fs, (String)"location", null)) + modelPath;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addModule(String name, String path) throws XModelException {
        String src;
        XModelObject m;
        File f = new File(path);
        if (!f.isFile()) {
            throw new XModelException(MessageFormat.format(StrutsUIMessages.SyncProjectContext_FileDoesNotExist, path));
        }
        String uri = "/WEB-INF/" + f.getName();
        if (name.length() > 0 && !name.startsWith("/")) {
            name = "/" + name;
        }
        if ((m = this.modulesMap.get(name)) != null) {
            if ("deleted".equals(m.get("state")) && m != null) {
                throw new XModelException(MessageFormat.format(StrutsUIMessages.SyncProjectContext_ModuleExists, SyncProjectContext.getModuleDisplayName(name)));
            }
            this.checkStrutsConfig(path);
            XModelObject cc = m.getModel().createModelObject("JstWebConfig", null);
            cc.setAttributeValue("URI", uri);
            cc.setAttributeValue("path on disk", path);
            cc.set("state", "added");
            XModelObject cc1 = m.getChildByPath(cc.getPathPart());
            if (cc1 != null) {
                if (!"deleted".equals(cc1.get("state"))) throw new XModelException(StrutsUIMessages.SyncProjectContext_ConfigFileIsUsed);
                XModelObjectLoaderUtil.mergeAttributes((XModelObject)cc1, (XModelObject)cc, (boolean)false);
                cc1.set("state", "added");
            } else {
                m.addChild(cc);
            }
            this.refillModuleList();
            return;
        }
        m = this.findModuleByPathOnDisk(path);
        if (m != null) {
            if (!"deleted".equals(m.get("state"))) {
                throw new XModelException(StrutsUIMessages.SyncProjectContext_PathUsedByAnotherModule);
            }
            this.modules.remove(m);
            this.modulesMap.remove(name);
        } else {
            this.checkStrutsConfig(path);
        }
        m = this.adoptContext.createModuleInfo(this.model, name, uri, this.webinf, true);
        if (m.getAttributeValue("java src").length() == 0 && (src = this.getDefaultJavaSrc()) != null && src.length() > 0) {
            m.setAttributeValue("java src", src);
        }
        m.setAttributeValue("path on disk", path);
        m.set("state", "added");
        this.modulesMap.put(name, m);
        this.refillModuleList();
    }

    String getNewModuleError(String name, String path) {
        XModelObject m;
        File f = new File(path);
        if (!f.isFile()) {
            return "File " + path + " does not exist.";
        }
        if (name.length() > 0 && !name.startsWith("/")) {
            name = "/" + name;
        }
        if ((m = this.modulesMap.get(name)) != null) {
            if ("deleted".equals(m.get("state")) && m != null) {
                return "Module " + SyncProjectContext.getModuleDisplayName(name) + " exists.";
            }
            try {
                this.checkStrutsConfig(path);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        if ((m = this.findModuleByPathOnDisk(path)) != null) {
            if (!"deleted".equals(m.get("state"))) {
                return "The path is used by another module.";
            }
        } else {
            try {
                this.checkStrutsConfig(path);
            }
            catch (Exception e) {
                return e.getMessage();
            }
        }
        return null;
    }

    private XModelObject findModuleByPathOnDisk(String path) {
        int i = 0;
        while (i < this.modules.size()) {
            String p2;
            XModelObject m = this.modules.get(i);
            String p1 = path.replace('\\', '/');
            if (p1.equalsIgnoreCase(p2 = m.getAttributeValue("path on disk").replace('\\', '/'))) {
                return m;
            }
            ++i;
        }
        return null;
    }

    private void checkStrutsConfig(String path) throws XModelException {
        boolean is12;
        File f = new File(path);
        if (!f.isFile()) {
            throw new XModelException(StrutsUIMessages.SyncProjectContext_NotAPathToAFile);
        }
        String s = FileUtil.readFile((File)f);
        boolean is11 = s.indexOf("-//Apache Software Foundation//DTD Struts Configuration 1.1//EN") >= 0;
        boolean bl = is12 = s.indexOf("-//Apache Software Foundation//DTD Struts Configuration 1.2//EN") >= 0;
        if (!is11 && !is12) {
            throw new XModelException(StrutsUIMessages.SyncProjectContext_FileIsNotStruts11Or12);
        }
        String[] es = XMLUtil.getXMLErrors((Reader)new StringReader(s), (boolean)false);
        if (es != null && es.length > 0) {
            String version = is11 ? "1.1" : "1.2";
            throw new XModelException(MessageFormat.format(StrutsUIMessages.SyncProjectContext_ConfigFileNotCorrect, version, es[0]));
        }
    }

    public boolean apply() throws XModelException {
        this.validateAttributes();
        if (!this.checkNewPaths()) {
            return false;
        }
        XUndoManager undo = this.model.getUndoManager();
        XTransactionUndo u = new XTransactionUndo("Synchronize modules", 0);
        undo.addUndoable((XUndoable)u);
        try {
            try {
                this.transaction();
            }
            catch (Exception e) {
                undo.rollbackTransactionInProgress();
                throw new XModelException((Throwable)e);
            }
        }
        finally {
            u.commit();
        }
        if (this.webxml != null && this.webxml.isModified()) {
            XActionInvoker.invoke((String)"SaveActions.Save", (XModelObject)this.webxml, null);
        }
        return true;
    }

    private void transaction() throws Exception {
        XModelObject fss = this.model.getByPath("FileSystems");
        if (fss == null) {
            return;
        }
        long ts0 = fss.getTimeStamp() + this.model.getByPath("Web").getTimeStamp();
        this.collectOldFileSystems();
        this.servlet = StrutsWebHelper.getServlet(this.webxml);
        for (String n : this.modulesMap.keySet()) {
            XModelObject o = this.modulesMap.get(n);
            if (this.executeDeleteA(o) == 1) continue;
            String uri = ((WebModuleImpl)o).getURI();
            StrutsWebHelper.revalidateInitParam(this.servlet, n, uri);
            this.revalidateModule(o);
        }
        this.executeDelete();
        SortFileSystems.sort(this.model);
        this.model.update();
        long ts1 = fss.getTimeStamp() + this.model.getByPath("Web").getTimeStamp();
        if (ts1 != ts0) {
            this.updateEclipseClassPath();
        }
    }

    private boolean checkNewPaths() {
        HashSet<String> checkedPaths = new HashSet<String>();
        for (String n : this.modulesMap.keySet()) {
            XModelObject o = this.modulesMap.get(n);
            if ("deleted".equals(o.get("state"))) continue;
            String rootPath = o.getAttributeValue("root");
            String srcPath = o.getAttributeValue("java src");
            if (this.checkFolder(rootPath, checkedPaths) && this.checkFolder(srcPath, checkedPaths)) continue;
            return false;
        }
        return true;
    }

    private boolean checkFolder(String path, Set<String> checkedPaths) {
        ServiceDialog d = this.model.getService();
        if (path != null && path.length() > 0 && !new File(path).isDirectory()) {
            if (checkedPaths.contains(path)) {
                return true;
            }
            checkedPaths.add(path);
            int q = d.showDialog(StrutsUIMessages.QUESTION, NLS.bind((String)StrutsUIMessages.FOLDER_DOESNT_EXIST, (Object)path), new String[]{StrutsUIMessages.YES, StrutsUIMessages.NO}, null, 0);
            if (q != 0) {
                return false;
            }
        }
        return true;
    }

    private int executeDeleteA(XModelObject o) {
        XModelObject[] cs = o.getChildren();
        int i = 0;
        while (i < cs.length) {
            if ("deleted".equals(cs[i].get("state"))) {
                cs[i].removeFromParent();
            }
            ++i;
        }
        if (!"deleted".equals(o.get("state"))) {
            return 0;
        }
        cs = o.getChildren();
        if (cs.length == 0) {
            return 1;
        }
        cs[0].removeFromParent();
        o.setAttributeValue("URI", cs[0].getAttributeValue("URI"));
        o.setAttributeValue("path on disk", cs[0].getAttributeValue("path on disk"));
        o.set("state", "added");
        return 2;
    }

    private void updateEclipseClassPath() {
        SpecialWizard w = SpecialWizardFactory.createSpecialWizard((String)"org.jboss.tools.common.model.project.ClassPathUpdateWizard");
        if (w != null) {
            try {
                Properties p = new Properties();
                p.put("model", this.model);
                p.put("replacedSrc", this.replacedSrc);
                w.setObject((Object)p);
                w.execute();
            }
            catch (Exception e) {
                StrutsModelPlugin.getPluginLog().logError((Throwable)e);
            }
        }
    }

    private void executeDelete() {
        for (XModelObject fs : this.oldFileSystems.values()) {
            if (fs == null || !fs.isActive() || "WEB-ROOT".equals(fs.getAttributeValue("name"))) continue;
            DefaultRemoveHandler.removeFromParent((XModelObject)fs);
        }
        this.oldFileSystems.clear();
        this.newFileSystems.clear();
        for (String n : this.modulesMap.keySet()) {
            XModelObject o = this.modulesMap.get(n);
            if (!"deleted".equals(o.get("state"))) continue;
            this.deleteModule(n);
        }
    }

    private void deleteModule(String n) {
        XModelObject m;
        XModelObject init = AdoptProjectContext.getWebAppInitParamForModule(this.servlet, n);
        if (init != null && init.isActive()) {
            DefaultRemoveHandler.removeFromParent((XModelObject)init);
        }
        if ((m = this.installedModules.get(n)) != null && m.isActive()) {
            DefaultRemoveHandler.removeFromParent((XModelObject)m);
        }
    }

    private void revalidateModule(XModelObject mc) throws Exception {
        String n = mc.getAttributeValue("name");
        XModelObject m = this.installedModules.get(n);
        if (m != null && (m.getChildren().length > 0 || mc.getChildren().length > 0)) {
            m.removeFromParent();
            m = null;
        }
        if (m == null) {
            m = mc.copy();
            DefaultCreateHandler.addCreatedObject((XModelObject)this.web, (XModelObject)m, (int)-1);
        } else if (this.getWebObject() != null) {
            m = this.web.getChildByPath(n.replace('/', '#'));
            this.model.changeObjectAttribute(m, "URI", mc.getAttributeValue("URI"));
            this.model.changeObjectAttribute(m, "root", mc.getAttributeValue("root"));
            String oldsrc = m.getAttributeValue("java src");
            this.model.changeObjectAttribute(m, "java src", mc.getAttributeValue("java src"));
            String newsrc = m.getAttributeValue("java src");
            if (oldsrc != null && oldsrc.length() > 0 && !oldsrc.equals(newsrc) && this.replacedSrc.containsKey(oldsrc)) {
                this.replacedSrc.put(oldsrc, newsrc);
            }
            this.replacedSrc.remove(newsrc);
            this.model.changeObjectAttribute(m, "path on disk", mc.getAttributeValue("path on disk"));
        }
        this.revalidateModuleFileSystem(m);
        this.revalidateConfigFileSystem(m);
        this.revalidateSrcFileSystem(m);
    }

    private XModelObject createFileSystem(String name, String location, String info) throws XModelException {
        XModelObject fs = this.model.createModelObject("FileSystemFolder", null);
        fs.setAttributeValue("name", name);
        fs.setAttributeValue("location", location);
        if (info != null) {
            fs.setAttributeValue("info", info);
        }
        DefaultCreateHandler.addCreatedObject((XModelObject)this.model.getByPath("FileSystems"), (XModelObject)fs, (int)-1);
        this.newFileSystems.put(location, fs);
        return fs;
    }

    private XModelObject adoptOrCreateFileSystem(String name, String location, String info) throws XModelException {
        XModelObject fs = this.model.getByPath("FileSystems/" + name);
        if (fs != null && location.equals(fs.getAttributeValue("location"))) {
            if (info != null) {
                this.model.changeObjectAttribute(fs, "info", info);
            }
            this.newFileSystems.put(location, fs);
            return fs;
        }
        if (fs != null) {
            DefaultRemoveHandler.removeFromParent((XModelObject)fs);
        }
        return this.createFileSystem(name, location, info);
    }

    private void revalidateModuleFileSystem(XModelObject m) throws Exception {
        String root;
        if (m.getModelEntity().getName().equals("JstWebConfig")) {
            return;
        }
        String n = m.getAttributeValue("name");
        boolean isWebRoot = n.length() == 0;
        String fsn = m.getAttributeValue("root file system");
        if (fsn == null || fsn.length() == 0 || m.getModel().getByPath("FileSystems/" + fsn) == null) {
            String string = fsn = isWebRoot ? "WEB-ROOT" : n.substring(1).replace('/', '#');
        }
        if ((root = m.getAttributeValue("root")).length() == 0) {
            return;
        }
        File f = new File(root);
        if (f.isFile()) {
            throw new Exception("Path " + root + " is not a folder.");
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new Exception("Cannot create " + fsn + " at location " + root);
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, root);
        String info = isWebRoot ? "Content-Type=Web" : "Content-Type=Web,Struts-Module=" + n;
        XModelObject fs = this.revalidateModuleFileSystem(fsn, loc, info);
        m.getModel().changeObjectAttribute(m, "root file system", fs.getAttributeValue("name"));
    }

    private XModelObject revalidateModuleFileSystem(String name, String location, String info) throws XModelException {
        XModelObject fs = this.oldFileSystems.get(location);
        if (fs != null && name.equals(fs.getAttributeValue("name"))) {
            if (info != null) {
                this.model.changeObjectAttribute(fs, "info", info);
            }
            this.oldFileSystems.remove(location);
            this.newFileSystems.put(location, fs);
            return fs;
        }
        fs = this.newFileSystems.get(location);
        if (fs != null && name.equals(fs.getAttributeValue("name"))) {
            if (info != null) {
                this.model.changeObjectAttribute(fs, "info", info);
            }
            return fs;
        }
        return this.adoptOrCreateFileSystem(name, location, info);
    }

    private void revalidateConfigFileSystem(XModelObject m) throws Exception {
        String dp = m.getAttributeValue("path on disk");
        if (!new File(dp).isFile()) {
            throw new Exception("File " + dp + " is not found.");
        }
        String loc = AdoptProjectFinisher.getRelativePath(this.workspace, dp);
        if (loc != null && loc.startsWith("/..")) {
            loc = loc.substring(3);
        }
        if (loc.startsWith("/..")) {
            int i = loc.lastIndexOf("/");
            String fsp = String.valueOf(XModelConstants.WORKSPACE_REF) + "/.." + loc.substring(0, i);
            loc = loc.substring(i);
            XModelObject f = m.getModel().getByPath(loc);
            if (f == null) {
                String n = "config-fs-" + (loc.endsWith(".xml") ? loc.substring(1, loc.length() - 4) : loc.substring(1));
                n = XModelObjectUtil.createNewChildName((String)n, (XModelObject)m.getModel().getByPath("FileSystems"));
                this.createFileSystem(n, fsp, null);
            }
        }
        m.getModel().changeObjectAttribute(m, "model path", loc);
        XModelObject[] cs = m.getChildren();
        int i = 0;
        while (i < cs.length) {
            this.revalidateConfigFileSystem(cs[i]);
            ++i;
        }
    }

    private void revalidateSrcFileSystem(XModelObject m) throws Exception {
        if (m.getModelEntity().getName().equals("JstWebConfig")) {
            return;
        }
        String n = m.getAttributeValue("name");
        boolean isWebRoot = n.length() == 0;
        String fsn = isWebRoot ? "src" : "src-" + n.substring(1);
        String root = m.getAttributeValue("java src");
        if (root.length() == 0) {
            return;
        }
        File f = new File(root);
        if (f.isFile()) {
            throw new Exception("Path " + root + " is not a folder.");
        }
        if (!f.exists()) {
            f.mkdirs();
        }
        if (!f.isDirectory()) {
            throw new Exception("Cannot create " + fsn + " " + root);
        }
        String loc = AdoptProjectFinisher.getFileSystemLocation(this.workspace, root);
        XModelObject fs = this.revalidateSrcFileSystem(fsn, loc, null);
        m.getModel().changeObjectAttribute(m, "src file system", fs.getAttributeValue("name"));
    }

    private XModelObject revalidateSrcFileSystem(String name, String location, String info) throws XModelException {
        XModelObject fs = this.oldFileSystems.remove(location);
        if (fs != null) {
            this.newFileSystems.put(location, fs);
            return fs;
        }
        fs = this.newFileSystems.get(location);
        if (fs != null) {
            return fs;
        }
        return this.adoptOrCreateFileSystem(name, location, info);
    }

    private void validateAttributes() throws XModelException {
        this.validateAttr("URI");
        this.validateAttr("path on disk");
        this.validateAttr("root");
    }

    private void validateAttr(String attr) throws XModelException {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < this.modules.size()) {
            String v;
            XModelObject o = this.modules.get(i);
            if (!"deleted".equals(o.get("state")) && (v = o.getAttributeValue(attr)) != null) {
                if (v.length() == 0) {
                    throw new XModelException(MessageFormat.format(StrutsUIMessages.SyncProjectContext_AttributeIsRequired, attr));
                }
                if (set.contains(v)) {
                    throw new XModelException(MessageFormat.format(StrutsUIMessages.SyncProjectContext_MoreThanOneModuleHasAttributeValue, attr, v));
                }
                set.add(v);
            }
            ++i;
        }
    }

    public static String getModuleDisplayName(String name) {
        return name.length() == 0 ? "<default>" : name;
    }

    private void collectOldFileSystems() {
        this.replacedSrc.clear();
        this.oldFileSystems.clear();
        this.newFileSystems.clear();
        for (String n : this.installedModules.keySet()) {
            XModelObject m = this.installedModules.get(n);
            this.collectOldFileSystem(m, "root file system");
            this.collectOldFileSystem(m, "src file system");
            String s = m.getAttributeValue("java src");
            if (s == null || s.length() <= 0) continue;
            this.replacedSrc.put(s, "");
        }
    }

    private void collectOldFileSystem(XModelObject m, String attr) {
        String nm = m.getAttributeValue(attr);
        if (nm == null || nm.length() == 0) {
            return;
        }
        XModelObject fs = this.model.getByPath("FileSystems/" + nm);
        if (fs != null) {
            this.oldFileSystems.put(fs.getAttributeValue("location"), fs);
        }
    }

    private void removeObsoleteModules() {
        Iterator<String> it = this.installedModules.keySet().iterator();
        while (it.hasNext()) {
            XModelObject m;
            String cgp;
            String n = it.next();
            String uri = this.describedModules.get(n);
            if (uri != null || (cgp = (m = this.installedModules.get(n)).getAttributeValue("model path")).length() != 0 && this.model.getByPath(cgp) != null && (!this.isWebXMLCorrect() || this.webxml.isModified())) continue;
            m.removeFromParent();
            it.remove();
        }
    }

    private String checkCorrectness() {
        if (!this.isWebXMLCorrect()) {
            return StrutsUIMessages.WEBXML_ISNOT_CORRECT;
        }
        this.removeObsoleteModules();
        if (this.describedModules.size() != this.installedModules.size()) {
            return StrutsUIMessages.MODULES_DESCRIBED_IN_WEBXML_ARENT_SYNCHRONIZED;
        }
        for (String n : this.installedModules.keySet()) {
            String fsn;
            String uri = this.describedModules.get(n);
            if (uri == null) {
                return NLS.bind((String)StrutsUIMessages.MODULE_DOESNT_DEFINE_URI, (Object)SyncProjectContext.getModuleDisplayName(n));
            }
            WebModuleImpl m = (WebModuleImpl)this.installedModules.get(n);
            String uri_m = m.getURI();
            if (!uri.equals(uri_m)) {
                if (uri.length() > 0 && uri_m.length() == 0) {
                    m.setURI(uri);
                    m.setModified(true);
                } else if (uri.length() > 0) {
                    m.setURI(uri);
                    m.setModified(true);
                } else {
                    return NLS.bind((String)StrutsUIMessages.URI_FOR_MODULE_ISNOTT_SYNCHRONIZED, (Object)SyncProjectContext.getModuleDisplayName(n));
                }
            }
            if (this.model.getByPath("FileSystems/" + (fsn = m.getAttributeValue("root file system"))) == null) {
                return NLS.bind((String)StrutsUIMessages.ROOT_FOR_MODULE_ISNOT_FOUND, (Object)SyncProjectContext.getModuleDisplayName(n));
            }
            String cgp = m.getAttributeValue("model path");
            if (cgp.length() == 0 || this.model.getByPath(cgp) == null) {
                boolean v = false;
                if (uri_m.startsWith("/WEB-INF/") && this.model.getByPath(cgp = uri_m.substring("/WEB-INF".length())) != null) {
                    m.setAttributeValue("model path", cgp);
                    v = true;
                }
                if (!v) {
                    return NLS.bind((String)StrutsUIMessages.CONFIG_FOR_MODULE_IS_MISSING, (Object)SyncProjectContext.getModuleDisplayName(n));
                }
            }
            XModelObject[] cs = m.getChildren();
            int i = 0;
            while (i < cs.length) {
                cgp = cs[i].getAttributeValue("model path");
                if (cgp.length() == 0 || this.model.getByPath(cgp) == null) {
                    return NLS.bind((String)StrutsUIMessages.CONFIG_FOR_URI_ISNOT_FOUND, (Object)cs[i].getAttributeValue("URI"));
                }
                ++i;
            }
        }
        return null;
    }

    protected String checkWebXML() {
        if (this.webxml == null) {
            return StrutsUIMessages.WEBXML_ISNOT_FOUND;
        }
        if (!this.isWebXMLCorrect()) {
            return StrutsUIMessages.WEBXML_ISNOT_CORRECT;
        }
        return null;
    }

    protected String getProjectLocation() {
        return this.model.getProperties().getProperty("eclipse.project");
    }

    public String getErrorMessage(XModelObject[] modules, XModelObject selected) {
        String s = this.checkWebXML();
        if (s != null) {
            return s;
        }
        this.modulesValidator.setProject(this.getProjectLocation());
        return this.modulesValidator.getErrorMessage(modules, selected);
    }

    public void init(XModel model) {
        this.model = model;
    }

    public boolean isActive() {
        return EclipseResourceUtil.hasNature((XModel)this.model, (String)"org.jboss.tools.struts.strutsnature");
    }

    public void update() {
        this.setModel(this.model);
        this.update(false);
    }

    public String getError() {
        try {
            return this.checkCorrectness();
        }
        catch (Exception e) {
            return e.getMessage();
        }
    }

    public void updateProject() {
        WebModulesHelper wh = WebModulesHelper.getInstance(this.model);
        wh.getPatternLoader().revalidate(this.getWebXML());
        wh.getResourceMapping().revalidate();
        wh.getWebProject().getTaglibMapping().revalidate(this.getWebXML());
    }
}

