/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.filesystems.impl;

import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.filesystems.FileSystem;
import org.jboss.tools.common.model.filesystems.impl.FileSystemsImpl;
import org.jboss.tools.common.model.filesystems.impl.JarAccess;
import org.jboss.tools.common.model.filesystems.impl.JarAccessFactory;
import org.jboss.tools.common.model.filesystems.impl.JarFolderImpl;
import org.jboss.tools.common.model.filesystems.impl.LFileObject;
import org.jboss.tools.common.model.util.Paths;

public class JarSystemImpl
extends JarFolderImpl
implements FileSystem {
    private static final long serialVersionUID = 7958999759019059243L;
    protected JarAccess jar = null;
    boolean loaded2 = false;

    @Override
    public int getFileType() {
        return 3;
    }

    @Override
    protected JarSystemImpl getJarSystem() {
        return this;
    }

    protected JarAccess getJarAccess() {
        if (this.jar == null) {
            this.jar = JarAccessFactory.getJarAccess(this.getLocation(), this);
        }
        return this.jar;
    }

    @Override
    public boolean isAttributeEditable(String name) {
        return super.isAttributeEditable(name) && "name".equals(name);
    }

    @Override
    protected String getAbsolutePath() {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void loadChildren() {
        if (!this.isActive()) {
            return;
        }
        if (this != this.getJarAccess().getMain()) {
            return;
        }
        if (this.loaded2) {
            return;
        }
        JarSystemImpl jarSystemImpl = this;
        synchronized (jarSystemImpl) {
            this.jar.setLocation(this.getLocation());
            super.loadChildren();
        }
        this.loaded2 = true;
    }

    @Override
    public XModelObject[] getChildren() {
        JarSystemImpl main = this.getJarAccess().getMain();
        return main == this || main == null ? super.getChildren() : main.getChildren();
    }

    @Override
    public boolean hasChildren() {
        JarSystemImpl main = this.getJarAccess().getMain();
        return main == this || main == null ? super.hasChildren() : main.hasChildren();
    }

    @Override
    public XModelObject getChildByPathPart(String pathpart) {
        JarSystemImpl main = this.getJarAccess().getMain();
        return main == this || main == null ? super.getChildByPathPart(pathpart) : main.getChildByPathPart(pathpart);
    }

    @Override
    public String getPathPart() {
        return this.name();
    }

    public String getLocation() {
        return Paths.expand(this.get("location"), this.getModel().getProperties());
    }

    @Override
    public String getTempLocation() {
        JarSystemImpl main = this.getJarAccess().getMain();
        if (main != this && main != null) {
            main.getChildren();
        } else if (!this.jar.isLoaded()) {
            this.loadChildren();
        }
        String s = this.jar.getTempLocation();
        return s == null ? this.get("location") : s;
    }

    public LFileObject getFileObject(String relpath) {
        return this.getJarAccess().getFileObject(this.name(), relpath);
    }

    @Override
    public boolean update() {
        if (this.getJarAccess().getMain() != this) {
            return true;
        }
        if (this.jar.isModified()) {
            JarSystemImpl[] ss;
            if (this.jar.isLoaded()) {
                XModelObject[] cs = this.getChildren();
                int i = 0;
                while (i < cs.length) {
                    this.removeChild_0(cs[i]);
                    ++i;
                }
                this.jar.invalidate();
            }
            this.jarUpdated();
            JarSystemImpl[] jarSystemImplArray = ss = this.getJarAccess().getSlaves();
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                JarSystemImpl s = jarSystemImplArray[n2];
                s.jarUpdated();
                ++n2;
            }
        }
        return true;
    }

    public void jarUpdated() {
        this.loaded = false;
        this.loaded2 = false;
        this.fire = true;
        if (this.getParent() instanceof FileSystemsImpl) {
            ((FileSystemsImpl)this.getParent()).getLibs().libraryChanged(this);
        }
        this.fireStructureChanged(3, null);
    }

    @Override
    public String getPresentationString() {
        String location = this.getLocation();
        if (location != null) {
            int i = (location = location.replace('\\', '/')).lastIndexOf(47);
            if (i >= 0) {
                location = location.substring(i + 1);
            }
            return location;
        }
        return super.getPresentationString();
    }
}

