/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl;

import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.osgi.util.NLS;
import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XMapping;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.constraint.XAttributeConstraint;
import org.jboss.tools.common.meta.constraint.XAttributeConstraintV;
import org.jboss.tools.common.model.ServiceDialog;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelBuffer;
import org.jboss.tools.common.model.XModelConstants;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.event.XModelChangeManager;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.filesystems.FileSystemsHelper;
import org.jboss.tools.common.model.filesystems.impl.AbstractExtendedXMLFileImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemImpl;
import org.jboss.tools.common.model.filesystems.impl.FileSystemPeer;
import org.jboss.tools.common.model.impl.XModelBufferImpl;
import org.jboss.tools.common.model.impl.XModelObjectImpl;
import org.jboss.tools.common.model.loaders.EntityRecognizer;
import org.jboss.tools.common.model.loaders.XObjectLoader;
import org.jboss.tools.common.model.plugin.ModelMessages;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.undo.XChangeUndo;
import org.jboss.tools.common.model.undo.XUndoManager;
import org.jboss.tools.common.model.util.ModelFeatureFactory;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.jboss.tools.common.util.FileUtil;

public class XModelImpl
implements XModel {
    private XModelMetaData metadata = null;
    private Properties properties = null;
    private ArrayList<XModelTreeListener> treeListeners = new ArrayList();
    private XModelTreeListener[] treeListenersArray = new XModelTreeListener[0];
    private XModelObject root = null;
    private XUndoManager undoer = new XUndoManager();
    private static ServiceDialog service = null;
    private static XModelBufferImpl buffer = new XModelBufferImpl();
    private XModelChangeManager changemanager = new XModelChangeManager();
    private FileSystemPeer fileregistry = new FileSystemPeer();
    private PrintWriter out = new PrintWriter(System.out, true);
    private HashMap<String, XModelObject> extraroots = new HashMap(2);
    private String rootEntity = "Root";
    static Set<String> unknownEntities = new HashSet<String>();
    protected Map<String, Object> managers = new HashMap<String, Object>();
    int loaderCount = 0;
    Object loaderMonitor = new Object();

    public XModelImpl(Properties properties, XModelMetaData metadata) {
        this.metadata = metadata;
        this.properties = properties;
        if (properties.getProperty("rootEntity") != null) {
            this.rootEntity = properties.getProperty("rootEntity");
        }
        XModelConstants.validate(this);
    }

    @Override
    public XModelMetaData getMetaData() {
        return this.metadata;
    }

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public PrintWriter getOut() {
        return this.out;
    }

    @Override
    public void setOut(PrintWriter out) {
        if (out != null) {
            this.out = out;
        }
    }

    @Override
    public void setService(ServiceDialog _service) {
        service = _service;
        if (service != null) {
            service.setModel(this);
        }
    }

    @Override
    public ServiceDialog getService() {
        return service;
    }

    @Override
    public XUndoManager getUndoManager() {
        return this.undoer;
    }

    @Override
    public XModelBuffer getModelBuffer() {
        if (XModelTransferBuffer.getInstance().isEnabled()) {
            return XModelTransferBuffer.getInstance().getBuffer();
        }
        return buffer;
    }

    @Override
    public EntityRecognizer getEntityRecognizer() {
        return this.metadata.getEntityRecognizer();
    }

    @Override
    public XModelChangeManager getChangeManager() {
        return this.changemanager;
    }

    @Override
    public FileSystemPeer getFileRegistry() {
        return this.fileregistry;
    }

    @Override
    public XModelObject getRoot() {
        if (this.root == null) {
            this.createRoot();
        }
        return this.root;
    }

    @Override
    public XModelObject getRoot(String name) {
        if (name == null || name.length() == 0) {
            return this.getRoot();
        }
        XMapping m = this.getMetaData().getMapping("Roots");
        String path = m.getValue(name);
        return path == null || path.length() == 0 ? null : this.getRoot().getChildByPath(path);
    }

    void createRoot() {
        this.root = this.createModelObject(this.rootEntity, new Properties());
    }

    @Override
    public XModelObject getByPath(String path) {
        if (path == null || path.length() == 0) {
            return this.getRoot();
        }
        if (path.startsWith("root:")) {
            int i = path.indexOf(47);
            if (i < 0) {
                return this.extraroots.get(path);
            }
            XModelObject r = this.extraroots.get(path.substring(0, i));
            return r == null ? null : r.getChildByPath(path.substring(i + 1));
        }
        if (path.startsWith("/")) {
            return this.getByPathInFileSystem(path.substring(1));
        }
        if (path.startsWith("%")) {
            int j;
            int i = path.indexOf("%");
            if (i == (j = path.lastIndexOf("%"))) {
                return null;
            }
            String rt = path.substring(i + 1, j);
            XModelObject ro = this.getRoot(rt);
            return ro == null || j + 2 >= path.length() ? ro : ro.getChildByPath(path.substring(j + 2));
        }
        return this.getRoot().getChildByPath(path);
    }

    public static XModelObject getByRelativePath(XModel model, String path) {
        XModelObject c;
        XModelObject fs;
        XModelObject wr;
        XModelObject o = null;
        if (path != null && path.startsWith("/") && (wr = FileSystemsHelper.getWebRoot(model)) != null) {
            o = wr.getChildByPath(path.substring(1));
        }
        if (o == null) {
            o = model.getByPath(path);
        }
        if (o == null || !path.startsWith("/")) {
            return o;
        }
        XModelObject p = o;
        while (p != null && !"true".equals(p.get("overlapped"))) {
            p = p.getParent();
        }
        if (p == null) {
            return o;
        }
        String newPath = o.getPath().substring(p.getPath().length());
        if (path.equals(newPath)) {
            return o;
        }
        path = o.getPath().substring(p.getPath().length());
        if (p.getModelEntity().getName().equals("FileFolder") && (fs = XModelImpl.findMountedFileSystem(p)) != null && path.length() > 1 && (c = fs.getChildByPath(path.substring(1))) != null) {
            return c;
        }
        return XModelImpl.getByRelativePath(model, path);
    }

    static XModelObject findMountedFileSystem(XModelObject folder) {
        String s = XModelObjectLoaderUtil.getResourcePath(folder);
        if (s == null) {
            return null;
        }
        XModelObject p = folder.getParent();
        while (p != null && p.getFileType() != 3) {
            p = p.getParent();
        }
        if (!(p instanceof FileSystemImpl)) {
            return null;
        }
        String loc = ((FileSystemImpl)p).getAbsoluteLocation().replace('\\', '/');
        XModelObject fs = FileSystemsHelper.getFileSystems(folder.getModel());
        XModelObject[] cs = fs.getChildren("FileSystemFolder");
        int i = 0;
        while (i < cs.length) {
            if (cs[i] instanceof FileSystemImpl) {
                String loci = ((FileSystemImpl)cs[i]).getAbsoluteLocation().replace('\\', '/');
                if ((String.valueOf(loc) + s).equals(loci)) {
                    return cs[i];
                }
            }
            ++i;
        }
        return null;
    }

    public XModelObject getByPathInFileSystem(String path) {
        XModelObject fs = this.getByPath("FileSystems");
        if (fs == null) {
            return null;
        }
        XModelObject[] cs = fs.getChildren();
        int i = 0;
        while (i < cs.length) {
            XModelObject o = cs[i].getChildByPath(path);
            if (o != null) {
                return o;
            }
            ++i;
        }
        return null;
    }

    static void creationFailed(String entity, String cause) {
        if (!unknownEntities.contains(entity)) {
            unknownEntities.add(entity);
            String message = NLS.bind((String)cause, (Object[])new Object[]{entity});
            ModelPlugin.getPluginLog().logInfo(message);
        }
    }

    @Override
    public XModelObject createModelObject(String entity, Properties properties) {
        if (unknownEntities.contains(entity)) {
            return null;
        }
        XModelEntity ent = this.getMetaData().getEntity(entity);
        if (ent == null) {
            XModelImpl.creationFailed(entity, ModelMessages.UNKNOUN_ENTITY);
            return null;
        }
        XModelObjectImpl me = (XModelObjectImpl)ent.getObjectImplementation();
        if (me == null) {
            XModelImpl.creationFailed(entity, ModelMessages.CREATION_ENTITY_FAILURE);
            return null;
        }
        me.setModel(this);
        me.setEntityName_0(entity);
        XAttribute[] an = ent.getAttributes();
        int i = 0;
        while (i < an.length) {
            String n = an[i].getName();
            String v = an[i].getDefaultValue();
            me.set_0(n, v);
            if (properties != null && (v = properties.getProperty(n)) != null) {
                me.set_0(n, v);
            }
            ++i;
        }
        return me;
    }

    @Override
    public void editObjectAttribute(XModelObject object, String attributeName, String value) throws XModelException {
        this.changeObjectAttribute(object, attributeName, value, true);
    }

    @Override
    public void changeObjectAttribute(XModelObject object, String attributeName, String value) throws XModelException {
        this.changeObjectAttribute(object, attributeName, value, false);
    }

    public String getError(XModelObject object, String attributeName, String value) {
        String ov;
        if (object == null || object.getPath() == null) {
            return null;
        }
        XModelEntity ent = object.getModelEntity();
        XAttribute a = ent.getAttribute(attributeName);
        if (a == null) {
            return null;
        }
        if (a.isTrimmable() && value != null) {
            value = value.trim();
        }
        String string = ov = (ov = object.getAttributeValue(attributeName)) == null ? "" : ov;
        if (value.length() == 0 && "true".equals(a.getProperty("required"))) {
            String mes = MessageFormat.format("Attribute {0} is required.", a.getName());
            return mes;
        }
        XAttributeConstraint c = a.getConstraint();
        if (c != null && service != null) {
            String error;
            String string2 = error = c instanceof XAttributeConstraintV ? ((XAttributeConstraintV)c).getError(value, object) : c.getError(value);
            if (error != null) {
                String mes = NLS.bind((String)ModelMessages.SET_ATTRIBUTE_FAILURE, (Object[])new Object[]{attributeName, value, error});
                return mes;
            }
        }
        return null;
    }

    void changeObjectAttribute(XModelObject object, String attributeName, String value, boolean edit) throws XModelException {
        XModelObject f;
        String nv;
        String ov;
        if (object == null || object.getPath() == null) {
            return;
        }
        XModelEntity ent = object.getModelEntity();
        XAttribute a = ent.getAttribute(attributeName);
        if (a == null) {
            return;
        }
        if (a.isTrimmable() && value != null) {
            value = value.trim();
        }
        String string = ov = (ov = object.getAttributeValue(attributeName)) == null ? "" : ov;
        if (!this.isDifferent(ov, value)) {
            return;
        }
        if (value.length() == 0 && "true".equals(a.getProperty("required"))) {
            String mes = MessageFormat.format("Attribute {0} is required.", a.getName());
            service.showDialog("Error", mes, new String[]{"OK"}, null, 1);
            return;
        }
        XAttributeConstraint c = a.getConstraint();
        if (c != null && service != null) {
            String error;
            String string2 = error = c instanceof XAttributeConstraintV ? ((XAttributeConstraintV)c).getError(value, object) : c.getError(value);
            if (error != null) {
                if (edit) {
                    String mes = NLS.bind((String)ModelMessages.SET_ATTRIBUTE_FAILURE, (Object[])new Object[]{attributeName, value, error});
                    if (service != null) {
                        XEntityDataImpl data = XEntityDataImpl.create(new String[][]{{object.getModelEntity().getName(), "yes"}, {attributeName, "no"}});
                        data.setValue(attributeName, value);
                        int q = service.showDialog(ModelMessages.Error, mes, new String[]{ModelMessages.Finish, ModelMessages.Cancel}, data, 1);
                        if (q != 0) {
                            return;
                        }
                        this.changeObjectAttribute(object, attributeName, data.getValue(attributeName), true);
                    }
                    return;
                }
                if ((value = c.getCorrectedValue(value)) == null) {
                    return;
                }
                if (!this.isDifferent(ov, value)) {
                    return;
                }
            }
        }
        nv = (nv = object.setAttributeValue(attributeName, value)) == null ? "" : nv;
        ent.setDependentValues(object, attributeName);
        XChangeUndo cu = new XChangeUndo(object, attributeName, ov);
        this.undoer.addUndoable(cu);
        object.setModified(true);
        if (edit) {
            ((XModelObjectImpl)object).onAttributeValueEdit(attributeName, ov, nv);
        }
        if ((f = FileSystemsHelper.getFile(object)) instanceof AbstractExtendedXMLFileImpl) {
            ((AbstractExtendedXMLFileImpl)f).check();
        }
    }

    private boolean isDifferent(String v1, String v2) {
        if (v1 == null) {
            return v2 != null;
        }
        if (v1.equals(v2)) {
            return false;
        }
        int i1 = -1;
        int i2 = -1;
        int l1 = v1.length();
        int l2 = v2.length();
        char c1 = '\u0000';
        char c2 = '\u0000';
        while (i1 < l1 || l2 < l2) {
            if (i1 < l1) {
                ++i1;
                while (i1 < l1 && (c1 = v1.charAt(i1)) == '\r') {
                    ++i1;
                }
                if (i1 == l1) {
                    c1 = '\u0000';
                }
            }
            if (i2 < l2) {
                ++i2;
                while (i2 < l2 && (c2 = v2.charAt(i2)) == '\r') {
                    ++i2;
                }
                if (i2 == l2) {
                    c2 = '\u0000';
                }
            }
            if (c1 == c2) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized void addModelTreeListener(XModelTreeListener listener) {
        if (this.treeListeners.contains(listener)) {
            return;
        }
        this.treeListeners.add(listener);
        this.treeListenersArray = this.treeListeners.toArray(new XModelTreeListener[0]);
    }

    @Override
    public synchronized void removeModelTreeListener(XModelTreeListener listener) {
        if (!this.treeListeners.contains(listener)) {
            return;
        }
        this.treeListeners.remove(listener);
        this.treeListenersArray = this.treeListeners.toArray(new XModelTreeListener[0]);
    }

    @Override
    public void load() {
        this.validateRootEntity();
        ArrayList<XModelTreeListener> tls = this.treeListeners;
        this.treeListenersArray = new XModelTreeListener[0];
        this.treeListeners = new ArrayList();
        XModelObject r = this.getRoot();
        XModelObjectLoaderUtil.getObjectLoader(r).load(r);
        this.treeListeners = tls;
        this.treeListenersArray = this.treeListeners.toArray(new XModelTreeListener[0]);
        this.undoer.setModel(this);
        this.undoer.reset();
        this.fireStructureChanged(this.getRoot(), 3, null);
        if (!this.isDummy()) {
            this.loadWatcher();
        }
    }

    private void loadWatcher() {
        if (this.getProperties().get("project") == null) {
            return;
        }
        XObjectLoader l = (XObjectLoader)ModelFeatureFactory.getInstance().createFeatureInstance("org.jboss.tools.common.model.project.WatcherLoader");
        XModelObject fs = this.getByPath("FileSystems");
        if (l != null && fs != null) {
            l.load(fs);
        }
    }

    public boolean isDummy() {
        return "RootDummy".equals(this.getRoot().getModelEntity().getName());
    }

    private String reduceURLPath(String p) {
        return FileUtil.fileURLToFilePath((String)p);
    }

    private String getProjectName() {
        String d = this.properties.getProperty(XModelConstants.WORKSPACE);
        String n = null;
        if (d == null) {
            return null;
        }
        if ((d = this.reduceURLPath(d)).lastIndexOf(58) >= 2) {
            return n != null ? n : d.substring(d.lastIndexOf(47) + 1);
        }
        File f = null;
        f = new File(d);
        f.mkdirs();
        return f == null || !f.isDirectory() ? null : (n != null ? n : f.getName());
    }

    private void validateRootEntity() {
        XModelObjectImpl r = (XModelObjectImpl)this.getRoot();
        String project = this.getProjectName();
        if (project == null) {
            r.setEntityName_0("RootDummy");
        } else {
            r.setAttributeValue("project name", project);
            r.setEntityName_0(this.rootEntity);
        }
    }

    @Override
    public void update() throws XModelException {
        XModelObject r = this.getRoot();
        XModelObjectLoaderUtil.getObjectLoader(r).update(r);
    }

    @Override
    public void save() {
        XModelObject r = this.getRoot();
        r.set("isSaveOn", "true");
        XModelObjectLoaderUtil.getObjectLoader(r).save(r);
        r.set("isSaveOn", "");
    }

    @Override
    public void saveOptions() {
        XModelObject o = this.getRoot("XStudio");
        if (o != null) {
            XModelObjectLoaderUtil.getObjectLoader(o).save(o);
        }
    }

    public void setExtraRoot(XModelObject r) {
        String pathpart = r.getPathPart();
        if (!pathpart.startsWith("root:")) {
            throw new IllegalArgumentException("Not extra root: " + pathpart);
        }
        this.extraroots.put(pathpart, r);
    }

    public void removeExtraRoot(String pathpart) {
        this.extraroots.remove(pathpart);
    }

    public void fireNodeChanged(XModelObject object, String info) {
        this.fireNodeChanged(object, info, null);
    }

    void fireNodeChanged(XModelObject object, String info, Object details) {
        if (object.getModel() != this || !object.isActive()) {
            return;
        }
        final XModelTreeEvent event = new XModelTreeEvent(this, object, 0, info, details);
        XModelTreeListener[] ls = this.treeListenersArray;
        int i = 0;
        while (i < ls.length) {
            final XModelTreeListener l = ls[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.nodeChanged(event);
                }
            });
            ++i;
        }
    }

    public void fireStructureChanged(XModelObject object) {
        this.fireStructureChanged(object, 3, null);
    }

    public void fireStructureChanged(XModelObject object, int kind, Object info) {
        if (object.getModel() != this || !object.isActive()) {
            return;
        }
        final XModelTreeEvent event = new XModelTreeEvent(this, object, kind, info);
        XModelTreeListener[] ls = this.treeListenersArray;
        int i = 0;
        while (i < ls.length) {
            final XModelTreeListener l = ls[i];
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable exception) {
                }

                public void run() throws Exception {
                    l.structureChanged(event);
                }
            });
            ++i;
        }
    }

    @Override
    public Object getManager(String id) {
        return this.managers.get(id);
    }

    @Override
    public void addManager(String id, Object manager) {
        this.managers.put(id, manager);
    }

    @Override
    public void removeManager(String id) {
        this.managers.remove(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLoader() {
        Object object = this.loaderMonitor;
        synchronized (object) {
            ++this.loaderCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLoader() {
        Object object = this.loaderMonitor;
        synchronized (object) {
            --this.loaderCount;
            if (this.loaderCount <= 0) {
                this.loaderMonitor.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForLoading() {
        Object object = this.loaderMonitor;
        synchronized (object) {
            if (this.loaderCount <= 0) {
                return;
            }
            try {
                this.loaderMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }

    public List<XModelTreeListener> getTreeListeners() {
        return Collections.unmodifiableList(this.treeListeners);
    }

    public Map<String, Object> getManagerMap() {
        return Collections.unmodifiableMap(this.managers);
    }
}

