/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.impl.trees;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.jboss.tools.common.model.XFilteredTree;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;

public abstract class DefaultFilteredTree
implements XFilteredTree {
    protected XModel model = null;
    protected Set<String> entities = new HashSet<String>(10);
    protected Set<String> selectable_entities = new HashSet<String>(10);
    protected XModelObject root = null;

    @Override
    public void dispose() {
        if (this.entities != null) {
            this.entities.clear();
        }
        this.entities = null;
        if (this.selectable_entities != null) {
            this.selectable_entities.clear();
        }
        this.selectable_entities = null;
    }

    @Override
    public void setConstraint(Object object) {
    }

    protected void setRoot(XModelObject object) {
        this.root = object;
    }

    protected void addEntities(String[] _entities, boolean selectable) {
        this.addEntities(_entities);
        if (selectable) {
            this.addSelectableEntities(_entities);
        }
    }

    protected void addEntities(String[] _entities) {
        int i = 0;
        while (i < _entities.length) {
            this.entities.add(_entities[i]);
            ++i;
        }
    }

    protected void addSelectableEntities(String[] _entities) {
        int i = 0;
        while (i < _entities.length) {
            this.selectable_entities.add(_entities[i]);
            ++i;
        }
    }

    protected abstract void onSetModel();

    @Override
    public void setModel(XModel model) {
        this.model = model;
        this.onSetModel();
    }

    @Override
    public XModelObject getRoot() {
        return this.root;
    }

    @Override
    public boolean hasChildren(XModelObject object) {
        return object.hasChildren();
    }

    @Override
    public XModelObject[] getChildren(XModelObject object) {
        XModelObject[] cs = object.getChildren();
        ArrayList<XModelObject> v = new ArrayList<XModelObject>(cs.length);
        int i = 0;
        while (i < cs.length) {
            if (this.isAcceptableChild(cs[i])) {
                v.add(cs[i]);
            }
            ++i;
        }
        return v.toArray(new XModelObject[0]);
    }

    @Override
    public XModelObject getChildAt(XModelObject object, int i) {
        XModelObject[] c = this.getChildren(object);
        return i < 0 || i >= c.length ? null : c[i];
    }

    protected boolean isAcceptableChild(XModelObject child) {
        return this.entities.contains(child.getModelEntity().getName());
    }

    @Override
    public boolean isSelectable(XModelObject object) {
        String e = object.getModelEntity().getName();
        return this.selectable_entities.contains(e);
    }

    @Override
    public String getValue(XModelObject object) {
        return this.belongs(object) ? object.getPath() : "";
    }

    public boolean belongs(XModelObject object) {
        String e = object.getModelEntity().getName();
        return this.entities.contains(e);
    }

    @Override
    public XModelObject find(String value) {
        return this.model.getByPath(value);
    }

    @Override
    public XModelObject getParent(XModelObject object) {
        return object == this.root ? null : object.getParent();
    }

    @Override
    public String getPath(XModelObject object) {
        return object.getPath();
    }
}

