/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.undo;

import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.icons.impl.XModelObjectIcon;
import org.jboss.tools.common.model.undo.XUndoableImpl;

public class XChangeSetUndo
extends XUndoableImpl {
    protected XModel model = null;
    protected String path = null;
    protected String[][] attr = null;

    public XChangeSetUndo(XModelObject object, String[][] attr) {
        this.model = object.getModel();
        this.path = object.getPath();
        this.attr = attr;
        int i = 0;
        while (i < attr.length) {
            this.attr[i][2] = object.getAttributeValue(attr[i][0]);
            ++i;
        }
        String[] types = object.getModelEntity().getRenderer().getIconNames();
        String iconType = types.length == 0 ? "main" : object.getModelEntity().getRenderer().getIconNames()[0];
        this.icon = new XModelObjectIcon(object).getEclipseImage0(new String[]{iconType});
        this.description = this.createDescription(object);
        this.kind = 0;
    }

    @Override
    public void doUndo() {
        this.execute(1);
    }

    @Override
    public void doRedo() {
        this.execute(2);
    }

    protected void execute(int k) {
        XModelObject object = this.model.getByPath(this.path);
        if (object == null) {
            return;
        }
        int i = 0;
        while (i < this.attr.length) {
            object.setAttributeValue(this.attr[i][0], this.attr[i][k]);
            ++i;
        }
        object.setModified(true);
        this.path = object.getPath();
    }

    @Override
    protected boolean merge(XUndoableImpl u) {
        if (!(u instanceof XChangeSetUndo)) {
            return false;
        }
        XChangeSetUndo c = (XChangeSetUndo)u;
        if (c == null || this.path == null || this.attr == null || !this.path.equals(c.path) || this.attr.length != c.attr.length) {
            return false;
        }
        if (this.attr.length != 1) {
            return false;
        }
        if (!this.attr[0][0].equals(c.attr[0][0])) {
            return false;
        }
        this.attr[0][2] = c.attr[0][2];
        return true;
    }

    protected String createDescription(XModelObject o) {
        return String.valueOf(o.getAttributeValue("element type")) + " " + o.getModelEntity().getRenderer().getTitle(o);
    }
}

