/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.runtime.cmd;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.IRuleViolation;
import net.sourceforge.pmd.Report;
import net.sourceforge.pmd.Rule;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.AbstractDefaultCommand;
import net.sourceforge.pmd.eclipse.runtime.cmd.FakeRuleViolation;
import net.sourceforge.pmd.renderers.Renderer;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;

public class RenderReportCmd
extends AbstractDefaultCommand {
    private static final long serialVersionUID = 1L;
    private static final Logger log;
    private IProject project;
    private HashMap renderers = new HashMap();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.pmd.eclipse.runtime.cmd.RenderReportCmd");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = Logger.getLogger((Class)clazz);
    }

    public RenderReportCmd() {
        this.setDescription("Produce a HTML report for a project");
        this.setName("RenderReport");
        this.setOutputProperties(false);
        this.setReadOnly(false);
        this.setTerminated(false);
    }

    public void registerRenderer(Renderer renderer, String string) {
        this.renderers.put(string, renderer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void execute() throws CommandException {
        try {
            try {
                log.debug((Object)"Starting RenderReport command");
                log.debug((Object)"   Create a report object");
                Report report = this.createReport(this.project);
                log.debug((Object)"   Getting the report folder");
                IFolder iFolder = this.project.getFolder("reports");
                if (!iFolder.exists()) {
                    iFolder.create(true, true, this.getMonitor());
                }
                Iterator iterator = this.renderers.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String string = (String)entry.getKey();
                    Renderer renderer = (Renderer)entry.getValue();
                    log.debug((Object)"   Render the report");
                    StringWriter stringWriter = new StringWriter();
                    renderer.setWriter((Writer)stringWriter);
                    renderer.start();
                    renderer.renderFileReport(report);
                    renderer.end();
                    String string2 = stringWriter.toString();
                    log.debug((Object)"   Creating the report file");
                    IFile iFile = iFolder.getFile(string);
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
                    if (iFile.exists()) {
                        iFile.setContents((InputStream)byteArrayInputStream, true, false, this.getMonitor());
                    } else {
                        iFile.create((InputStream)byteArrayInputStream, true, this.getMonitor());
                    }
                    iFile.refreshLocal(2, this.getMonitor());
                    ((InputStream)byteArrayInputStream).close();
                }
            }
            catch (CoreException coreException) {
                log.debug((Object)("Core Exception: " + coreException.getMessage()), (Throwable)coreException);
                throw new CommandException(coreException);
            }
            catch (IOException iOException) {
                log.debug((Object)("Core Exception: " + iOException.getMessage()), (Throwable)iOException);
                throw new CommandException(iOException);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            log.debug((Object)"End of RenderReport command");
            this.setTerminated(true);
            throw throwable;
        }
        {
            Object var11_15 = null;
        }
        log.debug((Object)"End of RenderReport command");
        this.setTerminated(true);
    }

    public void reset() {
        this.setProject(null);
        this.renderers = new HashMap();
        this.setTerminated(false);
    }

    public void setProject(IProject iProject) {
        this.project = iProject;
    }

    public boolean isReadyToExecute() {
        return this.project != null && !this.renderers.isEmpty();
    }

    private Report createReport(IProject iProject) throws CoreException {
        Report report = new Report();
        IMarker[] iMarkerArray = iProject.findMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
        int n = 0;
        while (n < iMarkerArray.length) {
            IMarker iMarker = iMarkerArray[n];
            String string = iMarker.getAttribute("rulename", "");
            Rule rule = PMDPlugin.getDefault().getPreferencesManager().getRuleSet().getRuleByName(string);
            FakeRuleViolation fakeRuleViolation = new FakeRuleViolation(rule);
            fakeRuleViolation.setBeginLine(iMarker.getAttribute("lineNumber", 0));
            fakeRuleViolation.setEndLine(iMarker.getAttribute("line2", 0));
            fakeRuleViolation.setVariableName(iMarker.getAttribute("line2", ""));
            fakeRuleViolation.setFilename(iMarker.getResource().getProjectRelativePath().toString());
            fakeRuleViolation.setDescription(iMarker.getAttribute("message", rule.getMessage()));
            if (iMarkerArray[n].getResource() instanceof IFile) {
                ICompilationUnit iCompilationUnit = JavaCore.createCompilationUnitFrom((IFile)((IFile)iMarkerArray[n].getResource()));
                IPackageDeclaration[] iPackageDeclarationArray = iCompilationUnit.getPackageDeclarations();
                if (iPackageDeclarationArray.length > 0) {
                    fakeRuleViolation.setPackageName(iPackageDeclarationArray[0].getElementName());
                } else {
                    fakeRuleViolation.setPackageName("(default)");
                }
                IType[] iTypeArray = iCompilationUnit.getAllTypes();
                if (iTypeArray.length > 0) {
                    fakeRuleViolation.setClassName(iTypeArray[0].getElementName());
                } else {
                    fakeRuleViolation.setClassName(iMarker.getResource().getName());
                }
            }
            report.addRuleViolation((IRuleViolation)fakeRuleViolation);
            ++n;
        }
        return report;
    }
}

