/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutline;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlineContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOutlineLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.actions.RemoveViolationAction;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.Page;

public class ViolationOutlinePage
extends Page
implements IPage,
ISelectionChangedListener {
    private TableViewer tableViewer;
    private ViolationOutline violationOutline;
    private ViewerFilter viewerFilter;
    private FileRecord resource;
    protected final Integer[] columnWidths = new Integer[]{new Integer(20), new Integer(170), new Integer(40)};
    protected final int[] columnSortOrder = new int[]{1, 1, 1};
    protected int currentSortedColumn;

    public ViolationOutlinePage(FileRecord fileRecord, ViolationOutline violationOutline) {
        this.resource = fileRecord;
        this.violationOutline = violationOutline;
        ViewerFilter[] viewerFilterArray = violationOutline.getFilters();
        int n = 0;
        while (n < viewerFilterArray.length) {
            if (viewerFilterArray[n] instanceof PriorityFilter) {
                this.viewerFilter = viewerFilterArray[n];
            }
            ++n;
        }
    }

    public void createControl(Composite composite) {
        int n = 66306;
        this.tableViewer = new TableViewer(composite, n);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns(this.tableViewer.getTable());
        this.createActionBars();
        this.violationOutline.createContextMenu(this.tableViewer);
        this.tableViewer.setContentProvider((IContentProvider)new ViolationOutlineContentProvider(this));
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ViolationOutlineLabelProvider());
        this.tableViewer.setInput((Object)this.resource);
        this.tableViewer.addFilter(this.viewerFilter);
        this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    private void createColumns(Table table) {
        TableColumn tableColumn = new TableColumn(table, 16384);
        tableColumn.setWidth(20);
        tableColumn.setResizable(false);
        TableColumn tableColumn2 = new TableColumn(table, 16384);
        tableColumn2.setWidth(170);
        tableColumn2.setText(this.getString("view.outline.column_message"));
        TableColumn tableColumn3 = new TableColumn(table, 131072);
        tableColumn3.setWidth(40);
        tableColumn3.setText(this.getString("view.outline.column_line"));
        this.createColumnAdapters(this.tableViewer.getTable());
        this.tableViewer.setSorter(this.getViewerSorter(0));
    }

    private void createColumnAdapters(Table table) {
        TableColumn[] tableColumnArray = table.getColumns();
        int n = 0;
        while (n < tableColumnArray.length) {
            this.columnWidths[n] = new Integer(tableColumnArray[n].getWidth());
            final int n2 = n;
            tableColumnArray[n].addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    int n = ViolationOutlinePage.this.currentSortedColumn = n2;
                    ViolationOutlinePage.this.columnSortOrder[n] = ViolationOutlinePage.this.columnSortOrder[n] * -1;
                    ViolationOutlinePage.this.tableViewer.setSorter(ViolationOutlinePage.this.getViewerSorter(ViolationOutlinePage.this.currentSortedColumn));
                }
            });
            tableColumnArray[n].addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent controlEvent) {
                    ViolationOutlinePage.this.columnWidths[n2] = new Integer(ViolationOutlinePage.this.tableViewer.getTable().getColumn(n2).getWidth());
                }
            });
            ++n;
        }
    }

    private void createActionBars() {
        IToolBarManager iToolBarManager = this.getSite().getActionBars().getToolBarManager();
        RemoveViolationAction removeViolationAction = new RemoveViolationAction(this.tableViewer);
        iToolBarManager.add((IAction)removeViolationAction);
        iToolBarManager.add((IContributionItem)new Separator());
    }

    private ViewerSorter getViewerSorter(int n) {
        TableColumn tableColumn = this.tableViewer.getTable().getColumn(n);
        final int n2 = this.columnSortOrder[n];
        switch (n) {
            case 0: {
                return new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        IMarker iMarker = (IMarker)object;
                        IMarker iMarker2 = (IMarker)object2;
                        Integer n = new Integer(0);
                        Integer n22 = new Integer(0);
                        try {
                            n = (Integer)iMarker.getAttribute("pmd_priority");
                            n22 = (Integer)iMarker2.getAttribute("pmd_priority");
                            if (n.equals(n22)) {
                                n = (Integer)iMarker.getAttribute("lineNumber");
                                n22 = (Integer)iMarker2.getAttribute("lineNumber");
                            }
                        }
                        catch (CoreException coreException) {
                            PMDPlugin.getDefault().logError("message.error.core_exception", coreException);
                        }
                        return n == null ? 0 : n.compareTo(n22) * n2;
                    }
                };
            }
            case 1: {
                return new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        String string = "";
                        String string2 = "";
                        try {
                            string = String.valueOf(((IMarker)object).getAttribute("message"));
                            string2 = String.valueOf(((IMarker)object2).getAttribute("message"));
                        }
                        catch (CoreException coreException) {
                            PMDPlugin.getDefault().logError("message.error.core_exception" + ((Object)((Object)this)).toString(), coreException);
                        }
                        return string == null ? 0 : string.compareTo(string2) * n2;
                    }
                };
            }
            case 2: {
                return new TableColumnSorter(tableColumn, n2){

                    public int compare(Viewer viewer, Object object, Object object2) {
                        try {
                            Integer n = (Integer)((IMarker)object).getAttribute("lineNumber");
                            Integer n22 = (Integer)((IMarker)object2).getAttribute("lineNumber");
                            return n == null ? 0 : n.compareTo(n22) * n2;
                        }
                        catch (CoreException coreException) {
                            coreException.printStackTrace();
                            return 0;
                        }
                    }
                };
            }
        }
        return null;
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public Control getControl() {
        return this.tableViewer.getControl();
    }

    public void setFocus() {
        this.tableViewer.getTable().setFocus();
    }

    public FileRecord getResource() {
        return this.resource;
    }

    public void setColumnWidths(Integer[] integerArray) {
        if (this.tableViewer.getTable().isDisposed()) {
            return;
        }
        TableColumn[] tableColumnArray = this.tableViewer.getTable().getColumns();
        int n = 0;
        while (n < integerArray.length) {
            if (integerArray[n] == null) {
                integerArray[n] = n == 0 ? new Integer(20) : (n == 1 ? new Integer(170) : new Integer(40));
            }
            tableColumnArray[n].setWidth(integerArray[n].intValue());
            ++n;
        }
        System.arraycopy(integerArray, 0, this.columnWidths, 0, Math.min(this.columnWidths.length, integerArray.length));
    }

    public Integer[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setSorterProperties(Integer[] integerArray) {
        if (integerArray.length > 0) {
            this.currentSortedColumn = integerArray[0];
            this.columnSortOrder[this.currentSortedColumn] = integerArray[1];
            this.tableViewer.setSorter(this.getViewerSorter(this.currentSortedColumn));
        }
    }

    public Integer[] getSorterProperties() {
        return new Integer[]{new Integer(this.currentSortedColumn), new Integer(this.columnSortOrder[this.currentSortedColumn])};
    }

    public void refresh() {
        if (!this.tableViewer.getControl().isDisposed()) {
            this.tableViewer.getControl().setRedraw(false);
            this.tableViewer.refresh();
            this.tableViewer.getControl().setRedraw(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        IMarker iMarker = (IMarker)iStructuredSelection.getFirstElement();
        if (iMarker != null && (iEditorPart = this.getSite().getPage().getActiveEditor()) != null && (iEditorInput = iEditorPart.getEditorInput()) instanceof IFileEditorInput) {
            IFile iFile = ((IFileEditorInput)iEditorInput).getFile();
            if (iMarker.getResource().equals((Object)iFile)) {
                IDE.gotoMarker((IEditorPart)iEditorPart, (IMarker)iMarker);
            }
        }
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

