/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverview;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TreeItem;

public class CalculateStatisticsAction
extends Action {
    public ViolationOverview violationView;

    public CalculateStatisticsAction(ViolationOverview violationOverview) {
        this.violationView = violationOverview;
        this.setImageDescriptor(PMDPlugin.getImageDescriptor("icons/btn_calculate.gif"));
        this.setToolTipText(PMDPlugin.getDefault().getStringTable().getString("view.tooltip.calc_stats"));
    }

    public void run() {
        try {
            ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(Display.getCurrent().getActiveShell());
            progressMonitorDialog.setCancelable(true);
            progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                    TreeItem[] treeItemArray = CalculateStatisticsAction.this.violationView.getViewer().getTree().getItems();
                    int n = CalculateStatisticsAction.this.calculateWorkUnits(treeItemArray);
                    iProgressMonitor.beginTask(CalculateStatisticsAction.this.getString("monitor.calc_stats"), n);
                    int n2 = 0;
                    while (n2 < treeItemArray.length) {
                        if (iProgressMonitor.isCanceled()) break;
                        if (treeItemArray[n2].getData() instanceof PackageRecord) {
                            PackageRecord packageRecord = (PackageRecord)treeItemArray[n2].getData();
                            AbstractPMDRecord[] abstractPMDRecordArray = packageRecord.getChildren();
                            iProgressMonitor.subTask(String.valueOf(CalculateStatisticsAction.this.getString("monitor.calc_stats.package")) + ": " + packageRecord.getName());
                            int n3 = 0;
                            while (n3 < abstractPMDRecordArray.length) {
                                if (abstractPMDRecordArray[n3] instanceof FileRecord) {
                                    CalculateStatisticsAction.this.calculateFileRecord((FileRecord)abstractPMDRecordArray[n3]);
                                    iProgressMonitor.worked(1);
                                }
                                ++n3;
                            }
                        } else if (treeItemArray[n2].getData() instanceof FileRecord) {
                            CalculateStatisticsAction.this.calculateFileRecord((FileRecord)treeItemArray[n2].getData());
                            iProgressMonitor.worked(1);
                        }
                        ++n2;
                    }
                    CalculateStatisticsAction.this.violationView.getViewer().refresh(true);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.invocationtarget_exception"), invocationTargetException);
        }
        catch (InterruptedException interruptedException) {
            PMDPlugin.getDefault().logError(this.getString("message.error.interrupted_exception"), interruptedException);
        }
    }

    private void calculateFileRecord(FileRecord fileRecord) {
        if (fileRecord.getLOC() == 0) {
            fileRecord.calculateLinesOfCode();
            fileRecord.calculateNumberOfMethods();
        }
    }

    private int calculateWorkUnits(TreeItem[] treeItemArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < treeItemArray.length) {
            if (treeItemArray[n2].getData() instanceof PackageRecord) {
                PackageRecord packageRecord = (PackageRecord)treeItemArray[n2].getData();
                AbstractPMDRecord[] abstractPMDRecordArray = packageRecord.getChildren();
                n += abstractPMDRecordArray.length;
            } else if (treeItemArray[n2].getData() instanceof FileRecord) {
                ++n;
            }
            ++n2;
        }
        return n;
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }
}

