/*
 * Decompiled with CFR 0.152.
 */
package de.tobject.findbugs.view;

import de.tobject.findbugs.FindbugsPlugin;
import de.tobject.findbugs.reporter.MarkerUtil;
import de.tobject.findbugs.view.AbstractFindbugsView;
import de.tobject.findbugs.view.MarkerSelectionListener;
import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.I18N;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.util.Calendar;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;

public class UserAnnotationsView
extends AbstractFindbugsView {
    private String userAnnotation = "";
    private String firstVersionText = "";
    @CheckForNull
    private BugInstance theBug;
    private Text userAnnotationTextField;
    private Label firstVersionLabel;
    private Combo designationComboBox;
    private ISelectionListener selectionListener;

    public Composite createRootControl(Composite parent) {
        Composite main = new Composite(parent, 512);
        main.setLayout((Layout)new GridLayout(2, false));
        this.designationComboBox = new Combo(main, 16396);
        this.designationComboBox.setToolTipText("User-specified bug designation");
        this.designationComboBox.setLayoutData((Object)new GridData());
        for (String s : I18N.instance().getUserDesignationKeys(true)) {
            this.designationComboBox.add(I18N.instance().getUserDesignation(s));
        }
        this.designationComboBox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (UserAnnotationsView.this.theBug != null) {
                    UserAnnotationsView.this.theBug.setUserDesignationKeyIndex(UserAnnotationsView.this.designationComboBox.getSelectionIndex(), null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.designationComboBox.setSize(this.designationComboBox.computeSize(-1, -1));
        this.designationComboBox.setEnabled(false);
        this.firstVersionLabel = new Label(main, 16384);
        this.firstVersionLabel.setToolTipText("The earliest version in which the bug was present");
        this.firstVersionLabel.setLayoutData((Object)new GridData(768));
        this.userAnnotationTextField = new Text(main, 18496);
        this.userAnnotationTextField.setToolTipText("Type comments about the selected bug here");
        this.userAnnotationTextField.setEnabled(false);
        GridData uatfData = new GridData(1808);
        uatfData.horizontalSpan = 2;
        this.userAnnotationTextField.setLayoutData((Object)uatfData);
        this.userAnnotationTextField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (UserAnnotationsView.this.theBug != null) {
                    UserAnnotationsView.this.theBug.setAnnotationText(UserAnnotationsView.this.userAnnotationTextField.getText(), null);
                }
            }
        });
        ISelectionService theService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionListener = new MarkerSelectionListener(this);
        theService.addSelectionListener(this.selectionListener);
        return main;
    }

    public void dispose() {
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener(this.selectionListener);
            this.selectionListener = null;
        }
        super.dispose();
    }

    private void updateDisplay() {
        this.userAnnotationTextField.setText(this.userAnnotation);
        this.firstVersionLabel.setText(this.firstVersionText);
        if (this.theBug == null) {
            return;
        }
        int comboIndex = this.theBug.getUserDesignationKeyIndex();
        if (comboIndex == -1) {
            FindbugsPlugin.getDefault().logError("Cannot find user designation");
        } else {
            this.designationComboBox.select(comboIndex);
        }
    }

    public void setContent(String userAnnotation, BugInstance bug, String firstVersionText) {
        this.userAnnotation = userAnnotation == null ? "" : userAnnotation.trim();
        this.firstVersionText = firstVersionText == null ? "" : firstVersionText.trim();
        this.theBug = bug;
        this.userAnnotationTextField.setEnabled(this.theBug != null);
        this.designationComboBox.setEnabled(this.theBug != null);
        this.updateDisplay();
    }

    private void showInView(IMarker marker) {
        String bugType = marker.getAttribute("BUGTYPE", "");
        long timestamp = Long.parseLong(marker.getAttribute("FIRST_VERSION", "-2"));
        String firstVersion = "Bug present since: " + UserAnnotationsView.convertTimestamp(timestamp);
        BugPattern pattern = I18N.instance().lookupBugPattern(bugType);
        if (pattern == null) {
            return;
        }
        BugInstance bug = MarkerUtil.findBugInstanceForMarker(marker);
        String annotation = bug == null ? "Error - BugInstance not found." : bug.getAnnotationText();
        this.setContent(annotation, bug, firstVersion);
    }

    void showMarker(IMarker marker) {
        if (marker != null) {
            this.showInView(marker);
        }
    }

    public void markerSelected(IMarker newMarker) {
        this.showMarker(newMarker);
        if (!this.isVisible()) {
            this.activate();
        }
    }

    private static String convertTimestamp(long timestamp) {
        if (timestamp == -2L) {
            return "ERROR - Timestamp not found";
        }
        if (timestamp == -1L) {
            return "First version analyzed";
        }
        Calendar theCalendar = Calendar.getInstance();
        theCalendar.setTimeInMillis(System.currentTimeMillis());
        theCalendar.set(theCalendar.get(1), theCalendar.get(2), theCalendar.get(5), 0, 0, 0);
        long beginningOfToday = theCalendar.getTimeInMillis();
        long beginningOfYesterday = beginningOfToday - 86400000L;
        theCalendar.setTimeInMillis(timestamp);
        String timeString = theCalendar.getTime().toString();
        if (timestamp >= beginningOfToday) {
            return "Today " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        if (timestamp >= beginningOfYesterday) {
            return "Yesterday " + timeString.substring(timeString.indexOf(":") - 2, timeString.indexOf(":") + 3);
        }
        return timeString.substring(0, timeString.indexOf(":") + 3);
    }

    public void setFocus() {
        this.designationComboBox.setFocus();
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
    }
}

