/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.XClass;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.classfile.CheckedAnalysisException;
import edu.umd.cs.findbugs.classfile.ClassDescriptor;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.detect.UnreadFields;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariable;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.classfile.Visitor;

public class FindMaskedFields
extends BytecodeScanningDetector {
    private BugReporter bugReporter;
    private int numParms;
    private Map<String, Field> classFields = new HashMap<String, Field>();
    private boolean staticMethod;
    private Collection<RememberedBug> rememberedBugs = new LinkedList<RememberedBug>();
    private static final boolean ENABLE_LOCALS = SystemProperties.getBoolean("findbugs.maskedfields.locals");

    public FindMaskedFields(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    public void visitClassContext(ClassContext classContext) {
        JavaClass obj = classContext.getJavaClass();
        if (!obj.isInterface()) {
            classContext.getJavaClass().accept((Visitor)this);
        }
    }

    public void visit(JavaClass obj) {
        ClassDescriptor s;
        String fieldName;
        Field[] fields;
        this.classFields.clear();
        for (Field field : fields = obj.getFields()) {
            if (field.isStatic() || field.isPrivate()) continue;
            fieldName = field.getName();
            this.classFields.put(fieldName, field);
        }
        XClass c = this.getXClass();
        while ((s = c.getSuperclassDescriptor()) != null && !s.getClassName().equals("java/lang/Object")) {
            try {
                c = Global.getAnalysisCache().getClassAnalysis(XClass.class, s);
            }
            catch (CheckedAnalysisException e) {
                break;
            }
            XClass superClass = c;
            for (XField xField : c.getXFields()) {
                String superClassName;
                if (xField.isStatic() || !xField.isPublic() && !xField.isProtected() || (fieldName = xField.getName()).length() == 1 || fieldName.equals("serialVersionUID") || (superClassName = s.getClassName()).startsWith("java/io") && (superClassName.endsWith("InputStream") && fieldName.equals("in") || superClassName.endsWith("OutputStream") && fieldName.equals("out")) || !this.classFields.containsKey(fieldName)) continue;
                Field maskingField = this.classFields.get(fieldName);
                String mClassName = this.getDottedClassName();
                FieldAnnotation fa = new FieldAnnotation(mClassName, maskingField.getName(), maskingField.getSignature(), maskingField.isStatic());
                int priority = 2;
                if (maskingField.isStatic() || maskingField.isFinal()) {
                    ++priority;
                } else if (xField.getSignature().charAt(0) == 'L' && !xField.getSignature().startsWith("Ljava/lang/") || xField.getSignature().charAt(0) == '[') {
                    --priority;
                }
                if (!xField.getSignature().equals(maskingField.getSignature())) {
                    priority += 2;
                } else if (xField.getAccessFlags() != maskingField.getAccessFlags()) {
                    ++priority;
                }
                if (xField.isSynthetic() || xField.getName().indexOf(36) >= 0) {
                    ++priority;
                }
                FieldAnnotation maskedFieldAnnotation = FieldAnnotation.fromFieldDescriptor(xField.getFieldDescriptor());
                BugInstance bug = new BugInstance(this, "MF_CLASS_MASKS_FIELD", priority).addClass(this).addField(fa).describe("FIELD_MASKING").addField(maskedFieldAnnotation).describe("FIELD_MASKED");
                this.rememberedBugs.add(new RememberedBug(bug, fa, maskedFieldAnnotation));
            }
        }
        super.visit(obj);
    }

    public void visit(Method obj) {
        super.visit(obj);
        this.numParms = this.getNumberMethodArguments();
        if (!obj.isStatic()) {
            ++this.numParms;
        }
        this.staticMethod = obj.isStatic();
    }

    public void visit(LocalVariableTable obj) {
        if (ENABLE_LOCALS) {
            LocalVariable[] vars;
            if (this.staticMethod) {
                return;
            }
            for (LocalVariable var : vars = obj.getLocalVariableTable()) {
                Field f;
                String varName;
                if (var.getIndex() < this.numParms || (varName = var.getName()).equals("serialVersionUID") || (f = this.classFields.get(varName)) == null) continue;
                FieldAnnotation fa = FieldAnnotation.fromBCELField(this.getDottedClassName(), f);
                this.bugReporter.reportBug(new BugInstance(this, "MF_METHOD_MASKS_FIELD", 3).addClassAndMethod(this).addField(fa).addSourceLine(this, var.getStartPC() - 1));
            }
        }
        super.visit(obj);
    }

    public void report() {
        UnreadFields unreadFields = AnalysisContext.currentAnalysisContext().getUnreadFields();
        for (RememberedBug rb : this.rememberedBugs) {
            BugInstance bug = rb.bug;
            int score1 = 0;
            int score2 = 0;
            int priority = bug.getPriority();
            if (unreadFields.classesScanned.contains(rb.maskedField.getClassName())) {
                if (unreadFields.getReadFields().contains(rb.maskedField)) {
                    ++score1;
                }
                if (unreadFields.getWrittenFields().contains(rb.maskedField)) {
                    ++score1;
                }
                if (unreadFields.isWrittenOutsideOfInitialization(rb.maskedField)) {
                    ++score1;
                }
            } else {
                score1 += 2;
            }
            if (unreadFields.getReadFields().contains(rb.maskingField)) {
                ++score2;
            }
            if (unreadFields.getWrittenFields().contains(rb.maskingField)) {
                ++score2;
            }
            if (unreadFields.isWrittenOutsideOfInitialization(rb.maskingField)) {
                ++score2;
            }
            int score = score1 + score2;
            if (score1 == 0 || score2 == 0) {
                bug.setPriority(priority + 1);
            } else if (score >= 5) {
                bug.setPriority(priority - 1);
            } else if (score < 3) {
                bug.setPriority(priority + 1);
            }
            this.bugReporter.reportBug(bug);
        }
    }

    static class RememberedBug {
        BugInstance bug;
        XField maskingField;
        XField maskedField;

        RememberedBug(BugInstance bug, FieldAnnotation maskingField, FieldAnnotation maskedField) {
            this.bug = bug;
            this.maskingField = XFactory.createXField(maskingField);
            this.maskedField = XFactory.createXField(maskedField);
        }
    }
}

