/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.attribute.adapter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.ListIterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.CompletionRequestor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeContentProposal;
import org.eclipse.pde.internal.ui.editor.contentassist.TypePackageCompletionProcessor;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.attribute.IValueFilter;

class TypeContentProposalProvider
extends TypePackageCompletionProcessor
implements IContentProposalProvider {
    public static final char F_DOT = '.';
    private IProject fProject;
    private int fTypeScope;
    private ArrayList fInitialContentProposals;
    private String fInitialContent;
    private Comparator fComparator;
    IValueFilter valueFilter;

    public TypeContentProposalProvider(IProject project, int scope, IValueFilter valueFilter) {
        this.fProject = project;
        this.fTypeScope = scope;
        this.fComparator = new TypeComparator();
        this.valueFilter = valueFilter;
        this.reset();
    }

    public IContentProposal[] getProposals(String contents, int position) {
        ArrayList currentContentProposals = null;
        currentContentProposals = position == 0 ? null : (this.fInitialContentProposals == null || !contents.startsWith(this.fInitialContent) || this.endsWithDot(contents) ? this.generateContentProposals(contents.substring(0, position)) : this.filterContentProposals(contents));
        currentContentProposals = this.filterContentProposalsByValueFilter(currentContentProposals);
        return this.convertResultsToSortedProposals(currentContentProposals);
    }

    public void reset() {
        this.fInitialContentProposals = null;
    }

    protected void addProposalToCollection(Collection collection, int startOffset, int length, String label, String content, Image image) {
        TypeContentProposal proposal = new TypeContentProposal(label, content, null, image);
        collection.add(proposal);
    }

    private boolean endsWithDot(String string) {
        int index = string.lastIndexOf(46);
        return index + 1 == string.length();
    }

    private ArrayList generateContentProposals(String currentContent) {
        this.fInitialContentProposals = new ArrayList();
        this.fInitialContent = currentContent;
        this.generateTypePackageProposals(currentContent, this.fProject, this.fInitialContentProposals, 0, this.fTypeScope, true);
        return this.fInitialContentProposals;
    }

    private IContentProposal[] convertResultsToSortedProposals(ArrayList list) {
        IContentProposal[] proposals = null;
        if (list != null && list.size() != 0) {
            proposals = list.toArray(new IContentProposal[list.size()]);
            Arrays.sort(proposals, this.fComparator);
        } else {
            proposals = new IContentProposal[]{};
        }
        return proposals;
    }

    private ArrayList filterContentProposals(String currentContent) {
        String lowerCaseCurrentContent = currentContent.toLowerCase();
        ListIterator iterator = this.fInitialContentProposals.listIterator();
        ArrayList<IContentProposal> filteredContentProposals = new ArrayList<IContentProposal>();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            IContentProposal proposal = (IContentProposal)object;
            String compareString = null;
            compareString = lowerCaseCurrentContent.indexOf(46) == -1 ? proposal.getLabel().toLowerCase() : proposal.getContent().toLowerCase();
            if (!compareString.startsWith(lowerCaseCurrentContent, 0)) continue;
            filteredContentProposals.add(proposal);
        }
        return filteredContentProposals;
    }

    private ArrayList filterContentProposalsByValueFilter(ArrayList filteredContentProposals) {
        if (this.valueFilter != null && filteredContentProposals != null) {
            ArrayList<IContentProposal> filteredContentProposals2 = new ArrayList<IContentProposal>();
            ListIterator iterator = filteredContentProposals.listIterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                IContentProposal proposal = (IContentProposal)object;
                String value = proposal.getContent();
                if (!this.valueFilter.accept(value)) continue;
                filteredContentProposals2.add(proposal);
            }
            filteredContentProposals = filteredContentProposals2;
        }
        return filteredContentProposals;
    }

    protected void generateTypePackageProposals(String currentContent, IProject project, Collection c, int startOffset, int typeScope, boolean replaceEntireContents) {
        currentContent = this.removeLeadingSpaces(currentContent);
        if (c == null || currentContent.length() == 0) {
            return;
        }
        int length = replaceEntireContents ? -1 : currentContent.length();
        this.generateProposals(currentContent, project, c, startOffset, length, typeScope);
    }

    private void generateProposals(String currentContent, IProject project, Collection c, int startOffset, int length, int typeScope) {
        try {
            ICompilationUnit unit = this.getWorkingCopy(project);
            if (unit == null) {
                this.generateTypeProposals(currentContent, project, c, startOffset, length, 1);
                return;
            }
            IBuffer buff = unit.getBuffer();
            buff.setContents("class Dummy2 { " + currentContent);
            class TypePackageCompletionRequestor
            extends CompletionRequestor {
                private final /* synthetic */ Collection val$c;
                private final /* synthetic */ int val$startOffset;
                private final /* synthetic */ int val$length;
                private final /* synthetic */ int val$typeScope;

                public TypePackageCompletionRequestor(Collection collection, int n, int n2, int n3) {
                    this.val$c = collection;
                    this.val$startOffset = n;
                    this.val$length = n2;
                    this.val$typeScope = n3;
                    super(true);
                    this.setIgnored(8, false);
                    this.setIgnored(9, false);
                }

                public void accept(CompletionProposal proposal) {
                    if (proposal.getKind() == 8) {
                        String pkgName = new String(proposal.getCompletion());
                        TypeContentProposalProvider.this.addProposalToCollection(this.val$c, this.val$startOffset, this.val$length, pkgName, pkgName, PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_PACKAGE));
                    } else {
                        boolean isInterface = Flags.isInterface((int)proposal.getFlags());
                        String completion = new String(proposal.getCompletion());
                        if (isInterface && this.val$typeScope == 5 || !isInterface && this.val$typeScope == 6 || completion.equals("Dummy2")) {
                            return;
                        }
                        int period = completion.lastIndexOf(46);
                        String cName = null;
                        String pName = null;
                        if (period == -1) {
                            cName = completion;
                        } else {
                            cName = completion.substring(period + 1);
                            pName = completion.substring(0, period);
                        }
                        if (pName == null) {
                            char[] declaration = proposal.getDeclarationSignature();
                            pName = declaration == null || declaration.length == 0 ? "(default)" : new String(declaration);
                        }
                        Image image = isInterface ? PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_GENERATE_INTERFACE) : PDEPluginImages.get((String)PDEPluginImages.OBJ_DESC_GENERATE_CLASS);
                        TypeContentProposalProvider.this.addProposalToCollection(this.val$c, this.val$startOffset, this.val$length, String.valueOf(cName) + " - " + pName, completion, image);
                    }
                }
            }
            TypePackageCompletionRequestor req = new TypePackageCompletionRequestor(c, startOffset, length, typeScope);
            unit.codeComplete(15 + currentContent.length(), (CompletionRequestor)req);
            unit.discardWorkingCopy();
        }
        catch (JavaModelException e) {
            ModelUIPlugin.getPluginLog().logError((Throwable)e);
        }
    }

    private ICompilationUnit getWorkingCopy(IProject project) throws JavaModelException {
        IPackageFragmentRoot[] roots = JavaCore.create((IProject)project).getPackageFragmentRoots();
        if (roots.length > 0) {
            IPackageFragment frag = null;
            int i = 0;
            while (i < roots.length) {
                IJavaElement[] elems;
                if ((roots[i].getKind() == 1 || project.equals((Object)roots[i].getCorrespondingResource()) || roots[i].isArchive() && !roots[i].isExternal()) && (elems = roots[i].getChildren()).length > 0 && i < elems.length && elems[i] instanceof IPackageFragment) {
                    frag = (IPackageFragment)elems[i];
                    break;
                }
                ++i;
            }
            if (frag != null) {
                return frag.getCompilationUnit("Dummy2.java").getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
        }
        return null;
    }

    private static class TypeComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            String proposalSortKey1 = ((IContentProposal)arg0).getLabel();
            String proposalSortKey2 = ((IContentProposal)arg1).getLabel();
            return proposalSortKey1.compareToIgnoreCase(proposalSortKey2);
        }
    }
}

