/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.model.plugin.ModelPlugin;

public class DropWizardDialog
extends WizardDialog {
    private static final int DO_WIDTH_VALUE = 450;
    private static final int DO_HEIGHT_VALUE = 530;
    private static final int DO_WIDTH_VALUE_LINUX = 550;

    public DropWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected void configureShell(Shell newShell) {
        Composite shell = newShell == null ? null : newShell.getParent();
        super.configureShell(newShell);
        int width = this.getPreferredWidth();
        int height = 530;
        Display d = shell != null ? shell.getDisplay() : ModelPlugin.getDefault().getWorkbench().getDisplay();
        int x = d.getBounds().width / 2 - width / 2;
        int y = d.getBounds().height / 2 - height / 2;
        if (shell != null) {
            x = shell.getBounds().x + shell.getBounds().width / 2 - width / 2;
            if (x < 0) {
                x = 0;
            }
            if ((y = shell.getBounds().y + shell.getBounds().height / 2 - height / 2) + height > d.getBounds().height) {
                y = d.getBounds().height - height;
            }
        }
        newShell.setBounds(x, y, width, height);
    }

    protected int getPreferredWidth() {
        String os_name = System.getProperty("os.name");
        if (os_name != null && os_name.indexOf("Windows") >= 0) {
            return 450;
        }
        return 550;
    }

    public void updateButtons() {
        boolean canFlipToNextPage = false;
        boolean canFinish = this.getWizard().canFinish();
        if (this.getButton(14) != null) {
            this.getButton(14).setEnabled(this.getCurrentPage().getPreviousPage() != null);
        }
        if (this.getButton(15) != null) {
            canFlipToNextPage = this.getCurrentPage().canFlipToNextPage();
            this.getButton(15).setEnabled(canFlipToNextPage);
        }
        this.getButton(16).setEnabled(canFinish);
        this.getShell().setDefaultButton(null);
    }

    protected Button createButton(Composite parent, int id, String label, boolean defaultButton) {
        Button button = super.createButton(parent, id, label, defaultButton);
        if (id == 16) {
            this.getShell().setDefaultButton(null);
        }
        return button;
    }

    public void create() {
        super.create();
        this.getShell().addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent e) {
                if (e.character == '\r') {
                    Button finishButton = DropWizardDialog.this.getButton(16);
                    Button cancelButton = DropWizardDialog.this.getButton(1);
                    if (!finishButton.isFocusControl() && !cancelButton.isFocusControl()) {
                        if (finishButton.isEnabled()) {
                            DropWizardDialog.this.buttonPressed(16);
                        } else {
                            DropWizardDialog.this.handleShellCloseEvent();
                        }
                    }
                }
            }
        });
    }
}

