/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.editors.dnd.context;

import java.io.File;
import java.net.MalformedURLException;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.ui.IEditorPart;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.XModelTransferBuffer;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.ModelUIPlugin;
import org.jboss.tools.common.model.ui.dnd.ModelTransfer;
import org.jboss.tools.common.model.ui.dnd.VpeDnDEvent;
import org.jboss.tools.common.model.ui.dnd.VpeTextDropAction;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class DropContext {
    private boolean isOverAttributeValue = false;
    private String attributeName = null;
    private String flavor = null;
    private String mimeData = null;
    private TypedEvent event;
    TransferHolder[] TRANSFERS = new TransferHolder[]{new TransferHolder((Transfer)LocalSelectionTransfer.getTransfer(), new LocalTransferProcessor()), new TransferHolder((Transfer)ModelTransfer.getInstance(), new ModelTransferProcessor()), new TransferHolder((Transfer)HTMLTransfer.getInstance(), new HTMLTransferProcessor()), new TransferHolder((Transfer)FileTransfer.getInstance(), new FileTransferProcessor()), new TransferHolder((Transfer)TextTransfer.getInstance(), new TextTransferProcessor())};
    public static Set<String> mappedExtensions = new HashSet<String>();
    static String FILE_ENTITIES = ".FileTLD_PRO.FileTLD_1_2.FileTLD_2_0.FileTLD_2_1.";

    public void setFlavor(String flavor) {
        this.flavor = flavor;
    }

    public void setMimeData(String mimeData) {
        this.mimeData = mimeData;
    }

    public void clean() {
        this.isOverAttributeValue = false;
        this.flavor = null;
        this.mimeData = null;
        this.attributeName = null;
    }

    public boolean isOverAttributeValue() {
        return this.isOverAttributeValue;
    }

    public void setOverAttributeValue(boolean b) {
        this.isOverAttributeValue = b;
    }

    public void setAttributeName(String attr) {
        this.attributeName = attr;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getMimeData() {
        return this.mimeData;
    }

    public void setDropTargetEvent(TypedEvent event) {
        this.event = event;
        TransferData[] ds = null;
        if (this.event instanceof DropTargetEvent) {
            ds = ((DropTargetEvent)event).dataTypes;
        } else if (this.event instanceof VpeDnDEvent) {
            ds = ((VpeDnDEvent)this.event).getDataTypes();
        }
        if (ds != null) {
            int i = 0;
            while (i < this.TRANSFERS.length) {
                TransferData data = this.TRANSFERS[i].getSupportedData(ds);
                if (data != null) {
                    this.TRANSFERS[i].process(data);
                    break;
                }
                ++i;
            }
        }
    }

    private String getURL(TypedEvent event) {
        String[] s = (String[])event.data;
        if (s == null || s.length == 0) {
            return null;
        }
        return DropUtils.convertPathToUrl(s[0]);
    }

    private File getFile(TypedEvent event) {
        String[] s = (String[])event.data;
        return s == null || s.length == 0 ? null : new File(s[0]);
    }

    private String getURL(XModelObject o) {
        if (o.getFileType() == 1) {
            IFile f = (IFile)EclipseResourceUtil.getResource((XModelObject)o);
            if (f == null || !f.exists()) {
                return null;
            }
            try {
                return f.getLocation().toFile().toURL().toString();
            }
            catch (MalformedURLException e) {
                ModelUIPlugin.getPluginLog().logError((Throwable)e);
            }
        }
        return null;
    }

    public void runDropCommand(IDNDTextEditor editor, TypedEvent event) {
        this.setDropTargetEvent(event);
        this.runDropCommand(editor);
    }

    public void runDropCommand(IDNDTextEditor editor) {
        if (this.event == null) {
            return;
        }
        if (this.getFlavor() == null) {
            return;
        }
        if (this.getFlavor().equals("text/html")) {
            new VpeTextDropAction().run(this.event, (IEditorPart)editor);
        } else {
            editor.runDropCommand(this.getFlavor(), this.getMimeData());
        }
        this.event = null;
    }

    public static boolean isExtensionMapped(String extension) {
        return extension != null && mappedExtensions.contains(extension.toLowerCase());
    }

    private boolean dropAsFileObject(XModelObject o) {
        if (o == null) {
            return false;
        }
        if (o.getFileType() != 1 || this.isOverAttributeValue) {
            return false;
        }
        if (DropContext.isTaglib(o)) {
            return false;
        }
        String extension = o.getAttributeValue("extension");
        return extension != null && DropContext.isExtensionMapped(extension);
    }

    public static boolean isTaglib(XModelObject o) {
        return DropContext.isOfEntity(o, FILE_ENTITIES);
    }

    private static boolean isOfEntity(XModelObject o, String entities) {
        return entities.indexOf("." + o.getModelEntity().getName() + ".") >= 0;
    }

    class FileTransferProcessor
    extends TransferProcessor {
        FileTransferProcessor() {
        }

        public void process(TransferData data) {
            ISelection s = LocalSelectionTransfer.getTransfer().getSelection();
            if (s != null) {
                if (s.isEmpty() || !(s instanceof IStructuredSelection)) {
                    return;
                }
                Object o = ((IStructuredSelection)s).getFirstElement();
                boolean ok = o instanceof IFile;
                if (!ok && o instanceof IAdaptable) {
                    boolean bl = ok = ((IAdaptable)o).getAdapter(IFile.class) != null && ((IAdaptable)o).getAdapter(IResource.class) != null;
                }
                if (!ok) {
                    return;
                }
            }
            DropContext.this.mimeData = DropContext.this.getURL(DropContext.this.event);
            DropContext.this.flavor = "application/x-moz-file";
            if (DropContext.this.mimeData != null && DropContext.this.isOverAttributeValue) {
                XModelObject fo;
                String path = DropContext.this.getFile(DropContext.this.event).getAbsolutePath();
                IFile f = EclipseResourceUtil.getFile((String)path);
                XModelObject xModelObject = fo = f == null ? null : EclipseResourceUtil.getObjectByResource((IResource)f);
                if (fo != null) {
                    fo.getModel().getModelBuffer().clear();
                    fo.getModel().getModelBuffer().addSource(fo);
                    DropContext.this.flavor = "vpe/model";
                }
            }
        }
    }

    class HTMLTransferProcessor
    extends TransferProcessor {
        HTMLTransferProcessor() {
        }

        public void process(TransferData data) {
            DropContext.this.flavor = "text/html";
            TransferData currentDataType = null;
            if (DropContext.this.event instanceof DropTargetEvent) {
                currentDataType = ((DropTargetEvent)((DropContext)DropContext.this).event).currentDataType;
            } else if (DropContext.this.event instanceof VpeDnDEvent) {
                currentDataType = ((VpeDnDEvent)((DropContext)DropContext.this).event).currentDataType;
            }
            Object ooo = HTMLTransfer.getInstance().nativeToJava(currentDataType);
            DropContext.this.mimeData = ooo == null ? null : ooo.toString();
            if (DropContext.this.mimeData == null) {
                DropContext.this.flavor = null;
            }
        }
    }

    class LocalTransferProcessor
    extends TransferProcessor {
        LocalTransferProcessor() {
        }

        public void process(TransferData data) {
            DropContext.this.flavor = "application/x-moz-file";
            Object ooo = LocalSelectionTransfer.getTransfer().getSelection();
            if (ooo instanceof StructuredSelection) {
                ooo = ((StructuredSelection)ooo).getFirstElement();
            }
            DropContext.this.mimeData = ooo == null ? null : ooo.toString();
        }
    }

    class ModelTransferProcessor
    extends TransferProcessor {
        ModelTransferProcessor() {
        }

        public void process(TransferData data) {
            if (!XModelTransferBuffer.getInstance().isEnabled()) {
                return;
            }
            XModelObject o = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
            if (DropContext.this.dropAsFileObject(o)) {
                DropContext.this.flavor = "application/x-moz-file";
                DropContext.this.mimeData = DropContext.this.getURL(o);
                if (DropContext.this.mimeData == null) {
                    DropContext.this.flavor = "vpe/model";
                }
            } else {
                DropContext.this.flavor = "vpe/model";
            }
        }
    }

    class TextTransferProcessor
    extends TransferProcessor {
        TextTransferProcessor() {
        }

        public void process(TransferData data) {
            DropContext.this.flavor = "text/html";
        }
    }

    class TransferHolder {
        Transfer transfer;
        TransferProcessor processor;

        public TransferHolder(Transfer transfer, TransferProcessor processor) {
            this.transfer = transfer;
            this.processor = processor;
        }

        public TransferData getSupportedData(TransferData[] data) {
            int i = 0;
            while (i < data.length) {
                if (this.transfer.isSupportedType(data[i])) {
                    return data[i];
                }
                ++i;
            }
            return null;
        }

        public void process(TransferData data) {
            this.processor.process(data);
        }
    }

    abstract class TransferProcessor {
        TransferProcessor() {
        }

        abstract void process(TransferData var1);
    }
}

