/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.preferences;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.jboss.tools.common.model.XModelFactory;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.ui.ModelUIMessages;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultXModelObjectLabelProvider;
import org.jboss.tools.common.model.ui.navigator.decorator.DecoratorManager;
import org.jboss.tools.common.model.ui.navigator.decorator.Variable;
import org.jboss.tools.common.model.ui.navigator.decorator.XModelObjectDecorator;
import org.jboss.tools.common.model.ui.preferences.IPreferencePageExt;
import org.jboss.tools.common.model.util.EclipseResourceUtil;

public class DecoratorTextPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
IPreferencePageExt {
    TreeViewer decorators;
    Composite editor;
    Text formatField;
    ModifyListener formatListener = new ML();
    Button addVariableButton;
    TreeViewer examples;
    XModelObjectDecorator selection = null;
    Map<XModelObjectDecorator, String> currentValues = new HashMap<XModelObjectDecorator, String>();
    static DComparator comparator = new DComparator();

    public DecoratorTextPreferencesPage() {
        this.setTitle(ModelUIMessages.DecoratorTextPreferencesPage_Text);
    }

    protected Control createContents(Composite parent) {
        Composite c;
        this.init(null);
        Composite g = new Composite(parent, 0);
        g.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(g, 0);
        label.setText(ModelUIMessages.DecoratorTextPreferencesPage_Decorator);
        label.setLayoutData((Object)new GridData(768));
        this.decorators = new TreeViewer(g, 2820);
        this.decorators.setAutoExpandLevel(2);
        this.decorators.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof XModelObjectDecorator) {
                    XModelObjectDecorator d = (XModelObjectDecorator)element;
                    return d.getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                String entity = null;
                if (element instanceof XModelObjectDecorator) {
                    XModelObjectDecorator d = (XModelObjectDecorator)element;
                    Set<String> es = d.getEntities();
                    entity = es == null || es.size() == 0 ? null : es.iterator().next();
                } else if (element instanceof String) {
                    entity = DecoratorManager.getInstance().getBaseEntityForPartition(element.toString());
                }
                XModelObject o = entity == null ? null : XModelFactory.getDefaultInstance().createModelObject(entity, new Properties());
                return o != null ? EclipseResourceUtil.getImage((XModelObject)o) : null;
            }
        });
        this.decorators.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof String) {
                    Set<XModelObjectDecorator> set = DecoratorManager.getInstance().getDecoratorsByPartition(parentElement.toString());
                    if (set != null) {
                        Object[] ds = set.toArray(new XModelObjectDecorator[0]);
                        Arrays.sort(ds, comparator);
                        return ds;
                    }
                    return new Object[0];
                }
                return new Object[0];
            }

            public Object getParent(Object element) {
                if (element instanceof XModelObjectDecorator) {
                    return ((XModelObjectDecorator)element).getPartition();
                }
                return null;
            }

            public boolean hasChildren(Object element) {
                return element instanceof String;
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement == DecoratorManager.getInstance()) {
                    return DecoratorManager.getInstance().getPartitions();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.decorators.setInput((Object)DecoratorManager.getInstance());
        this.decorators.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DecoratorTextPreferencesPage.this.onSelectionChanged(event.getSelection());
            }
        });
        GridData treeLayoutData = new GridData(768);
        treeLayoutData.heightHint = 150;
        this.decorators.getTree().setLayoutData((Object)treeLayoutData);
        this.editor = c = new Composite(g, 0);
        GridLayout cLayout = new GridLayout(3, false);
        c.setLayout((Layout)cLayout);
        c.setLayoutData((Object)new GridData(768));
        Label cLabel = new Label(c, 0);
        cLabel.setText(ModelUIMessages.DecoratorTextPreferencesPage_Format);
        this.formatField = new Text(c, 2052);
        this.formatField.setLayoutData((Object)new GridData(768));
        this.addVariableButton = new Button(c, 8);
        this.addVariableButton.setText(ModelUIMessages.DecoratorTextPreferencesPage_AddVariable);
        this.addVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                DecoratorTextPreferencesPage.this.addVariable();
            }
        });
        label = new Label(g, 0);
        label.setText(ModelUIMessages.DecoratorTextPreferencesPage_Preview);
        label.setLayoutData((Object)new GridData(768));
        this.examples = new TreeViewer(g, 2820);
        this.examples.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (DecoratorTextPreferencesPage.this.selection != null) {
                    return DecoratorTextPreferencesPage.this.selection.getExamples();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.examples.setLabelProvider((IBaseLabelProvider)new DefaultXModelObjectLabelProvider(){

            public String getText(Object element) {
                if (DecoratorTextPreferencesPage.this.selection == null) {
                    return super.getText(element);
                }
                String result = "";
                if (element instanceof XModelObject) {
                    XModelObject modelObject = (XModelObject)element;
                    XModelObjectDecorator d = DecoratorTextPreferencesPage.this.selection.getWorkingCopy();
                    d.setValue(DecoratorTextPreferencesPage.this.formatField.getText());
                    result = d.getLabel(modelObject);
                } else {
                    result = ModelUIMessages.DecoratorTextPreferencesPage_DefaultLabel;
                }
                return result;
            }
        });
        treeLayoutData = new GridData(768);
        treeLayoutData.heightHint = 100;
        this.examples.getTree().setLayoutData((Object)treeLayoutData);
        this.examples.setInput((Object)DecoratorManager.getInstance());
        this.setSelectedObject(null);
        return g;
    }

    public void init(IWorkbench workbench) {
        String[] ps = DecoratorManager.getInstance().getPartitions();
        int i = 0;
        while (i < ps.length) {
            Set<XModelObjectDecorator> set = DecoratorManager.getInstance().getDecoratorsByPartition(ps[i]);
            for (XModelObjectDecorator d : set) {
                this.currentValues.put(d, d.getValue());
            }
            ++i;
        }
    }

    public boolean performCancel() {
        return true;
    }

    public boolean performOk() {
        boolean change = false;
        for (XModelObjectDecorator d : this.currentValues.keySet()) {
            if (this.equal(d.getValue(), this.currentValues.get(d))) continue;
            change = true;
            d.setValue(this.currentValues.get(d));
        }
        if (change) {
            DecoratorManager.getInstance().applyToPreferences();
        }
        return super.performOk();
    }

    private boolean equal(String a, String b) {
        if (a == null) {
            return b == null;
        }
        return a.equals(b);
    }

    public void performDefaults() {
        for (XModelObjectDecorator d : this.currentValues.keySet()) {
            String dv = d.getDefaultValue();
            if (dv == null || dv.length() == 0) {
                dv = Variable.NAME.getRuleText();
            }
            this.currentValues.put(d, dv);
        }
        if (this.selection != null) {
            this.setText(this.currentValues.get(this.selection));
        }
    }

    private void onSelectionChanged(ISelection s) {
        Object o;
        if (!s.isEmpty() && s instanceof IStructuredSelection && (o = ((IStructuredSelection)s).getFirstElement()) instanceof XModelObjectDecorator) {
            this.setSelectedObject((XModelObjectDecorator)o);
            return;
        }
        this.setSelectedObject(null);
    }

    private void setSelectedObject(XModelObjectDecorator d) {
        this.selection = d;
        if (d != null) {
            this.formatField.setEnabled(true);
            this.addVariableButton.setEnabled(true);
            String text = this.currentValues.get(d);
            this.setText(text);
        } else {
            this.formatField.setEnabled(false);
            this.addVariableButton.setEnabled(false);
            this.setText("");
        }
        this.examples.refresh(true);
    }

    private void setText(String text) {
        if (text == null) {
            text = "";
        }
        this.formatField.removeModifyListener(this.formatListener);
        this.formatField.setText(text);
        this.formatField.addModifyListener(this.formatListener);
    }

    private void addVariable() {
        CheckedTreeSelectionDialog dialog = new CheckedTreeSelectionDialog(this.addVariableButton.getShell(), (ILabelProvider)new LabelProvider(), new ITreeContentProvider(){

            public Object[] getChildren(Object parentElement) {
                return null;
            }

            public Object getParent(Object element) {
                return null;
            }

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object[] getElements(Object inputElement) {
                if (DecoratorTextPreferencesPage.this.selection != null) {
                    return DecoratorTextPreferencesPage.this.selection.getVariables();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        dialog.setInput((Object)this.selection);
        dialog.setTitle(ModelUIMessages.DecoratorTextPreferencesPage_SelectVariable);
        dialog.create();
        int result = dialog.open();
        if (result == 0) {
            this.addVariable(dialog.getResult());
        }
    }

    private void addVariable(Object[] checked) {
        if (checked == null || checked.length == 0) {
            return;
        }
        String text = this.formatField.getText();
        int c = this.formatField.getCaretPosition();
        if (c < 0 || c > text.length()) {
            c = text.length();
        }
        StringBuffer sb = new StringBuffer(text.substring(0, c));
        int i = 0;
        while (i < checked.length) {
            Variable v = (Variable)checked[i];
            sb.append(v.getRuleText());
            ++i;
        }
        int cn = sb.length();
        sb.append(text.substring(c));
        text = sb.toString();
        this.currentValues.put(this.selection, text);
        this.setText(text);
        this.formatField.setSelection(cn);
        this.examples.refresh(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class DComparator
    implements Comparator<XModelObjectDecorator> {
        DComparator() {
        }

        @Override
        public int compare(XModelObjectDecorator o1, XModelObjectDecorator o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    class ML
    implements ModifyListener {
        ML() {
        }

        public void modifyText(ModifyEvent e) {
            if (DecoratorTextPreferencesPage.this.selection != null) {
                DecoratorTextPreferencesPage.this.currentValues.put(DecoratorTextPreferencesPage.this.selection, DecoratorTextPreferencesPage.this.formatField.getText());
                DecoratorTextPreferencesPage.this.examples.refresh(true);
            }
        }
    }
}

