/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultIndentLineAutoEditStrategy;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.wst.xml.ui.StructuredTextViewerConfigurationXML;
import org.jboss.tools.common.model.ui.ModelUIPlugin;

public class TemplatesConfiguration
extends StructuredTextViewerConfigurationXML {
    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        DefaultIndentLineAutoEditStrategy s = new DefaultIndentLineAutoEditStrategy(){

            private void _autoIndentAfterNewLine(IDocument d, DocumentCommand c) {
                if (c.offset == -1 || d.getLength() == 0) {
                    return;
                }
                try {
                    int p = c.offset == d.getLength() ? c.offset - 1 : c.offset;
                    IRegion info = d.getLineInformationOfOffset(p);
                    int start = info.getOffset();
                    int end = this.findEndOfWhiteSpace(d, start, c.offset);
                    StringBuffer buf = new StringBuffer(c.text);
                    if (end > start) {
                        buf.append(d.get(start, end - start));
                    }
                    c.text = buf.toString();
                }
                catch (BadLocationException excp) {
                    ModelUIPlugin.getPluginLog().logError((Throwable)excp);
                }
            }

            public void customizeDocumentCommand(IDocument d, DocumentCommand c) {
                if (c instanceof DocumentCommand) {
                    DocumentCommand structuredDocumentCommand = c;
                    if (structuredDocumentCommand.length == 0 && structuredDocumentCommand.text != null && TextUtilities.endsWith((String[])d.getLegalLineDelimiters(), (String)structuredDocumentCommand.text) != -1) {
                        this._autoIndentAfterNewLine(d, structuredDocumentCommand);
                        return;
                    }
                }
                super.customizeDocumentCommand(d, c);
            }
        };
        IAutoEditStrategy[] ss = new IAutoEditStrategy[]{s};
        return ss;
    }
}

