/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.templates.preferences;

import java.util.Collection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.ui.attribute.adapter.ColumnDescription;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultTableStructuredAdapter;
import org.jboss.tools.common.model.ui.attribute.adapter.DefaultValueAdapter;
import org.jboss.tools.common.model.ui.attribute.editor.CheckBoxEditor;
import org.jboss.tools.common.model.ui.attribute.editor.IFieldEditor;
import org.jboss.tools.common.model.ui.attribute.editor.PropertyEditor;
import org.jboss.tools.common.model.ui.attribute.editor.TableStructuredEditor;
import org.jboss.tools.common.model.ui.templates.configuration.MetaClassTemplateHelper;
import org.jboss.tools.common.model.ui.templates.configuration.MetaConfiguration;
import org.jboss.tools.common.model.ui.templates.model.MetaClassTemplate;
import org.jboss.tools.common.model.ui.templates.model.MetaGroup;
import org.jboss.tools.common.model.ui.templates.preferences.ClassTemplateComponent;
import org.jboss.tools.common.model.ui.templates.preferences.Messages;
import org.jboss.tools.common.model.ui.templates.preferences.TableLabelProvider;

public class TemplateComponent {
    private MetaConfiguration configuration;
    boolean isGlobal = true;
    CheckBoxEditor allowOverrideEditor;
    CheckBoxEditor qwe;
    DefaultValueAdapter allowOverrideAdapter;
    TableStructuredEditor templateGroupsEditor;
    DefaultTableStructuredAdapter templateGroupsAdapter;
    TableStructuredEditor axisEditor;
    DefaultTableStructuredAdapter axisAdapter;
    ClassTemplateComponent templateComponent = new ClassTemplateComponent();

    public void setGlobal(boolean b) {
        this.isGlobal = b;
    }

    private Control[] getControls(Composite composite, PropertyEditor editor) {
        return ((IFieldEditor)((Object)editor.getFieldEditor(composite))).getControls(composite);
    }

    protected Control createContents(Composite parent) {
        GridData gd;
        Control[] control;
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(3, Boolean.FALSE.booleanValue());
        composite.setLayout((Layout)gridLayout);
        if (!this.isGlobal) {
            this.allowOverrideEditor.setLabelText(Messages.CHECKBOX_LABEL);
            this.allowOverrideAdapter.setValue("" + MetaClassTemplateHelper.instance.isProjectOverrideTemplates());
            control = this.getControls(composite, this.allowOverrideEditor);
            control[0].dispose();
            gd = new GridData(768);
            gd.horizontalSpan = 3;
            control[1].setLayoutData((Object)gd);
        }
        this.templateGroupsEditor.setLabelText(Messages.ClassTemplateComponent_LIST_OF_TEMPLATE_GROUPS);
        control = this.getControls(composite, this.templateGroupsEditor);
        control[0].dispose();
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 100;
        control[1].setLayoutData((Object)gd);
        this.axisEditor.setLabelText("Axis.");
        control = this.getControls(composite, this.axisEditor);
        control[0].dispose();
        gd = new GridData(1040);
        gd.widthHint = 150;
        gd.verticalSpan = 3;
        control[1].setLayoutData((Object)gd);
        this.templateComponent.createContents(composite);
        return composite;
    }

    public void setConfiguration(MetaConfiguration configuration, XModel model) {
        this.configuration = configuration;
        if (!this.isGlobal) {
            this.allowOverrideEditor = new CheckBoxEditor();
            this.allowOverrideAdapter = new DefaultValueAdapter();
            this.allowOverrideEditor.setInput(this.allowOverrideAdapter);
        }
        this.templateGroupsEditor = new TableStructuredEditor();
        this.templateGroupsAdapter = new DefaultTableStructuredAdapter();
        this.templateGroupsAdapter.addColumnDescription(new ColumnDescription("Groups", null, 100, 16384, true, null));
        Collection col = configuration.getMetaTemplateGroups();
        this.templateGroupsAdapter.setValue(col.toArray());
        this.templateGroupsAdapter.setTableLabelProvider(new TableLabelProvider());
        this.templateGroupsAdapter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
                    Object object = structuredSelection.getFirstElement();
                    TemplateComponent.this.setSelection(object);
                }
            }
        });
        this.templateGroupsEditor.setInput(this.templateGroupsAdapter);
        this.axisEditor = new TableStructuredEditor();
        this.axisAdapter = new DefaultTableStructuredAdapter();
        this.axisAdapter.addColumnDescription(new ColumnDescription("Axis", null, 100, 16384, true, null));
        this.axisAdapter.setTableLabelProvider(new TableLabelProvider());
        this.axisAdapter.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (event.getSelection() instanceof StructuredSelection) {
                    StructuredSelection structuredSelection = (StructuredSelection)event.getSelection();
                    Object object = structuredSelection.getFirstElement();
                    TemplateComponent.this.setSelection(object);
                }
            }
        });
        this.axisEditor.setInput(this.axisAdapter);
        this.templateComponent.setModel(model);
    }

    private void setSelection(Object o) {
        if (o == null) {
            this.templateComponent.setSelectedTemplate(null);
        } else if (o instanceof MetaGroup) {
            this.axisAdapter.setValue(((MetaGroup)o).getTemplates().toArray());
        } else if (o instanceof MetaClassTemplate) {
            this.templateComponent.setSelectedTemplate((MetaClassTemplate)o);
        }
    }

    protected void performApply() {
        if (!this.isGlobal) {
            String s = this.allowOverrideAdapter.getValue().toString();
            MetaClassTemplateHelper.instance.setProjectOverrideTemplates("true".equalsIgnoreCase(s));
        }
        this.configuration.save();
    }

    protected void performDefaults() {
        this.configuration.loadFromParent(2);
        if (this.templateComponent != null) {
            this.templateComponent.setSelectedTemplate(this.templateComponent.selectedTemplate);
        }
    }
}

