/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.widgets;

import java.util.ArrayList;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.jboss.tools.common.model.ui.widgets.Context;
import org.jboss.tools.common.model.ui.widgets.Line;
import org.jboss.tools.common.model.ui.widgets.TextAndReferenceComponent;
import org.jboss.tools.common.model.ui.widgets.Token;

class Tokenizer {
    Tokenizer() {
    }

    public static Token[] tokenize(String text, Font plain, Font bold) {
        Context context = new Context();
        context.bold = bold;
        context.plain = plain;
        context.text = text;
        while (context.nextChar()) {
            if (context.isBreakLine() || context.isWordEnd() || context.isReferenceStart() || context.isReferenceEnd() || context.isBoldStart() || context.isBoldEnd()) continue;
            context.appendToWord();
        }
        context.getLastToken();
        return context.l.toArray(new Token[0]);
    }

    public static Line[] breakIntoLines(GC g, Token[] tokens, int width) {
        ArrayList<Line> l = new ArrayList<Line>();
        Line line = null;
        int x = 0;
        int i = 0;
        while (i < tokens.length) {
            if (line == null) {
                line = new Line();
                line.firstToken = i;
                line.lastToken = i;
                x = 0;
            }
            if (tokens[i].isBreak) {
                l.add(line);
                line = null;
            } else {
                int dx = TextAndReferenceComponent.getStringWidth(g, tokens[i].font, tokens[i].text);
                if (x > 0 && x + 5 + dx > width) {
                    l.add(line);
                    line = null;
                    --i;
                } else {
                    line.lastToken = i;
                    x = x == 0 ? dx : x + 5 + dx;
                }
            }
            ++i;
        }
        if (line != null) {
            l.add(line);
        }
        return l.toArray(new Line[0]);
    }
}

