/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.ui.wizards.special;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jboss.tools.common.meta.action.impl.SpecialWizardSupport;
import org.jboss.tools.common.meta.impl.XModelEntityImpl;
import org.jboss.tools.common.model.ui.ModelUIImages;
import org.jboss.tools.common.model.ui.action.CommandBar;
import org.jboss.tools.common.model.ui.action.CommandBarLayout;
import org.jboss.tools.common.model.ui.action.CommandBarListener;
import org.jboss.tools.common.model.ui.wizards.special.DefaultSpecialWizard;
import org.jboss.tools.common.model.ui.wizards.special.ISpecialWizardStep;

public class DefaultSpecialWizardDialog
extends TitleAreaDialog
implements CommandBarListener {
    public static boolean hideHelp = XModelEntityImpl.hideHelp;
    private DefaultSpecialWizard wizard;
    private String[] commands = new String[0];
    private CommandBar commandBar = null;
    private int pageWidth = 490;
    private int pageHeight = 225;
    private Point minimumSize = null;
    private Point maximumSize = null;
    protected Control stepPage;
    protected Control pageArea;
    protected Composite dialogArea;

    public DefaultSpecialWizardDialog(Shell shell) {
        super(shell);
    }

    protected Control createPage(Composite parent) {
        if (this.stepPage != null) {
            this.stepPage.dispose();
            this.stepPage = null;
        }
        ISpecialWizardStep wizardStep = this.wizard.getWizardStep();
        this.setTitleImage(ModelUIImages.getImage(ModelUIImages.WIZARD_DEFAULT));
        return wizardStep.createControl(parent);
    }

    public void updateDialogArea() {
        this.stepPage = this.createPage((Composite)this.pageArea);
        Point size = this.stepPage.computeSize(-1, -1);
        size.x = Math.max(size.x, this.pageWidth);
        size.y = Math.max(size.y, this.pageHeight);
        GridData gd = (GridData)this.stepPage.getLayoutData();
        if (gd == null) {
            gd = new GridData(1808);
        }
        gd.heightHint = size.y;
        this.stepPage.setLayoutData((Object)gd);
        ((Composite)this.pageArea).layout(true);
        this.updateSizeForPage();
    }

    protected Control createPageArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        this.dialogArea.setLayout((Layout)gridLayout);
        Label dialogAreaSeparator = new Label(this.dialogArea, 258);
        dialogAreaSeparator.setLayoutData((Object)new GridData(768));
        this.pageArea = this.createPageArea(this.dialogArea);
        GridData gd = new GridData(1808);
        gd.widthHint = this.pageWidth;
        gd.heightHint = this.pageHeight;
        this.pageArea.setLayoutData((Object)gd);
        gd = new GridData(1808);
        gd.grabExcessVerticalSpace = true;
        this.dialogArea.setLayoutData((Object)gd);
        return this.dialogArea;
    }

    protected Control createButtonBar(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        GridData gd = new GridData(768);
        composite.setLayoutData((Object)gd);
        Label titleBarSeparator = new Label(composite, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.commandBar = new CommandBar();
        CommandBarLayout cbl = new CommandBarLayout();
        cbl.buttonHeight = this.convertHorizontalDLUsToPixels(20);
        cbl.buttonWidth = this.convertHorizontalDLUsToPixels(61);
        cbl.gap = this.convertHorizontalDLUsToPixels(4);
        cbl.left = 10;
        cbl.right = 10;
        cbl.top = 11;
        cbl.bottom = 10;
        this.commandBar.setLayout(cbl);
        Control control = this.commandBar.createControl(composite);
        this.commandBar.addCommandBarListener(this);
        this.commandBar.getLayout().alignment = 131072;
        gd = new GridData(1808);
        gd.heightHint = this.commandBar.getControl().computeSize((int)-1, (int)-1).y;
        control.setLayoutData((Object)gd);
        return composite;
    }

    public void updateButtonsBar(String[] newCommands) {
        if (!this.equal(this.commands, newCommands = this.revalidateHelpInCommands(newCommands))) {
            this.commands = newCommands;
            this.commandBar.setCommands(newCommands);
            this.commandBar.update();
            ((Composite)this.commandBar.getControl()).layout();
        }
    }

    private String[] revalidateHelpInCommands(String[] newCommands) {
        if (!hideHelp || newCommands.length == 0 || !newCommands[newCommands.length - 1].equals(SpecialWizardSupport.HELP)) {
            return newCommands;
        }
        String[] s = new String[newCommands.length - 1];
        System.arraycopy(newCommands, 0, s, 0, s.length);
        return s;
    }

    private void setShellSize(int width, int height) {
        Rectangle displayArea = this.getShell().getDisplay().getClientArea();
        width = this.getMinimumSize() != null && this.getMinimumSize().x > displayArea.width ? this.getMinimumSize().x : Math.min(width, displayArea.width * 3 / 4);
        height = this.getMinimumSize() != null && this.getMinimumSize().y > displayArea.width ? this.getMinimumSize().y : Math.min(height, displayArea.height * 3 / 4);
        if (this.getMinimumSize() != null && this.getMinimumSize().x != -1 && this.getMinimumSize().x > width) {
            width = this.getMinimumSize().x;
        }
        if (this.getMinimumSize() != null && this.getMinimumSize().y != -1 && this.getMinimumSize().y > height) {
            height = this.getMinimumSize().y;
        }
        if (this.getMaximumSize() != null && this.getMaximumSize().x != -1 && this.getMaximumSize().x < width) {
            width = this.getMaximumSize().x;
        }
        if (this.getMaximumSize() != null && this.getMaximumSize().y != -1 && this.getMaximumSize().y < height) {
            height = this.getMaximumSize().y;
        }
        this.getShell().setSize(width, height);
        this.constrainShellSize();
    }

    private Point calculatePageSizeDelta() {
        Control pageControl = this.stepPage;
        if (pageControl == null) {
            return new Point(0, 0);
        }
        Point contentSize = pageControl.computeSize(-1, -1, true);
        contentSize.x = Math.max(contentSize.x, this.pageWidth);
        contentSize.y = Math.max(contentSize.y, this.pageHeight);
        Rectangle rect = ((Composite)this.pageArea).getClientArea();
        Point containerSize = new Point(rect.width, rect.height);
        return new Point(Math.max(0, contentSize.x - containerSize.x), Math.max(0, contentSize.y - containerSize.y));
    }

    private void updateSizeForPage() {
        Point delta = this.calculatePageSizeDelta();
        if (delta.x > 0 || delta.y > 0) {
            Shell shell = this.getShell();
            Point shellSize = shell.getSize();
            this.setShellSize(shellSize.x + delta.x, shellSize.y + delta.y);
        }
    }

    private boolean equal(String[] s1, String[] s2) {
        if (s1 == null || s2 == null || s1.length != s2.length) {
            return false;
        }
        int i = 0;
        while (i < s1.length) {
            if (!s1[i].equals(s2[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean close() {
        if (this.wizard != null) {
            this.wizard.stopValidator();
        }
        boolean b = super.close();
        this.wizard = null;
        if (this.commandBar != null) {
            this.commandBar.dispose();
        }
        this.commandBar = null;
        return b;
    }

    public void action(String command) {
        this.wizard.action(command);
    }

    public Control getButtonBar() {
        return this.buttonBar;
    }

    public DefaultSpecialWizard getWizard() {
        return this.wizard;
    }

    public void setWizard(DefaultSpecialWizard wizard) {
        this.wizard = wizard;
    }

    public Point getMinimumSize() {
        return this.minimumSize;
    }

    public void setMinimumSize(Point point) {
        this.minimumSize = point;
    }

    public Point getMaximumSize() {
        return this.maximumSize;
    }

    public void setMaximumSize(Point point) {
        this.maximumSize = point;
    }

    public CommandBar getCommandBar() {
        return this.commandBar;
    }
}

