/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import org.eclipse.osgi.util.NLS;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ClassNode;
import org.hibernate.console.node.NodeFactory;
import org.hibernate.console.node.TypedNode;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.Type;

class TypeNode
extends ClassNode
implements TypedNode {
    Type type;

    public TypeNode(NodeFactory factory, BaseNode parent, Type type, ClassMetadata metadata, Object baseObject, boolean objectGraph) {
        super(factory, parent, type.getReturnedClass().getName(), metadata, baseObject, objectGraph);
        this.type = type;
        this.iconName = factory.getIconNameForType(type);
    }

    @Override
    public String getCriteria() {
        String enName = "";
        String propCriteria = "";
        if (this.getName() != null && this.getParent() instanceof BaseNode) {
            BaseNode baseNodeParent = (BaseNode)this.getParent();
            if (baseNodeParent instanceof TypedNode) {
                TypedNode typedNodeParent = (TypedNode)((Object)baseNodeParent);
                enName = typedNodeParent.getType().getName();
            } else {
                enName = baseNodeParent.getName();
            }
            enName = enName.substring(enName.lastIndexOf(46) + 1);
            propCriteria = NLS.bind((String)"\n.createCriteria(\"{0}\", \"{1}\")", (Object)this.getName(), (Object)Character.valueOf(this.getName().charAt(0)));
        }
        if ("".equals(enName)) {
            return "";
        }
        String enCriteria = NLS.bind((String)".createCriteria({0})", (Object)(String.valueOf(enName) + ".class"));
        return "session" + enCriteria + propCriteria;
    }

    @Override
    public String renderLabel(boolean b) {
        return String.valueOf(super.renderLabel(b)) + " : " + TypeNode.getLabel(this.type.getReturnedClass().getName(), b);
    }

    @Override
    public Type getType() {
        return this.type;
    }

    public void setName(String string) {
        this.name = string;
    }
}

