/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util.xpl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.util.xpl.StringHelper;

public final class ReflectHelper {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR;
    public static final Class[] NO_PARAM_SIGNATURE;
    public static final Object[] NO_PARAMS;
    public static final Class[] SINGLE_OBJECT_PARAM_SIGNATURE;
    private static final Method OBJECT_EQUALS;
    private static final Method OBJECT_HASHCODE;

    static {
        Method hash;
        Method eq;
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
        NO_PARAM_SIGNATURE = new Class[0];
        NO_PARAMS = new Object[0];
        SINGLE_OBJECT_PARAM_SIGNATURE = new Class[]{Object.class};
        try {
            eq = ReflectHelper.extractEqualsMethod(Object.class);
            hash = ReflectHelper.extractHashCodeMethod(Object.class);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", (Throwable)e);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
    }

    private ReflectHelper() {
    }

    public static Method extractEqualsMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("equals", SINGLE_OBJECT_PARAM_SIGNATURE);
    }

    public static Method extractHashCodeMethod(Class clazz) throws NoSuchMethodException {
        return clazz.getMethod("hashCode", NO_PARAM_SIGNATURE);
    }

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = ReflectHelper.extractEqualsMethod(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method hashCode;
        try {
            hashCode = ReflectHelper.extractHashCodeMethod(clazz);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static boolean implementsInterface(Class clazz, Class intf) {
        assert (intf.isInterface()) : "Interface to check was not an interface";
        return intf.isAssignableFrom(clazz);
    }

    public static Class classForName(String name, Class caller) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {}
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {}
        return Class.forName(name);
    }

    public static boolean isPublic(Member member) {
        return ReflectHelper.isPublic(member.getDeclaringClass(), member);
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Class reflectedPropertyClass(String className, String name) throws MappingException {
        try {
            Class clazz = ReflectHelper.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnType();
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, (Throwable)cnfe);
        }
    }

    private static Getter getter(Class clazz, String name) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
        catch (PropertyNotFoundException propertyNotFoundException) {
            return DIRECT_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
    }

    public static Getter getGetter(Class theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name);
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (Throwable throwable) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_PARAM_SIGNATURE);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new PropertyNotFoundException("Object class [" + clazz.getName() + "] must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Constructor getConstructor(Class clazz, Type[] types) throws PropertyNotFoundException {
        Constructor<?>[] candidates = clazz.getConstructors();
        int i = 0;
        while (i < candidates.length) {
            Constructor<?> constructor = candidates[i];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length == types.length) {
                boolean found = true;
                int j = 0;
                while (j < params.length) {
                    boolean ok;
                    boolean bl = ok = params[j].isAssignableFrom(types[j].getReturnedClass()) || types[j] instanceof PrimitiveType && params[j] == ((PrimitiveType)types[j]).getPrimitiveClass();
                    if (!ok) {
                        found = false;
                        break;
                    }
                    ++j;
                }
                if (found) {
                    if (!ReflectHelper.isPublic(clazz, constructor)) {
                        constructor.setAccessible(true);
                    }
                    return constructor;
                }
            }
            ++i;
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception exception) {
            return null;
        }
    }
}

