/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import java.util.EnumSet;
import org.eclipse.swt.graphics.Rectangle;
import org.jboss.tools.vpe.dnd.DndUtil;
import org.jboss.tools.vpe.dnd.DropTarget;
import org.jboss.tools.vpe.editor.util.VpeStyleUtil;
import org.jboss.tools.vpe.xulrunner.util.XulRunnerVpeUtils;
import org.mozilla.interfaces.nsIDOMCSSStyleDeclaration;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMNode;

public class DropableArea {
    private boolean visible;
    private EnumSet<DropTarget> dropTargets;
    private nsIDOMDocument document;
    private nsIDOMNode node;
    private nsIDOMElement domArea;
    private static final String AREA_COLOR = "rgba(166, 202, 240, 0.5)";
    private DropTarget highlightedDropTarget;

    public DropableArea(nsIDOMDocument document) {
        this.document = document;
    }

    public void setNode(nsIDOMNode node) {
        this.node = node;
    }

    public nsIDOMNode getNode() {
        return this.node;
    }

    public void setDropTargets(EnumSet<DropTarget> dropTargets) {
        this.dropTargets = dropTargets;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public void setHighlightedDropTarget(int mouseX, int mouseY) {
        if (this.node == null) {
            this.highlightedDropTarget = null;
        }
        Rectangle bounds = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)this.node);
        this.highlightedDropTarget = this.dropTargets.contains((Object)DropTarget.BEFORE) && bounds.x <= mouseX && mouseX < bounds.x + bounds.width / 5 ? DropTarget.BEFORE : (this.dropTargets.contains((Object)DropTarget.AFTER) && bounds.x + bounds.width * 4 / 5 <= mouseX && mouseX < bounds.x + bounds.width ? DropTarget.AFTER : (this.dropTargets.contains((Object)DropTarget.BEGIN) && bounds.y <= mouseY && mouseY < bounds.y + bounds.height / 5 ? DropTarget.BEGIN : (this.dropTargets.contains((Object)DropTarget.END) && bounds.y + bounds.height * 4 / 5 <= mouseY && mouseY < bounds.y + bounds.height ? DropTarget.END : (this.dropTargets.contains((Object)DropTarget.END) ? DropTarget.END : (this.dropTargets.contains((Object)DropTarget.AFTER) ? DropTarget.AFTER : (this.dropTargets.contains((Object)DropTarget.BEFORE) ? DropTarget.BEFORE : (this.dropTargets.contains((Object)DropTarget.BEGIN) ? DropTarget.BEGIN : null)))))));
    }

    public DropTarget getHighlightedDropTarget() {
        return this.highlightedDropTarget;
    }

    public void redraw() {
        nsIDOMCSSStyleDeclaration style;
        nsIDOMElement line;
        if (!this.visible || this.node == null) {
            if (this.domArea != null) {
                this.domArea.getParentNode().removeChild((nsIDOMNode)this.domArea);
                this.domArea = null;
            }
            return;
        }
        Rectangle bounds = XulRunnerVpeUtils.getElementBounds((nsIDOMNode)this.node);
        nsIDOMElement oldDomArea = this.domArea;
        this.domArea = this.createRect(bounds, AREA_COLOR);
        nsIDOMElement contentArea = this.document.getElementById("__content__area__");
        contentArea.appendChild((nsIDOMNode)this.domArea);
        if (this.dropTargets.contains((Object)DropTarget.BEFORE)) {
            line = this.createVerticalLine(bounds.height, this.getColor(DropTarget.BEFORE));
            style = VpeStyleUtil.getStyle(line);
            style.setProperty("left", VpeStyleUtil.toPxPosition(-6), "");
            this.domArea.appendChild((nsIDOMNode)line);
        }
        if (this.dropTargets.contains((Object)DropTarget.AFTER)) {
            line = this.createVerticalLine(bounds.height, this.getColor(DropTarget.AFTER));
            style = VpeStyleUtil.getStyle(line);
            style.setProperty("right", VpeStyleUtil.toPxPosition(-6), "");
            this.domArea.appendChild((nsIDOMNode)line);
        }
        if (this.dropTargets.contains((Object)DropTarget.BEGIN)) {
            line = this.createHorizontalLine(bounds.width - 4, this.getColor(DropTarget.BEGIN));
            style = VpeStyleUtil.getStyle(line);
            style.setProperty("left", VpeStyleUtil.toPxPosition(2), "");
            style.setProperty("top", VpeStyleUtil.toPxPosition(1), "");
            this.domArea.appendChild((nsIDOMNode)line);
        }
        if (this.dropTargets.contains((Object)DropTarget.END)) {
            line = this.createHorizontalLine(bounds.width - 4, this.getColor(DropTarget.END));
            style = VpeStyleUtil.getStyle(line);
            style.setProperty("left", VpeStyleUtil.toPxPosition(2), "");
            style.setProperty("bottom", VpeStyleUtil.toPxPosition(1), "");
            this.domArea.appendChild((nsIDOMNode)line);
        }
        if (oldDomArea != null) {
            contentArea.removeChild((nsIDOMNode)oldDomArea);
        }
    }

    public void dispose() {
        this.setVisible(false);
        this.redraw();
        this.document = null;
        this.node = null;
        this.domArea = null;
    }

    private String getColor(DropTarget dropTarget) {
        if (dropTarget == this.highlightedDropTarget) {
            return "red";
        }
        return "black";
    }

    private nsIDOMElement createRect(Rectangle coords, String color) {
        nsIDOMElement rect = this.createElement("div");
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle(rect);
        style.setProperty("position", "absolute", "");
        style.setProperty("left", VpeStyleUtil.toPxPosition(coords.x), "");
        style.setProperty("top", VpeStyleUtil.toPxPosition(coords.y), "");
        style.setProperty("height", VpeStyleUtil.toPxPosition(coords.height), "");
        style.setProperty("width", VpeStyleUtil.toPxPosition(coords.width), "");
        style.setProperty("background-color", color, "");
        return rect;
    }

    private void drawRect(nsIDOMElement container, Rectangle coords, String color) {
        container.appendChild((nsIDOMNode)this.createRect(coords, color));
    }

    private nsIDOMElement createHorizontalLine(int width, String color) {
        nsIDOMElement line = this.createElement("div");
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle(line);
        style.setProperty("position", "absolute", "");
        style.setProperty("width", VpeStyleUtil.toPxPosition(width), "");
        style.setProperty("height", VpeStyleUtil.toPxPosition(6), "");
        int i = 0;
        while (i < 2) {
            this.drawRect(line, new Rectangle(i, i, 1, 6 - 2 * i), color);
            ++i;
        }
        this.drawRect(line, new Rectangle(2, 2, width - 4, 2), color);
        i = 0;
        while (i < 2) {
            this.drawRect(line, new Rectangle(width - 1 - i, i, 1, 6 - 2 * i), color);
            ++i;
        }
        return line;
    }

    private nsIDOMElement createVerticalLine(int height, String color) {
        nsIDOMElement line = this.createElement("div");
        nsIDOMCSSStyleDeclaration style = VpeStyleUtil.getStyle(line);
        style.setProperty("position", "absolute", "");
        style.setProperty("width", VpeStyleUtil.toPxPosition(6), "");
        style.setProperty("height", VpeStyleUtil.toPxPosition(height), "");
        int i = 0;
        while (i < 2) {
            this.drawRect(line, new Rectangle(i, i, 6 - 2 * i, 1), color);
            ++i;
        }
        this.drawRect(line, new Rectangle(2, 2, 2, height - 4), color);
        i = 0;
        while (i < 2) {
            this.drawRect(line, new Rectangle(i, height - 1 - i, 6 - 2 * i, 1), color);
            ++i;
        }
        return line;
    }

    private nsIDOMElement createElement(String tagName) {
        nsIDOMElement element = this.document.createElement(tagName);
        DndUtil.setTemporaryDndElement(element, true);
        return element;
    }
}

