/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.dnd;

import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.document.ElementImpl;
import org.eclipse.wst.xml.core.internal.document.NodeContainer;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.PreferenceModelUtilities;
import org.jboss.tools.common.model.ui.editors.dnd.DropUtils;
import org.jboss.tools.common.model.ui.editors.dnd.context.IDNDTextEditor;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.jst.web.tld.model.TLDUtil;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.dnd.DndUtil;
import org.jboss.tools.vpe.dnd.DraggableElement;
import org.jboss.tools.vpe.dnd.DraggablePattern;
import org.jboss.tools.vpe.dnd.DraggableTextSelection;
import org.jboss.tools.vpe.dnd.DropTarget;
import org.jboss.tools.vpe.dnd.DropableArea;
import org.jboss.tools.vpe.dnd.ScrollingSupport;
import org.jboss.tools.vpe.dnd.VpeDnDHelper;
import org.jboss.tools.vpe.editor.VpeController;
import org.jboss.tools.vpe.editor.VpeSourceDropInfo;
import org.jboss.tools.vpe.editor.VpeSourceInnerDragInfo;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaDndListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaSelectionListener;
import org.jboss.tools.vpe.editor.util.SourceDomUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeDndUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.xulrunner.editor.IVpeSelectionListener;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerHint;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIComponentManager;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMRange;
import org.mozilla.interfaces.nsIDOMText;
import org.mozilla.interfaces.nsIDragService;
import org.mozilla.interfaces.nsIFile;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsIServiceManager;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsISupportsArray;
import org.mozilla.interfaces.nsISupportsCString;
import org.mozilla.interfaces.nsISupportsString;
import org.mozilla.interfaces.nsITransferable;
import org.mozilla.xpcom.Mozilla;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VpeDnD
implements MozillaDndListener,
MozillaSelectionListener,
IVpeSelectionListener {
    private static final String TAG_TAGLIB = "taglib";
    private nsIServiceManager serviceManager;
    private nsIComponentManager componentManager;
    private nsIDragService dragService;
    private VpeController vpeController;
    private DraggablePattern draggablePattern;
    private DropableArea dropableArea;
    private XulRunnerHint dropHint;
    private static final Point DROP_HINT_OFFSET = new Point(20, -10);
    private static final String[] FLAVORS = new String[]{"vpe/model", "text/unicode", "text/html", "AOLMAIL", "image/png", "image/jpg", "image/gif", "application/x-moz-file", "text/x-moz-url", "text/x-moz-url-data", "text/x-moz-url-desc", "application/x-moz-nativeimage", "application/x-moz-nativehtml", "application/x-moz-file-promise-url", "application/x-moz-file-promise", "application/x-moz-file-promise-dir", "text/plain"};

    public VpeDnD(VpeController vpeController, MozillaEditor mozillaEditor) {
        this.vpeController = vpeController;
        this.draggablePattern = new DraggablePattern(mozillaEditor);
    }

    @Override
    public void dragStart(nsIDOMEvent domEvent) {
        nsIDOMElement selectedElement = this.getSelectedElement();
        if (this.isTextSelected(this.getVisualSelection()) || this.isDraggable(selectedElement)) {
            Point pageCoords = this.getPageCoords(domEvent);
            this.draggablePattern.startSession(pageCoords.x, pageCoords.y);
            this.startDragSession(selectedElement);
            domEvent.stopPropagation();
            domEvent.preventDefault();
        }
    }

    private nsIDOMElement getSelectedElement() {
        if (this.vpeController.getXulRunnerEditor().getSelectedNodes().size() != 1) {
            return null;
        }
        return this.vpeController.getXulRunnerEditor().getSelectedElement();
    }

    @Override
    public void dragOver(nsIDOMEvent event) {
        DropResolver dropResolver;
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)event, nsIDOMMouseEvent.class);
        XulRunnerEditor editor = this.vpeController.getXulRunnerEditor();
        new ScrollingSupport(editor).scroll(mouseEvent);
        if (this.isInnerDragSession()) {
            dropResolver = this.isTextSelected(this.getVisualSelection()) ? this.getDropResolverForNode(this.getSourceNode(this.getVisualSelection().getFocusNode())) : this.getDropResolverForInternalDrop();
            Point mousePosition = this.getPageCoords(event);
            this.draggablePattern.moveTo(mousePosition.x, mousePosition.y);
        } else {
            dropResolver = this.getDropResolverForExternalDrop();
        }
        this.highlightDropTargets(dropResolver, mouseEvent);
        this.refreshCanDrop(event);
        this.vpeController.onRefresh();
    }

    @Override
    public void dragDrop(nsIDOMEvent domEvent) {
        if (this.isInnerDragSession()) {
            this.draggablePattern.closeSession();
            this.innerDrop((nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class));
        } else {
            this.externalDrop((nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMMouseEvent.class));
        }
        this.disposeDropableArea();
        this.disposeDropHint();
        this.vpeController.onRefresh();
    }

    @Override
    public void dragExit(nsIDOMEvent domEvent) {
        nsIDOMNode eventTargetNode = (nsIDOMNode)XPCOM.queryInterface((nsISupports)domEvent.getTarget(), nsIDOMNode.class);
        if (this.dropableArea != null) {
            nsIDOMNode dropTargetNode = this.dropableArea.getNode();
            boolean targetNodeIsTemporary = false;
            if (eventTargetNode.getNodeType() == 1) {
                nsIDOMElement eventTargetElement = (nsIDOMElement)XPCOM.queryInterface((nsISupports)eventTargetNode, nsIDOMElement.class);
                targetNodeIsTemporary = DndUtil.isTemporaryDndElement(eventTargetElement);
            }
            boolean eventTargetIsAscedantOfDropTarget = VisualDomUtil.isAscendant(eventTargetNode, dropTargetNode);
            if (targetNodeIsTemporary || eventTargetIsAscedantOfDropTarget) {
                this.disposeDropableArea();
                this.disposeDropHint();
            }
        }
    }

    @Override
    public void dragEnd(nsIDOMEvent domEvent) {
        this.disposeDropableArea();
        this.disposeDropHint();
        this.draggablePattern.closeSession();
    }

    public void selectionChanged() {
        this.refreshDraggablePattern();
    }

    private void refreshDraggablePattern() {
        nsISelection selection = this.getVisualSelection();
        if (this.isTextSelected(selection)) {
            nsIDOMRange range = selection.getRangeAt(0);
            nsIDOMText textContainer = (nsIDOMText)XPCOM.queryInterface((nsISupports)range.getStartContainer(), nsIDOMText.class);
            this.draggablePattern.showDragIcon(new DraggableTextSelection(textContainer, range.getStartOffset(), range.getEndOffset()));
        } else {
            nsIDOMElement selectedElement = this.getSelectedElement();
            if (this.isDraggable(selectedElement)) {
                this.draggablePattern.showDragIcon(new DraggableElement(selectedElement));
            } else {
                this.draggablePattern.hideDragIcon();
            }
        }
    }

    private nsISelection getVisualSelection() {
        return this.vpeController.getXulRunnerEditor().getWebBrowser().getContentDOMWindow().getSelection();
    }

    private boolean isTextSelected(nsISelection selection) {
        if (selection.getRangeCount() == 0) {
            return false;
        }
        nsIDOMRange range = selection.getRangeAt(0);
        nsIDOMNode container = range.getStartContainer();
        if (!container.equals(range.getEndContainer())) {
            return false;
        }
        if (container.getNodeType() != 3) {
            return false;
        }
        return range.getStartOffset() != range.getEndOffset();
    }

    public boolean isDragIconClicked(nsIDOMMouseEvent mouseEvent) {
        return this.draggablePattern.isDragIconClicked(mouseEvent);
    }

    private DropResolver getDropResolverForExternalDrop() {
        if (this.getDragService().getCurrentSession().isDataFlavorSupported("vpe/model")) {
            XModelObject object = PreferenceModelUtilities.getPreferenceModel().getModelBuffer().source();
            if (object.getFileType() == 1 && !TLDUtil.isTaglib((XModelObject)object)) {
                IFile f = (IFile)EclipseResourceUtil.getResource((XModelObject)object);
                return this.getSimpleDropResolver(f != null);
            }
            String tagname = this.vpeController.getTagName(object);
            if (tagname.indexOf(TAG_TAGLIB) >= 0) {
                tagname = TAG_TAGLIB;
            }
            Element dropContainer = ((Document)this.vpeController.getModel().getAdapter(Document.class)).createElement(tagname);
            return this.getDropResolverForNode(dropContainer);
        }
        return this.getSimpleDropResolver(true);
    }

    private DropResolver getDropResolverForInternalDrop() {
        Node node = DndUtil.getNodeFromDragSession(this.vpeController.getPageContext());
        if (node != null) {
            return this.getDropResolverForNode(node);
        }
        return this.getSimpleDropResolver(false);
    }

    private DropResolver getSimpleDropResolver(final boolean canDrop) {
        return new DropResolver(){

            @Override
            public boolean canDrop(Node node) {
                return canDrop;
            }
        };
    }

    private DropResolver getDropResolverForNode(final Node draggedNode) {
        return new DropResolver(){

            @Override
            public boolean canDrop(Node container) {
                VpeNodeMapping nodeMapping = VpeDnD.this.vpeController.getDomMapping().getNodeMapping(container);
                boolean canDrop = false;
                if (nodeMapping != null && nodeMapping instanceof VpeElementMapping) {
                    canDrop = ((VpeElementMapping)nodeMapping).getTemplate().canInnerDrop(VpeDnD.this.vpeController.getPageContext(), container, draggedNode);
                }
                return canDrop;
            }
        };
    }

    private void highlightDropTargets(DropResolver dropResolver, nsIDOMMouseEvent event) {
        EnumSet<DropTarget> dropTargets;
        Node highlightedNode;
        nsIDOMDocument document = this.vpeController.getXulRunnerEditor().getDOMDocument();
        Point clientCoords = this.getClientCoords((nsIDOMEvent)event);
        nsIDOMElement originalVisualNode = DndUtil.getElementFromPoint(document, clientCoords.x, clientCoords.y);
        if (originalVisualNode == null) {
            return;
        }
        Node originalSourceNode = this.getSourceNode((nsIDOMNode)originalVisualNode);
        if (originalSourceNode != null && originalSourceNode.getNodeType() == 3) {
            originalSourceNode = originalSourceNode.getParentNode();
        }
        if (dropResolver.canDrop(originalSourceNode)) {
            highlightedNode = originalSourceNode;
            Node originalSourceNodeParent = originalSourceNode.getParentNode();
            dropTargets = originalSourceNodeParent != null && dropResolver.canDrop(originalSourceNodeParent) ? EnumSet.of(DropTarget.BEFORE, DropTarget.AFTER, DropTarget.BEGIN, DropTarget.END) : EnumSet.of(DropTarget.BEGIN, DropTarget.END);
        } else {
            Node sourceNode = null;
            Node sourceNodeParent = originalSourceNode;
            boolean nodeFound = false;
            while (sourceNodeParent != null && !nodeFound) {
                sourceNode = sourceNodeParent;
                sourceNodeParent = sourceNode.getParentNode();
                nodeFound = dropResolver.canDrop(sourceNodeParent);
            }
            if (nodeFound) {
                highlightedNode = sourceNode;
                dropTargets = EnumSet.of(DropTarget.BEFORE, DropTarget.AFTER);
            } else {
                highlightedNode = null;
                dropTargets = EnumSet.noneOf(DropTarget.class);
            }
        }
        Point mouseCoords = this.getPageCoords((nsIDOMEvent)event);
        if (highlightedNode != null) {
            if (this.dropableArea == null) {
                this.dropableArea = new DropableArea(document);
            }
            this.dropableArea.setDropTargets(dropTargets);
            this.dropableArea.setNode(this.vpeController.getDomMapping().getNearVisualNode(highlightedNode));
            this.dropableArea.setHighlightedDropTarget(mouseCoords.x, mouseCoords.y);
            this.dropableArea.setVisible(true);
            this.dropableArea.redraw();
        } else {
            this.disposeDropableArea();
            this.disposeDropHint();
        }
        if (highlightedNode != null && this.dropableArea.getHighlightedDropTarget() != null) {
            if (this.dropHint == null) {
                this.dropHint = new XulRunnerHint(document);
            }
            String dropHintValue = null;
            switch (this.dropableArea.getHighlightedDropTarget()) {
                case BEFORE: {
                    dropHintValue = MessageFormat.format(VpeUIMessages.VpeDnD_PLACE_BEFORE_INSIDE, highlightedNode.getNodeName(), highlightedNode.getParentNode().getNodeName());
                    break;
                }
                case AFTER: {
                    dropHintValue = MessageFormat.format(VpeUIMessages.VpeDnD_PLACE_AFTER_INSIDE, highlightedNode.getNodeName(), highlightedNode.getParentNode().getNodeName());
                    break;
                }
                case BEGIN: {
                    dropHintValue = MessageFormat.format(VpeUIMessages.VpeDnD_PLACE_AT_THE_BEGINNING_OF, highlightedNode.getNodeName());
                    break;
                }
                case END: {
                    dropHintValue = MessageFormat.format(VpeUIMessages.VpeDnD_PLACE_AT_THE_END_OF, highlightedNode.getNodeName());
                }
            }
            this.dropHint.setHint(dropHintValue);
            this.dropHint.setPosition(new Point(mouseCoords.x + VpeDnD.DROP_HINT_OFFSET.x, mouseCoords.y + VpeDnD.DROP_HINT_OFFSET.y));
            this.dropHint.redraw();
        } else {
            this.disposeDropHint();
        }
    }

    private Point getClientCoords(nsIDOMEvent event) {
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)event, nsIDOMMouseEvent.class);
        return new Point(mouseEvent.getClientX(), mouseEvent.getClientY());
    }

    private void disposeDropableArea() {
        if (this.dropableArea != null) {
            this.dropableArea.dispose();
            this.dropableArea = null;
        }
    }

    private void disposeDropHint() {
        if (this.dropHint != null) {
            this.dropHint.dispose();
            this.dropHint = null;
        }
    }

    private void startDragSession(nsIDOMElement element) {
        nsISupportsArray transArray = (nsISupportsArray)this.getComponentManager().createInstanceByContractID("@mozilla.org/supports-array;1", null, "{791eafa0-b9e6-11d1-8031-006008159b5a}");
        transArray.appendElement((nsISupports)this.createTransferable(this.getSourceNode((nsIDOMNode)element)));
        this.getDragService().invokeDragSession((nsIDOMNode)element, transArray, null, 7L);
    }

    private nsITransferable createTransferable(Node node) {
        nsITransferable iTransferable = (nsITransferable)this.getComponentManager().createInstanceByContractID("@mozilla.org/widget/transferable;1", null, "{8b5314bc-db01-11d2-96ce-0060b0fb9956}");
        String nodeSource = ((NodeContainer)node).getSource();
        nsISupportsString nodeSourceData = this.createNsISupportsString(nodeSource);
        int nodeSourceDataLength = nodeSource.length() * 2;
        iTransferable.setTransferData("vpe/model", (nsISupports)nodeSourceData, (long)nodeSourceDataLength);
        iTransferable.setTransferData("text/html", (nsISupports)nodeSourceData, (long)nodeSourceDataLength);
        iTransferable.setTransferData("text/unicode", (nsISupports)nodeSourceData, (long)nodeSourceDataLength);
        String xPath = SourceDomUtil.getXPath(node);
        nsISupportsString xPathData = this.createNsISupportsString(xPath);
        iTransferable.setTransferData("vpe/xpath", (nsISupports)xPathData, (long)(xPath.length() * 2));
        return iTransferable;
    }

    private nsISupportsString createNsISupportsString(String data) {
        nsISupportsString xulString = (nsISupportsString)this.getComponentManager().createInstanceByContractID("@mozilla.org/supports-string;1", null, "{d79dc970-4a1c-11d3-9890-006008962422}");
        xulString.setData(data);
        return xulString;
    }

    private void refreshCanDrop(nsIDOMEvent event) {
        nsIDOMMouseEvent mouseEvent = (nsIDOMMouseEvent)XPCOM.queryInterface((nsISupports)event, nsIDOMMouseEvent.class);
        this.getDragService().getCurrentSession().setCanDrop(this.dropableArea != null && this.dropableArea.getHighlightedDropTarget() != null);
        mouseEvent.preventDefault();
        mouseEvent.stopPropagation();
    }

    private void dropAny(String flavor, String data) {
        VpeSourceDropInfo dropInfo = this.getDropInfo();
        Point range = this.getSourceSelectionRange(dropInfo.getContainer(), dropInfo.getOffset());
        if (dropInfo.getContainer() != null && data != null) {
            StructuredTextEditor sourceEditor = this.vpeController.getSourceEditor();
            if (flavor == null || flavor.length() == 0 || !(sourceEditor instanceof IDNDTextEditor)) {
                return;
            }
            sourceEditor.setHighlightRange(range.x, 0, true);
            ((IDNDTextEditor)sourceEditor).runDropCommand(flavor, data);
        }
    }

    private boolean isInnerDragSession() {
        return this.getDragService().getCurrentSession().getSourceDocument() != null;
    }

    private boolean isDraggable(nsIDOMElement element) {
        this.vpeController.onHideTooltip();
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.print("<<<<<< canInnerDrag");
        }
        boolean canDrag = false;
        if (element != null) {
            Node sourceNode;
            if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                System.out.print(" dragNode: " + element.getNodeName() + "(" + element + ")");
            }
            if ((sourceNode = this.getSourceNode((nsIDOMNode)element)) != null && this.canInnerDrag(sourceNode)) {
                canDrag = true;
            }
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println("  canDrag: " + canDrag);
        }
        return canDrag;
    }

    private boolean canInnerDrag(Node node) {
        VpeElementMapping elementMapping;
        VpeNodeMapping domMapping = this.vpeController.getDomMapping().getNodeMapping(node);
        if (domMapping instanceof VpeElementMapping && (elementMapping = (VpeElementMapping)domMapping).getSourceNode() instanceof Element) {
            return elementMapping.getTemplate().canInnerDrag(this.vpeController.getPageContext(), (Element)elementMapping.getSourceNode());
        }
        return false;
    }

    private Node getSourceNode(nsIDOMNode visualNode) {
        return this.vpeController.getDomMapping().getNearSourceNode(visualNode);
    }

    private void innerDrop(nsIDOMMouseEvent event) {
        this.vpeController.onHideTooltip();
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.print("<<<<<< innerDrop");
        }
        if (this.isTextSelected(this.getVisualSelection())) {
            StyledText textWidget = this.vpeController.getSourceEditor().getTextViewer().getTextWidget();
            String text = textWidget.getSelectionText();
            Point selectionRange = textWidget.getSelectionRange();
            textWidget.replaceTextRange(selectionRange.x, selectionRange.y, "");
            this.dropAny("text/unicode", text);
        } else {
            VpeSourceDropInfo sourceDropInfo;
            Node node = DndUtil.getNodeFromDragSession(this.vpeController.getPageContext());
            if (node != null && (sourceDropInfo = this.getDropInfo()).getContainer() != null) {
                if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
                    System.out.print("  container: " + sourceDropInfo.getContainer().getNodeName() + "(" + sourceDropInfo.getContainer() + ")" + "  offset: " + sourceDropInfo.getOffset());
                }
                if (sourceDropInfo.canDrop()) {
                    VpeDnDHelper dropper = new VpeDnDHelper();
                    dropper.setDndData(false, true);
                    dropper.drop(this.vpeController.getPageContext(), new VpeSourceInnerDragInfo(node, 0, 0), sourceDropInfo);
                    this.setSelectedNode(node);
                }
            }
        }
        if (VpeDebug.PRINT_VISUAL_INNER_DRAGDROP_EVENT) {
            System.out.println();
        }
    }

    private void setSelectedNode(Node node) {
        IndexedRegion sourceNodeBounds = (IndexedRegion)node;
        this.vpeController.getSourceEditor().getTextViewer().getTextWidget().setSelection(sourceNodeBounds.getStartOffset(), sourceNodeBounds.getEndOffset());
    }

    private void externalDrop(nsIDOMMouseEvent mouseEvent) {
        this.vpeController.onHideTooltip();
        DndUtil.DragTransferData dragTransferData = DndUtil.getDragTransferData(FLAVORS);
        nsISupports aValue = dragTransferData.getValue();
        String data = "";
        String aFlavor = "";
        if (VpeDndUtil.isNsIFileInstance(aValue)) {
            nsIFile aFile = (nsIFile)XPCOM.queryInterface((nsISupports)aValue, nsIFile.class);
            String path = aFile.getPath();
            data = path != null ? DropUtils.convertPathToUrl((String)path) : null;
            aFlavor = "application/x-moz-file";
        } else if (VpeDndUtil.isNsICStringInstance(aValue)) {
            nsISupportsCString aString = (nsISupportsCString)XPCOM.queryInterface((nsISupports)aValue, nsISupportsCString.class);
            data = aString.getData();
            aFlavor = "text/html";
        } else if (VpeDndUtil.isNsIStringInstance(aValue)) {
            nsISupportsString aString = (nsISupportsString)XPCOM.queryInterface((nsISupports)aValue, nsISupportsString.class);
            data = aString.getData();
            aFlavor = "vpe/model".equals(dragTransferData.getFlavor()) ? dragTransferData.getFlavor() : "text/x-moz-url";
        }
        this.dropAny(aFlavor, data);
    }

    private Point getSourceSelectionRange(Node sourceInitNode, int sourceInitOffset) {
        int offset = 0;
        int position = 0;
        switch (sourceInitNode.getNodeType()) {
            case 3: {
                offset = Math.min(sourceInitOffset, sourceInitNode.getNodeValue().length());
                position = this.vpeController.getSourceBuilder().getPosition(sourceInitNode, offset, false);
                break;
            }
            case 1: 
            case 9: {
                ElementImpl element;
                NodeList children = sourceInitNode.getChildNodes();
                int count = children.getLength();
                if (sourceInitOffset < count) {
                    Node sourceNode = children.item(sourceInitOffset);
                    position = ((IndexedRegion)sourceNode).getStartOffset();
                    break;
                }
                if (count > 0) {
                    Node sourceNode = children.item(count - 1);
                    position = ((IndexedRegion)sourceNode).getEndOffset();
                    break;
                }
                position = ((IndexedRegion)sourceInitNode).getStartOffset();
                if (!(sourceInitNode instanceof ElementImpl) || !(element = (ElementImpl)sourceInitNode).isContainer()) break;
                position = element.getStartEndOffset();
            }
        }
        return new Point(position, 0);
    }

    private Point getPageCoords(nsIDOMEvent domEvent) {
        nsIDOMNSUIEvent nsuiEvent = (nsIDOMNSUIEvent)XPCOM.queryInterface((nsISupports)domEvent, nsIDOMNSUIEvent.class);
        return new Point(nsuiEvent.getPageX(), nsuiEvent.getPageY());
    }

    private nsIComponentManager getComponentManager() {
        if (this.componentManager == null) {
            this.componentManager = Mozilla.getInstance().getComponentManager();
        }
        return this.componentManager;
    }

    private nsIServiceManager getServiceManager() {
        if (this.serviceManager == null) {
            this.serviceManager = Mozilla.getInstance().getServiceManager();
        }
        return this.serviceManager;
    }

    private nsIDragService getDragService() {
        if (this.dragService == null) {
            this.dragService = (nsIDragService)this.getServiceManager().getServiceByContractID("@mozilla.org/widget/dragservice;1", "{82b58ada-f490-4c3d-b737-1057c4f1d052}");
        }
        return this.dragService;
    }

    private VpeSourceDropInfo getDropInfo() {
        Node dropContainer = null;
        int dropOffset = 0;
        boolean canDrop = false;
        if (this.dropableArea != null && this.dropableArea.getNode() != null && this.dropableArea.getHighlightedDropTarget() != null) {
            canDrop = true;
            DropTarget dropTarget = this.dropableArea.getHighlightedDropTarget();
            Node targetNode = this.getSourceNode(this.dropableArea.getNode());
            if (dropTarget == DropTarget.BEFORE || dropTarget == DropTarget.AFTER) {
                dropContainer = targetNode.getParentNode();
                int offset = 0;
                int i = 0;
                while (i < dropContainer.getChildNodes().getLength()) {
                    if (targetNode.equals(dropContainer.getChildNodes().item(i))) break;
                    ++offset;
                    ++i;
                }
                if (dropTarget == DropTarget.BEFORE) {
                    dropOffset = offset;
                } else if (dropTarget == DropTarget.AFTER) {
                    dropOffset = offset + 1;
                }
            } else if (dropTarget == DropTarget.BEGIN || dropTarget == DropTarget.END) {
                dropContainer = targetNode;
                if (dropTarget == DropTarget.BEGIN) {
                    dropOffset = 0;
                } else if (dropTarget == DropTarget.END) {
                    dropOffset = dropContainer.getChildNodes().getLength();
                }
            }
        }
        return new VpeSourceDropInfo(dropContainer, dropOffset, canDrop);
    }

    @Override
    public void notifySelectionChanged(nsIDOMDocument domDocument, nsISelection selection, short reason) {
        this.refreshDraggablePattern();
    }

    private static interface DropResolver {
        public boolean canDrop(Node var1);
    }
}

