/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.menu;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.template.IZoomEventManager;

public class ZoomActionMenuManager
extends MenuManager {
    private static final String ZOOM_MENU = "Zoom";
    private static final String ZOOM_IN = "Zoom In\tCtrl++";
    private static final String ZOOM_OUT = "Zoom Out\tCtrl+-";
    private static final String RESET = "Reset\tCtrl+0";
    private IZoomEventManager manager;

    public ZoomActionMenuManager(IZoomEventManager manager) {
        super(ZOOM_MENU);
        this.manager = manager;
        this.add((IAction)new ZoomInAcion());
        this.add((IAction)new ZoomOutAction());
        this.add((IContributionItem)new Separator());
        this.add((IAction)new ResetZoomViewAction());
    }

    private class ResetZoomViewAction
    extends Action {
        public ResetZoomViewAction() {
            this.setText(ZoomActionMenuManager.RESET);
        }

        public void run() {
            ZoomActionMenuManager.this.manager.resetZoomView();
        }
    }

    private class ZoomInAcion
    extends Action {
        public ZoomInAcion() {
            this.setText(ZoomActionMenuManager.ZOOM_IN);
            this.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)"icons/menu/zoom_in.png"));
        }

        public void run() {
            ZoomActionMenuManager.this.manager.zoomIn();
        }
    }

    private class ZoomOutAction
    extends Action {
        public ZoomOutAction() {
            this.setText(ZoomActionMenuManager.ZOOM_OUT);
            this.setImageDescriptor(ImageDescriptor.createFromFile(MozillaEditor.class, (String)"icons/menu/zoom_out.png"));
        }

        public void run() {
            ZoomActionMenuManager.this.manager.zoomOut();
        }
    }
}

