/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.template.VpeAbstractCreator;
import org.jboss.tools.vpe.editor.template.VpeAttributeCreator;
import org.jboss.tools.vpe.editor.template.VpeChildrenInfo;
import org.jboss.tools.vpe.editor.template.VpeCreator;
import org.jboss.tools.vpe.editor.template.VpeCreatorInfo;
import org.jboss.tools.vpe.editor.template.VpeDataTableElements;
import org.jboss.tools.vpe.editor.template.VpeDependencyMap;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilder;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionBuilderException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionException;
import org.jboss.tools.vpe.editor.template.expression.VpeExpressionInfo;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMAttr;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMHTMLTableCellElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMNodeList;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.xpcom.XPCOMException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeDataTableCreator
extends VpeAbstractCreator {
    private boolean caseSensitive;
    private static final String EMPTY = "";
    private static final String NONE = "none";
    private static final String DISPLAY_STYLE_NAME = "display:";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String HUNDRED_PERCENTS = "100%";
    private static final String ATTR_CAPTION_STYLE = "captionStyle";
    private static final String ATTR_CAPTION_CLASS = "captionClass";
    private static final String ATTR_HEADER_CLASS = "headerClass";
    private static final String ATTR_FOOTER_CLASS = "footerClass";
    private static final String ATTR_RULES = "rules";
    private static final String ATTR_RULES_VALUE_ROWS = "rows";
    private static final String TD_HIDDEN_BORDER_STYLE = "padding: 0px; border: 0px hidden;";
    private static final String TD_RULES_ROWS_BORDER_STYLE = "padding: 0px;";
    private static final String RULES_HIDDEN_BORDER_STYLE = "border: 0px hidden;";
    private List<VpeCreator> propertyCreators;

    VpeDataTableCreator(Element gridElement, VpeDependencyMap dependencyMap, boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
        this.build(gridElement, dependencyMap);
    }

    private void build(Element element, VpeDependencyMap dependencyMap) {
        Attr columnClassesAttr;
        Attr rowClassesAttr;
        Attr footerClassAttr;
        Attr headerClassAttr = element.getAttributeNode(ATTR_HEADER_CLASS);
        if (headerClassAttr != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(headerClassAttr.getValue(), this.caseSensitive);
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((footerClassAttr = element.getAttributeNode(ATTR_FOOTER_CLASS)) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(footerClassAttr.getValue(), this.caseSensitive);
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((rowClassesAttr = element.getAttributeNode("rowClasses")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(rowClassesAttr.getValue(), this.caseSensitive);
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if ((columnClassesAttr = element.getAttributeNode("columnClasses")) != null) {
            try {
                VpeExpressionInfo info = VpeExpressionBuilder.buildCompletedExpression(columnClassesAttr.getValue(), this.caseSensitive);
                dependencyMap.setCreator((VpeCreator)this, info.getDependencySet());
            }
            catch (VpeExpressionBuilderException e) {
                VpePlugin.reportProblem(e);
            }
        }
        if (VpeTemplateManager.ATTR_DATATABLE_PROPERTIES != null) {
            int i = 0;
            while (i < VpeTemplateManager.ATTR_DATATABLE_PROPERTIES.length) {
                String attrName = VpeTemplateManager.ATTR_DATATABLE_PROPERTIES[i];
                Attr attr = element.getAttributeNode(attrName);
                if (attr != null) {
                    if (this.propertyCreators == null) {
                        this.propertyCreators = new ArrayList<VpeCreator>();
                    }
                    this.propertyCreators.add(new VpeAttributeCreator(attrName, attr.getValue(), dependencyMap, this.caseSensitive));
                }
                ++i;
            }
        }
    }

    @Override
    public VpeCreatorInfo create(VpePageContext pageContext, Node sourceNode, nsIDOMDocument visualDocument, nsIDOMElement visualElement, Map visualNodeMap) throws VpeExpressionException {
        VpeChildrenInfo info;
        VpeChildrenInfo info2;
        VpeDataTableElements.SourceDataTableElements sourceElements = new VpeDataTableElements.SourceDataTableElements(sourceNode);
        VpeDataTableElements.VisualDataTableElements visualElements = new VpeDataTableElements.VisualDataTableElements();
        Element element = (Element)sourceNode;
        nsIDOMElement div = visualDocument.createElement("div");
        nsIDOMElement selectionTable = visualDocument.createElement("table");
        nsIDOMElement tr = visualDocument.createElement("tr");
        nsIDOMElement td = visualDocument.createElement("td");
        td.appendChild((nsIDOMNode)div);
        tr.appendChild((nsIDOMNode)td);
        selectionTable.appendChild((nsIDOMNode)tr);
        VpeCreatorInfo creatorInfo = new VpeCreatorInfo((nsIDOMNode)selectionTable);
        nsIDOMElement outterTable = visualDocument.createElement("table");
        nsIDOMElement visualTable = visualDocument.createElement("table");
        nsIDOMElement section = null;
        nsIDOMElement row = null;
        nsIDOMElement caption = null;
        div.appendChild((nsIDOMNode)outterTable);
        if (sourceElements.hasTableCaption()) {
            Node attr;
            caption = visualDocument.createElement("caption");
            if (sourceElements.getTableCaption() != null) {
                info2 = new VpeChildrenInfo(caption);
                info2.addSourceChild(sourceElements.getTableCaption());
                creatorInfo.addChildrenInfo(info2);
            }
            if ((attr = sourceNode.getAttributes().getNamedItem(ATTR_CAPTION_STYLE)) != null) {
                caption.setAttribute("style", attr.getNodeValue());
            }
            if ((attr = sourceNode.getAttributes().getNamedItem(ATTR_CAPTION_CLASS)) != null) {
                caption.setAttribute("class", attr.getNodeValue());
            }
            outterTable.appendChild((nsIDOMNode)caption);
            visualElements.setCaption(caption);
        }
        if (sourceElements.hasTableHeader()) {
            section = visualDocument.createElement("thead");
            row = visualDocument.createElement("tr");
            section.appendChild((nsIDOMNode)row);
            visualElements.setTableHeaderRow(row);
            nsIDOMElement thHeader = visualDocument.createElement("th");
            thHeader.setAttribute("class", element.getAttribute(ATTR_HEADER_CLASS));
            row.appendChild((nsIDOMNode)thHeader);
            if (sourceElements.getTableHeader() != null) {
                info = new VpeChildrenInfo(thHeader);
                info.addSourceChild(sourceElements.getTableHeader());
                creatorInfo.addChildrenInfo(info);
            }
            outterTable.appendChild((nsIDOMNode)section);
            visualElements.setTableHeader(section);
        }
        if (sourceElements.hasTableFooter()) {
            section = visualDocument.createElement("tfoot");
            row = visualDocument.createElement("tr");
            section.appendChild((nsIDOMNode)row);
            nsIDOMElement tdFooter = visualDocument.createElement("td");
            tdFooter.setAttribute("class", element.getAttribute(ATTR_FOOTER_CLASS));
            row.appendChild((nsIDOMNode)tdFooter);
            visualElements.setTableFooterRow(row);
            if (sourceElements.getTableFooter() != null) {
                info = new VpeChildrenInfo(tdFooter);
                info.addSourceChild(sourceElements.getTableFooter());
                creatorInfo.addChildrenInfo(info);
            }
            outterTable.appendChild((nsIDOMNode)section);
            visualElements.setTableFooter(section);
        }
        if (sourceElements.hasColumnsHeader()) {
            section = visualDocument.createElement("thead");
            row = visualDocument.createElement("tr");
            section.appendChild((nsIDOMNode)row);
            visualElements.setColumnsHeaderRow(row);
            visualTable.appendChild((nsIDOMNode)section);
            visualElements.setColumnsHeader(section);
        }
        if (sourceElements.hasColumnsFooter()) {
            section = visualDocument.createElement("tfoot");
            row = visualDocument.createElement("tr");
            section.appendChild((nsIDOMNode)row);
            visualElements.setColumnsFooterRow(row);
            visualTable.appendChild((nsIDOMNode)section);
            visualElements.setColumnsFooter(section);
        }
        if (sourceElements.hasBodySection()) {
            section = visualDocument.createElement("tbody");
            row = visualDocument.createElement("tr");
            section.appendChild((nsIDOMNode)row);
            visualTable.appendChild((nsIDOMNode)section);
            visualElements.setContentTableBodyRow(row);
        }
        info2 = null;
        if (sourceElements.getColumnCount() > 0) {
            nsIDOMElement group = visualDocument.createElement("colgroup");
            visualTable.appendChild((nsIDOMNode)group);
            info2 = new VpeChildrenInfo(group);
            creatorInfo.addChildrenInfo(info2);
        }
        int i = 0;
        while (i < sourceElements.getColumnCount()) {
            VpeDataTableElements.SourceColumnElements column = sourceElements.getColumn(i);
            info2.addSourceChild(column.getColumn());
            ++i;
        }
        nsIDOMElement outterTBODY = visualDocument.createElement("tbody");
        nsIDOMElement outterTR = visualDocument.createElement("tr");
        nsIDOMElement outterTD = visualDocument.createElement("td");
        outterTD.setAttribute("style", TD_HIDDEN_BORDER_STYLE);
        visualTable.setAttribute("width", HUNDRED_PERCENTS);
        visualTable.setAttribute("border", ZERO);
        outterTD.appendChild((nsIDOMNode)visualTable);
        outterTR.appendChild((nsIDOMNode)outterTD);
        outterTBODY.appendChild((nsIDOMNode)outterTR);
        outterTable.appendChild((nsIDOMNode)outterTBODY);
        visualElements.setBodyRow(outterTR);
        visualElements.setBody(outterTBODY);
        Object[] elements = new Object[]{visualElements, sourceElements};
        visualNodeMap.put(this, elements);
        int i2 = 0;
        while (i2 < this.propertyCreators.size()) {
            block26: {
                nsIDOMAttr attr;
                VpeCreatorInfo info22;
                VpeCreator creator;
                block27: {
                    creator = this.propertyCreators.get(i2);
                    if (creator == null) break block26;
                    VpeCreatorInfo info1 = creator.create(pageContext, (Element)sourceNode, visualDocument, outterTable, visualNodeMap);
                    if (info1 == null || info1.getVisualNode() == null) break block27;
                    nsIDOMAttr attr2 = (nsIDOMAttr)info1.getVisualNode();
                    if (attr2.getNodeValue() == null || EMPTY.equalsIgnoreCase(attr2.getNodeValue())) break block26;
                    outterTable.setAttributeNode(attr2);
                }
                if ((info22 = creator.create(pageContext, (Element)sourceNode, visualDocument, visualTable, visualNodeMap)) != null && info22.getVisualNode() != null && (attr = (nsIDOMAttr)info22.getVisualNode()).getNodeValue() != null && !EMPTY.equalsIgnoreCase(attr.getNodeValue())) {
                    if ("rowClasses".equalsIgnoreCase(attr.getNodeName())) {
                        this.setRowClass(visualElements.getContentTableBodyRow(), attr.getNodeValue());
                    } else if ("border".equalsIgnoreCase(attr.getNodeName())) {
                        String value = attr.getNodeValue();
                        int val = -1;
                        if (value != null && !EMPTY.equalsIgnoreCase(value)) {
                            try {
                                val = Integer.parseInt(value);
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                        if (val > 0) {
                            visualTable.setAttribute("border", ONE);
                            visualTable.setAttribute("style", RULES_HIDDEN_BORDER_STYLE);
                        }
                    } else {
                        if (ATTR_RULES.equalsIgnoreCase(attr.getNodeName()) && ATTR_RULES_VALUE_ROWS.equalsIgnoreCase(attr.getNodeValue())) {
                            outterTD.setAttribute("style", TD_RULES_ROWS_BORDER_STYLE);
                        }
                        visualTable.setAttributeNode(attr);
                    }
                }
            }
            ++i2;
        }
        return creatorInfo;
    }

    @Override
    public void setAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name, String value) {
        VpeDataTableElements.VisualDataTableElements visualElements = this.getVisualDataTableElements(visualNodeMap);
        if (visualElements != null) {
            if (this.caseSensitive ? ATTR_HEADER_CLASS.equals(name) : ATTR_HEADER_CLASS.equalsIgnoreCase(name)) {
                this.setCellsClass(visualElements.getTableHeaderRow(), value);
                this.setCellsClass(visualElements.getColumnsHeaderRow(), value);
            } else if (this.caseSensitive ? ATTR_FOOTER_CLASS.equals(name) : ATTR_FOOTER_CLASS.equalsIgnoreCase(name)) {
                this.setCellsClass(visualElements.getColumnsFooterRow(), value);
                this.setCellsClass(visualElements.getTableFooterRow(), value);
            } else if (this.caseSensitive ? "rowClasses".equals(name) : "rowClasses".equalsIgnoreCase(name)) {
                this.setRowClass(visualElements.getContentTableBodyRow(), value);
            } else if (this.caseSensitive ? "columnClasses".equals(name) : "columnClasses".equalsIgnoreCase(name)) {
                this.setCellsClass(visualElements.getContentTableBodyRow(), value);
            }
        }
    }

    public void validate(VpePageContext pageContext, Element sourceElement, Document visualDocument, Element visualParent, Element visualElement, Map visualNodeMap) {
        VpeDataTableElements.VisualDataTableElements visualElements = null;
        VpeDataTableElements.SourceDataTableElements sourceElements = null;
        if (visualNodeMap != null) {
            visualElements = this.getVisualDataTableElements(visualNodeMap);
            sourceElements = this.getSourceDataTableElements(visualNodeMap);
        } else if (sourceElement != null) {
            sourceElements = new VpeDataTableElements.SourceDataTableElements(sourceElement);
            nsIDOMNode visualNode = pageContext.getCurrentVisualNode();
            if (visualNode != null) {
                visualElements = VpeDataTableElements.getVisualDataTableElements(visualNode);
            }
        }
        if (visualElements != null) {
            this.setCellsClass(visualElements.getTableHeaderRow(), sourceElement.getAttribute(ATTR_HEADER_CLASS));
            this.setCellsClass(visualElements.getColumnsHeaderRow(), sourceElement.getAttribute(ATTR_HEADER_CLASS));
            this.setCellsClass(visualElements.getColumnsFooterRow(), sourceElement.getAttribute(ATTR_FOOTER_CLASS));
            this.setCellsClass(visualElements.getTableFooterRow(), sourceElement.getAttribute(ATTR_FOOTER_CLASS));
            this.setRowClass(visualElements.getBodyRow(), sourceElement.getAttribute("rowClasses"));
            this.setCellsClass(visualElements.getBodyRow(), sourceElement.getAttribute("columnClasses"));
        }
        if (sourceElements != null && visualElements != null) {
            this.setRowDisplayStyle(visualElements.getTableHeaderRow(), sourceElements.hasTableHeader());
            this.setRowDisplayStyle(visualElements.getColumnsHeaderRow(), sourceElements.hasColumnsHeader());
            this.setRowDisplayStyle(visualElements.getBodyRow(), sourceElements.hasBodySection());
            this.setRowDisplayStyle(visualElements.getColumnsFooterRow(), sourceElements.hasColumnsFooter());
            this.setRowDisplayStyle(visualElements.getTableFooterRow(), sourceElements.hasTableFooter());
        }
    }

    @Override
    public void removeAttribute(VpePageContext pageContext, Element sourceElement, Map visualNodeMap, String name) {
        VpeDataTableElements.VisualDataTableElements visualElements = this.getVisualDataTableElements(visualNodeMap);
        if (visualElements != null) {
            if (this.caseSensitive ? ATTR_HEADER_CLASS.equals(name) : ATTR_HEADER_CLASS.equalsIgnoreCase(name)) {
                this.removeCellsClass(visualElements.getTableHeaderRow());
                this.removeCellsClass(visualElements.getColumnsHeaderRow());
            } else if (this.caseSensitive ? ATTR_FOOTER_CLASS.equals(name) : ATTR_FOOTER_CLASS.equalsIgnoreCase(name)) {
                this.removeCellsClass(visualElements.getColumnsFooterRow());
                this.removeCellsClass(visualElements.getTableFooterRow());
            } else if (this.caseSensitive ? "rowClasses".equals(name) : "rowClasses".equalsIgnoreCase(name)) {
                this.removeRowClass(visualElements.getBodyRow());
            } else if (this.caseSensitive ? "columnClasses".equals(name) : "columnClasses".equalsIgnoreCase(name)) {
                this.removeCellsClass(visualElements.getBodyRow());
            }
        }
    }

    private String[] getClasses(String value) {
        if (value != null) {
            return value.split(",");
        }
        return new String[0];
    }

    private void setCellsClass(nsIDOMElement row, String value) {
        if (row != null && value != null) {
            String[] classes = this.getClasses(value);
            int ind = 0;
            nsIDOMNodeList children = row.getChildNodes();
            long count = children != null ? children.getLength() : 0L;
            long i = 0L;
            while (i < count) {
                nsIDOMNode child = children.item(i);
                if (child != null && child.getNodeType() == 1) {
                    try {
                        nsIDOMHTMLTableCellElement cell = (nsIDOMHTMLTableCellElement)XPCOM.queryInterface((nsISupports)child, nsIDOMHTMLTableCellElement.class);
                        cell.setAttribute("class", classes[ind]);
                        ind = ind < classes.length - 1 ? ind + 1 : 0;
                    }
                    catch (XPCOMException xPCOMException) {}
                }
                ++i;
            }
        }
    }

    private void removeCellsClass(nsIDOMElement row) {
        if (row != null) {
            nsIDOMNodeList children = row.getChildNodes();
            long count = children != null ? children.getLength() : 0L;
            long i = 0L;
            while (i < count) {
                nsIDOMNode child = children.item(i);
                if (child != null && child.getNodeType() == 1) {
                    try {
                        nsIDOMHTMLTableCellElement cell = (nsIDOMHTMLTableCellElement)XPCOM.queryInterface((nsISupports)child, nsIDOMHTMLTableCellElement.class);
                        cell.removeAttribute("class");
                    }
                    catch (XPCOMException xPCOMException) {}
                }
                ++i;
            }
        }
    }

    private void setRowClass(nsIDOMElement row, String value) {
        if (row != null && value != null) {
            String rowClass;
            String[] rowClasses = this.getClasses(value);
            String string = rowClass = rowClasses != null && rowClasses.length > 0 ? rowClasses[0] : null;
            if (rowClass != null && rowClass.trim().length() > 0) {
                row.setAttribute("class", rowClass);
            } else {
                row.removeAttribute("class");
            }
        }
    }

    private void setRowDisplayStyle(nsIDOMElement row, boolean visible) {
        if (row != null) {
            row.setAttribute("style", DISPLAY_STYLE_NAME + (visible ? EMPTY : NONE));
        }
    }

    private void removeRowClass(nsIDOMElement row) {
        if (row != null) {
            row.removeAttribute("class");
        }
    }

    private VpeDataTableElements.VisualDataTableElements getVisualDataTableElements(Map visualNodeMap) {
        Object o;
        if (visualNodeMap != null && (o = visualNodeMap.get(this)) != null && o instanceof Object[] && ((Object[])o)[0] instanceof VpeDataTableElements.VisualDataTableElements) {
            return (VpeDataTableElements.VisualDataTableElements)((Object[])o)[0];
        }
        return null;
    }

    private VpeDataTableElements.SourceDataTableElements getSourceDataTableElements(Map visualNodeMap) {
        Object o;
        if (visualNodeMap != null && (o = visualNodeMap.get(this)) != null && o instanceof Object[] && ((Object[])o)[1] instanceof VpeDataTableElements.SourceDataTableElements) {
            return (VpeDataTableElements.SourceDataTableElements)((Object[])o)[1];
        }
        return null;
    }
}

