/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.Iterator;
import java.util.Properties;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.type.Type;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ComponentShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.ExpandableShape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Shape;
import org.jboss.tools.hibernate.ui.diagram.editors.model.Utils;
import org.jboss.tools.hibernate.ui.diagram.rulers.DiagramGuide;

public class OrmShape
extends ExpandableShape {
    public static final String LOCATION_PROP = "location";
    private Point location = new Point(0, 0);
    private DiagramGuide verticalGuide;
    private DiagramGuide horizontalGuide;
    private static IPropertyDescriptor[] descriptors_entity = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"isAbstract", "isAbstract"), new TextPropertyDescriptor((Object)"isCustomDeleteCallable", "isCustomDeleteCallable"), new TextPropertyDescriptor((Object)"isCustomInsertCallable", "isCustomInsertCallable"), new TextPropertyDescriptor((Object)"isCustomUpdateCallable", "isCustomUpdateCallable"), new TextPropertyDescriptor((Object)"isDiscriminatorInsertable", "isDiscriminatorInsertable"), new TextPropertyDescriptor((Object)"isDiscriminatorValueNotNull", "isDiscriminatorValueNotNull"), new TextPropertyDescriptor((Object)"isDiscriminatorValueNull", "isDiscriminatorValueNull"), new TextPropertyDescriptor((Object)"isExplicitPolymorphism", "isExplicitPolymorphism"), new TextPropertyDescriptor((Object)"isForceDiscriminator", "isForceDiscriminator"), new TextPropertyDescriptor((Object)"isInherited", "isInherited"), new TextPropertyDescriptor((Object)"isJoinedSubclass", "isJoinedSubclass"), new TextPropertyDescriptor((Object)"isLazy", "isLazy"), new TextPropertyDescriptor((Object)"isLazyPropertiesCacheable", "isLazyPropertiesCacheable"), new TextPropertyDescriptor((Object)"isMutable", "isMutable"), new TextPropertyDescriptor((Object)"isPolymorphic", "isPolymorphic"), new TextPropertyDescriptor((Object)"isVersioned", "isVersioned"), new TextPropertyDescriptor((Object)"batchSize", "batchSize"), new TextPropertyDescriptor((Object)"cacheConcurrencyStrategy", "cacheConcurrencyStrategy"), new TextPropertyDescriptor((Object)"className", "className"), new TextPropertyDescriptor((Object)"customSQLDelete", "customSQLDelete"), new TextPropertyDescriptor((Object)"customSQLInsert", "customSQLInsert"), new TextPropertyDescriptor((Object)"customSQLUpdate", "customSQLUpdate"), new TextPropertyDescriptor((Object)"discriminatorValue", "discriminatorValue"), new TextPropertyDescriptor((Object)"entityName", "entityName"), new TextPropertyDescriptor((Object)"loaderName", "loaderName"), new TextPropertyDescriptor((Object)"nodeName", "nodeName"), new TextPropertyDescriptor((Object)"optimisticLockMode", "optimisticLockMode"), new TextPropertyDescriptor((Object)"table", "table"), new TextPropertyDescriptor((Object)"temporaryIdTableDDL", "temporaryIdTableDDL"), new TextPropertyDescriptor((Object)"temporaryIdTableName", "temporaryIdTableName"), new TextPropertyDescriptor((Object)"where", "where"), new TextPropertyDescriptor((Object)"cacheRegionName", "cacheRegionName")};
    private static IPropertyDescriptor[] descriptors_table = new IPropertyDescriptor[]{new TextPropertyDescriptor((Object)"catalog", "catalog"), new TextPropertyDescriptor((Object)"comment", "comment"), new TextPropertyDescriptor((Object)"name", "name"), new TextPropertyDescriptor((Object)"primaryKey", "primaryKey"), new TextPropertyDescriptor((Object)"rowId", "rowId"), new TextPropertyDescriptor((Object)"schema", "schema"), new TextPropertyDescriptor((Object)"subselect", "subselect"), new TextPropertyDescriptor((Object)"hasDenormalizedTables", "hasDenormalizedTables"), new TextPropertyDescriptor((Object)"isAbstract", "isAbstract"), new TextPropertyDescriptor((Object)"isAbstractUnionTable", "isAbstractUnionTable"), new TextPropertyDescriptor((Object)"isPhysicalTable", "isPhysicalTable")};
    private static final String ENTITY_isAbstract = "isAbstract";
    private static final String ENTITY_isCustomDeleteCallable = "isCustomDeleteCallable";
    private static final String ENTITY_isCustomInsertCallable = "isCustomInsertCallable";
    private static final String ENTITY_isCustomUpdateCallable = "isCustomUpdateCallable";
    private static final String ENTITY_isDiscriminatorInsertable = "isDiscriminatorInsertable";
    private static final String ENTITY_isDiscriminatorValueNotNull = "isDiscriminatorValueNotNull";
    private static final String ENTITY_isDiscriminatorValueNull = "isDiscriminatorValueNull";
    private static final String ENTITY_isExplicitPolymorphism = "isExplicitPolymorphism";
    private static final String ENTITY_isForceDiscriminator = "isForceDiscriminator";
    private static final String ENTITY_isInherited = "isInherited";
    private static final String ENTITY_isJoinedSubclass = "isJoinedSubclass";
    private static final String ENTITY_isLazy = "isLazy";
    private static final String ENTITY_isLazyPropertiesCacheable = "isLazyPropertiesCacheable";
    private static final String ENTITY_isMutable = "isMutable";
    private static final String ENTITY_isPolymorphic = "isPolymorphic";
    private static final String ENTITY_isVersioned = "isVersioned";
    private static final String ENTITY_batchSize = "batchSize";
    private static final String ENTITY_cacheConcurrencyStrategy = "cacheConcurrencyStrategy";
    private static final String ENTITY_className = "className";
    private static final String ENTITY_customSQLDelete = "customSQLDelete";
    private static final String ENTITY_customSQLInsert = "customSQLInsert";
    private static final String ENTITY_customSQLUpdate = "customSQLUpdate";
    private static final String ENTITY_discriminatorValue = "discriminatorValue";
    private static final String ENTITY_entityName = "entityName";
    private static final String ENTITY_loaderName = "loaderName";
    private static final String ENTITY_nodeName = "nodeName";
    private static final String ENTITY_optimisticLockMode = "optimisticLockMode";
    private static final String ENTITY_table = "table";
    private static final String ENTITY_temporaryIdTableDDL = "temporaryIdTableDDL";
    private static final String ENTITY_temporaryIdTableName = "temporaryIdTableName";
    private static final String ENTITY_where = "where";
    private static final String ENTITY_cacheRegionName = "cacheRegionName";
    private static final String TABLE_catalog = "catalog";
    private static final String TABLE_comment = "comment";
    private static final String TABLE_name = "name";
    private static final String TABLE_primaryKey = "primaryKey";
    private static final String TABLE_rowId = "rowId";
    private static final String TABLE_schema = "schema";
    private static final String TABLE_subselect = "subselect";
    private static final String TABLE_hasDenormalizedTables = "hasDenormalizedTables";
    private static final String TABLE_isAbstract = "isAbstract";
    private static final String TABLE_isAbstractUnionTable = "isAbstractUnionTable";
    private static final String TABLE_isPhysicalTable = "isPhysicalTable";

    public OrmShape(Object ioe, String consoleConfigName) {
        super(ioe, consoleConfigName);
        this.initModel();
    }

    protected void initModel() {
        block20: {
            Object ormElement;
            block21: {
                Iterator iterator;
                KeyValue identifier;
                block19: {
                    Component component;
                    KeyValue identifier2;
                    ormElement = this.getOrmElement();
                    if (!(ormElement instanceof RootClass)) break block19;
                    RootClass rootClass = (RootClass)ormElement;
                    Property identifierProperty = rootClass.getIdentifierProperty();
                    if (identifierProperty != null) {
                        this.addChild(new Shape(identifierProperty, this.getConsoleConfigName()));
                    }
                    if ((identifier2 = rootClass.getIdentifier()) instanceof Component && (component = (Component)identifier2).isEmbedded()) {
                        Iterator iterator2 = ((Component)identifier2).getPropertyIterator();
                        while (iterator2.hasNext()) {
                            Property property = (Property)iterator2.next();
                            this.addChild(new Shape(property, this.getConsoleConfigName()));
                        }
                    }
                    Iterator iterator3 = rootClass.getPropertyIterator();
                    while (iterator3.hasNext()) {
                        Property field = (Property)iterator3.next();
                        if (field.isBackRef()) continue;
                        if (!field.isComposite()) {
                            Type type;
                            Value val = field.getValue();
                            Shape bodyOrmShape = null;
                            bodyOrmShape = val.isSimpleValue() && !((SimpleValue)val).isTypeSpecified() ? new Shape(field, this.getConsoleConfigName()) : (val instanceof Collection ? new ComponentShape(field, this.getConsoleConfigName()) : ((type = this.getTypeUsingExecContext(val)) != null && type.isEntityType() ? new ExpandableShape(field, this.getConsoleConfigName()) : new Shape(field, this.getConsoleConfigName())));
                            this.addChild(bodyOrmShape);
                            continue;
                        }
                        ExpandableShape bodyOrmShape = new ExpandableShape(field, this.getConsoleConfigName());
                        this.addChild(bodyOrmShape);
                    }
                    break block20;
                }
                if (!(ormElement instanceof Subclass)) break block21;
                RootClass rootClass = ((Subclass)ormElement).getRootClass();
                Property identifierProperty = rootClass.getIdentifierProperty();
                if (identifierProperty != null) {
                    this.addChild(new Shape(identifierProperty, this.getConsoleConfigName()));
                }
                if ((identifier = rootClass.getIdentifier()) instanceof Component) {
                    iterator = ((Component)identifier).getPropertyIterator();
                    while (iterator.hasNext()) {
                        Property property = (Property)iterator.next();
                        this.addChild(new Shape(property, this.getConsoleConfigName()));
                    }
                }
                iterator = rootClass.getPropertyIterator();
                while (iterator.hasNext()) {
                    Property field = (Property)iterator.next();
                    if (field.isBackRef()) continue;
                    if (!field.isComposite()) {
                        boolean typeIsAccessible = true;
                        if (field.getValue().isSimpleValue() && ((SimpleValue)field.getValue()).isTypeSpecified()) {
                            try {
                                field.getValue().getType();
                            }
                            catch (Exception exception) {
                                typeIsAccessible = false;
                            }
                        }
                        Shape bodyOrmShape = null;
                        bodyOrmShape = typeIsAccessible && field.getValue().isSimpleValue() ? new Shape(field, this.getConsoleConfigName()) : (typeIsAccessible && field.getValue().getType().isEntityType() ? new ExpandableShape(field, this.getConsoleConfigName()) : (typeIsAccessible && field.getValue().getType().isCollectionType() ? new ComponentShape(field, this.getConsoleConfigName()) : new Shape(field, this.getConsoleConfigName())));
                        this.addChild(bodyOrmShape);
                        continue;
                    }
                    ExpandableShape bodyOrmShape = new ExpandableShape(field, this.getConsoleConfigName());
                    this.addChild(bodyOrmShape);
                }
                Iterator iter = ((Subclass)ormElement).getPropertyIterator();
                while (iter.hasNext()) {
                    Property property = (Property)iter.next();
                    if (property.isBackRef()) continue;
                    if (!property.isComposite()) {
                        boolean typeIsAccessible = true;
                        if (property.getValue().isSimpleValue() && ((SimpleValue)property.getValue()).isTypeSpecified()) {
                            try {
                                property.getValue().getType();
                            }
                            catch (Exception exception) {
                                typeIsAccessible = false;
                            }
                        }
                        Shape bodyOrmShape = null;
                        bodyOrmShape = typeIsAccessible && property.getValue().getType().isEntityType() ? new ExpandableShape(property, this.getConsoleConfigName()) : (typeIsAccessible && property.getValue().getType().isCollectionType() ? new ComponentShape(property, this.getConsoleConfigName()) : new Shape(property, this.getConsoleConfigName()));
                        this.addChild(bodyOrmShape);
                        continue;
                    }
                    ExpandableShape bodyOrmShape = new ExpandableShape(property, this.getConsoleConfigName());
                    this.addChild(bodyOrmShape);
                }
                break block20;
            }
            if (!(ormElement instanceof Table)) break block20;
            Iterator iterator = ((Table)this.getOrmElement()).getColumnIterator();
            while (iterator.hasNext()) {
                Column column = (Column)iterator.next();
                Shape bodyOrmShape = new Shape(column, this.getConsoleConfigName());
                this.addChild(bodyOrmShape);
            }
        }
    }

    public Shape getChild(Column ormElement) {
        if (ormElement == null) {
            return null;
        }
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            Shape child = it.next();
            Object childElement = child.getOrmElement();
            if (!(childElement instanceof Column) || !ormElement.getName().equals(((Column)childElement).getName())) continue;
            return child;
        }
        return null;
    }

    public Shape getChild(Property ormElement) {
        if (ormElement == null) {
            return null;
        }
        Iterator<Shape> it = this.getChildrenIterator();
        while (it.hasNext()) {
            Shape child = it.next();
            Object childElement = child.getOrmElement();
            if (!(childElement instanceof Property) || !ormElement.getName().equals(((Property)childElement).getName())) continue;
            return child;
        }
        return null;
    }

    public Point getLocation() {
        return this.location.getCopy();
    }

    public void setLocation(Point newLocation) {
        if (newLocation == null) {
            throw new IllegalArgumentException();
        }
        this.location.setLocation(newLocation);
        this.firePropertyChange(LOCATION_PROP, null, this.location);
    }

    public DiagramGuide getHorizontalGuide() {
        return this.horizontalGuide;
    }

    public void setHorizontalGuide(DiagramGuide hGuide) {
        this.horizontalGuide = hGuide;
    }

    public DiagramGuide getVerticalGuide() {
        return this.verticalGuide;
    }

    public void setVerticalGuide(DiagramGuide vGuide) {
        this.verticalGuide = vGuide;
    }

    protected Point getPoint(IMemento memento, String key) {
        Point point = new Point(0, 0);
        String str = Utils.getPropertyValue(memento, String.valueOf(key) + ".x", "0");
        point.x = Integer.parseInt(str);
        String str2 = Utils.getPropertyValue(memento, String.valueOf(key) + ".y", "0");
        point.y = Integer.parseInt(str2);
        return point;
    }

    protected void setPoint(IMemento memento, String key, Point point) {
        String key1 = String.valueOf(key) + ".x";
        memento.putString(key1, "" + point.x);
        String key2 = String.valueOf(key) + ".y";
        memento.putString(key2, "" + point.y);
    }

    protected Point getPoint(Properties properties, String key) {
        Point point = new Point(0, 0);
        String str = properties.getProperty(String.valueOf(key) + ".x", "0");
        point.x = Integer.parseInt(str);
        String str2 = properties.getProperty(String.valueOf(key) + ".y", "0");
        point.y = Integer.parseInt(str2);
        return point;
    }

    protected void setPoint(Properties properties, String key, Point point) {
        String key1 = String.valueOf(key) + ".x";
        if (!properties.containsKey(key1)) {
            properties.remove(key1);
        }
        properties.put(key1, "" + point.x);
        String key2 = String.valueOf(key) + ".y";
        if (!properties.containsKey(key2)) {
            properties.remove(key2);
        }
        properties.put(key2, "" + point.y);
    }

    public void setPosition(IMemento memento) {
        Point point = this.getLocation();
        this.setPoint(memento, this.getKey(), point);
    }

    public Point getPosition(IMemento memento) {
        return this.getPoint(memento, this.getKey());
    }

    public void setPosition(Properties properties) {
        Point point = this.getLocation();
        this.setPoint(properties, this.getKey(), point);
    }

    public Point getPosition(Properties properties) {
        return this.getPoint(properties, this.getKey());
    }

    public void loadState(IMemento memento) {
        super.loadState(memento);
        Point pos = this.getPosition(memento);
        this.setLocation(pos);
    }

    protected void loadFromProperties(Properties properties) {
        super.loadFromProperties(properties);
        Point pos = this.getPosition(properties);
        this.setLocation(pos);
    }

    public void saveState(IMemento memento) {
        this.setPosition(memento);
        super.saveState(memento);
    }

    protected void saveInProperties(Properties properties) {
        this.setPosition(properties);
        super.saveInProperties(properties);
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        IPropertyDescriptor[] res = super.getPropertyDescriptors();
        if (res.length > 0) {
            return res;
        }
        Object ormElement = this.getOrmElement();
        if (ormElement instanceof RootClass) {
            res = descriptors_entity;
        } else if (!(ormElement instanceof Subclass) && ormElement instanceof Table) {
            res = descriptors_table;
        }
        return res;
    }

    public Object getPropertyValue(Object propertyId) {
        Object res = null;
        RootClass rootClass = null;
        Table table = null;
        Object ormElement = this.getOrmElement();
        if (ormElement instanceof RootClass) {
            rootClass = (RootClass)ormElement;
        } else if (!(ormElement instanceof Subclass) && ormElement instanceof Table) {
            table = (Table)this.getOrmElement();
        }
        if (rootClass != null) {
            if ("isAbstract".equals(propertyId)) {
                if (rootClass.isAbstract() != null) {
                    res = rootClass.isAbstract().toString();
                }
            } else if (ENTITY_isCustomDeleteCallable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isCustomDeleteCallable()).toString();
            } else if (ENTITY_isCustomInsertCallable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isCustomInsertCallable()).toString();
            } else if (ENTITY_isCustomUpdateCallable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isCustomUpdateCallable()).toString();
            } else if (ENTITY_isDiscriminatorInsertable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isDiscriminatorInsertable()).toString();
            } else if (ENTITY_isDiscriminatorValueNotNull.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isDiscriminatorValueNotNull()).toString();
            } else if (ENTITY_isDiscriminatorValueNull.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isDiscriminatorValueNull()).toString();
            } else if (ENTITY_isExplicitPolymorphism.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isExplicitPolymorphism()).toString();
            } else if (ENTITY_isForceDiscriminator.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isForceDiscriminator()).toString();
            } else if (ENTITY_isInherited.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isInherited()).toString();
            } else if (ENTITY_isJoinedSubclass.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isJoinedSubclass()).toString();
            } else if (ENTITY_isLazy.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isLazy()).toString();
            } else if (ENTITY_isLazyPropertiesCacheable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isLazyPropertiesCacheable()).toString();
            } else if (ENTITY_isMutable.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isMutable()).toString();
            } else if (ENTITY_isPolymorphic.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isPolymorphic()).toString();
            } else if (ENTITY_isVersioned.equals(propertyId)) {
                res = Boolean.valueOf(rootClass.isVersioned()).toString();
            } else if (ENTITY_batchSize.equals(propertyId)) {
                res = Integer.valueOf(rootClass.getBatchSize()).toString();
            } else if (ENTITY_cacheConcurrencyStrategy.equals(propertyId)) {
                res = rootClass.getCacheConcurrencyStrategy();
            } else if (ENTITY_className.equals(propertyId)) {
                res = rootClass.getClassName();
            } else if (ENTITY_customSQLDelete.equals(propertyId)) {
                res = rootClass.getCustomSQLDelete();
            } else if (ENTITY_customSQLInsert.equals(propertyId)) {
                res = rootClass.getCustomSQLInsert();
            } else if (ENTITY_customSQLUpdate.equals(propertyId)) {
                res = rootClass.getCustomSQLUpdate();
            } else if (ENTITY_discriminatorValue.equals(propertyId)) {
                res = rootClass.getDiscriminatorValue();
            } else if (ENTITY_entityName.equals(propertyId)) {
                res = rootClass.getEntityName();
            } else if (ENTITY_loaderName.equals(propertyId)) {
                res = rootClass.getLoaderName();
            } else if (ENTITY_nodeName.equals(propertyId)) {
                res = rootClass.getNodeName();
            } else if (ENTITY_optimisticLockMode.equals(propertyId)) {
                res = Integer.valueOf(rootClass.getOptimisticLockMode()).toString();
            } else if (ENTITY_table.equals(propertyId)) {
                if (rootClass.getTable() != null) {
                    res = rootClass.getTable().getName();
                }
            } else if (ENTITY_temporaryIdTableDDL.equals(propertyId)) {
                res = rootClass.getTemporaryIdTableDDL();
            } else if (ENTITY_temporaryIdTableName.equals(propertyId)) {
                res = rootClass.getTemporaryIdTableName();
            } else if (ENTITY_where.equals(propertyId)) {
                res = rootClass.getWhere();
            }
        }
        if (table != null) {
            if (TABLE_catalog.equals(propertyId)) {
                res = table.getCatalog();
            } else if (TABLE_comment.equals(propertyId)) {
                res = table.getComment();
            } else if (TABLE_name.equals(propertyId)) {
                res = table.getName();
            } else if (TABLE_primaryKey.equals(propertyId)) {
                if (table.getPrimaryKey() != null) {
                    res = table.getPrimaryKey().getName();
                }
            } else if (TABLE_rowId.equals(propertyId)) {
                res = table.getRowId();
            } else if (TABLE_schema.equals(propertyId)) {
                res = table.getSchema();
            } else if (TABLE_subselect.equals(propertyId)) {
                res = table.getSubselect();
            } else if (TABLE_hasDenormalizedTables.equals(propertyId)) {
                res = Boolean.valueOf(table.hasDenormalizedTables()).toString();
            } else if ("isAbstract".equals(propertyId)) {
                res = Boolean.valueOf(table.isAbstract()).toString();
            } else if (TABLE_isAbstractUnionTable.equals(propertyId)) {
                res = Boolean.valueOf(table.isAbstractUnionTable()).toString();
            } else if (TABLE_isPhysicalTable.equals(propertyId)) {
                res = Boolean.valueOf(table.isPhysicalTable()).toString();
            }
        }
        if (res == null) {
            res = super.getPropertyValue(propertyId);
        }
        return this.toEmptyStr(res);
    }
}

