/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.hibernate.ui.diagram.editors.model;

import java.util.Iterator;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;

public class SpecialRootClass
extends RootClass {
    private Property property;
    private Property parentProperty;

    public SpecialRootClass(Property property) {
        this.property = property;
        this.generate();
    }

    private void generate() {
        if (this.property == null) {
            return;
        }
        Component component = null;
        if (this.property.getValue() instanceof Collection) {
            Collection collection = (Collection)this.property.getValue();
            component = (Component)collection.getElement();
        } else if (this.property.getValue() instanceof Component) {
            component = (Component)this.property.getValue();
        }
        if (component != null) {
            this.setClassName(component.getComponentClassName());
            this.setEntityName(component.getComponentClassName());
            PersistentClass ownerClass = component.getOwner();
            if (component.getParentProperty() != null) {
                this.parentProperty = new Property();
                this.parentProperty.setName(component.getParentProperty());
                this.parentProperty.setPersistentClass(ownerClass);
            }
            Iterator iterator = component.getPropertyIterator();
            while (iterator.hasNext()) {
                Property property = (Property)iterator.next();
                if (property == null) continue;
                this.addProperty(property);
            }
        }
    }

    protected Property getParentProperty() {
        return this.parentProperty;
    }

    public Property getProperty() {
        return this.property;
    }
}

