/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.graph;

import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.hibernate.eclipse.graph.anchor.LeftOrRightParentAnchor;
import org.hibernate.eclipse.graph.figures.EditableLabel;
import org.hibernate.eclipse.graph.model.ColumnViewAdapter;
import org.hibernate.mapping.Column;

public class ColumnEditPart
extends AbstractGraphicalEditPart
implements NodeEditPart,
Observer {
    public ColumnEditPart(ColumnViewAdapter column) {
        this.setModel(column);
    }

    public void activate() {
        ((Observable)this.getModel()).addObserver(this);
        super.activate();
    }

    public void deactivate() {
        super.deactivate();
        ((Observable)this.getModel()).deleteObserver(this);
    }

    protected IFigure createFigure() {
        Column column = ((ColumnViewAdapter)this.getModel()).getcolumn();
        String label = column.getName();
        EditableLabel columnLabel = new EditableLabel(label);
        return columnLabel;
    }

    protected void createEditPolicies() {
    }

    public Command getCommand(Request request) {
        return super.getCommand(request);
    }

    public List getModelSourceConnections() {
        return Collections.EMPTY_LIST;
    }

    public List getModelTargetConnections() {
        return Collections.EMPTY_LIST;
    }

    public ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getSourceConnectionAnchor(Request request) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    public ConnectionAnchor getTargetConnectionAnchor(Request request) {
        return new LeftOrRightParentAnchor(this.getFigure());
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg == "ASSOCIATIONS") {
            this.refreshSourceConnections();
            this.refreshTargetConnections();
        }
    }

    public void setSelected(int value) {
        super.setSelected(value);
    }
}

