/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import java.io.File;
import java.util.Set;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IProcess;
import org.hibernate.eclipse.launch.CodeGenXMLFactory;
import org.hibernate.eclipse.launch.CodeGenerationUtils;

public class CodeGenerationProcessListener
implements IDebugEventSetListener {
    protected IProcess process;
    protected String fileName;
    protected Set<String> outputDirs;

    public CodeGenerationProcessListener(IProcess process, String fileName, Set<String> outputDirs) {
        this.process = process;
        this.fileName = fileName;
        this.outputDirs = outputDirs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startBackgroundRefresh() {
        IProcess iProcess = this.process;
        synchronized (iProcess) {
            if (this.process.isTerminated()) {
                this.refresh();
            } else {
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
            }
        }
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource() == this.process && event.getKind() == 8) {
                DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
                this.refresh();
                break;
            }
            ++i;
        }
    }

    protected void refresh() {
        Path path2File = new Path(this.fileName);
        File file = path2File.toFile();
        file.delete();
        String externalPropFileName = CodeGenXMLFactory.getExternalPropFileNameStandard(this.fileName);
        path2File = new Path(externalPropFileName);
        file = path2File.toFile();
        file.delete();
        for (String path : this.outputDirs) {
            CodeGenerationUtils.refreshOutputDir(path);
        }
    }
}

