/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.launch;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.HibernateConsolePlugin;
import org.hibernate.eclipse.console.utils.DialogSelectionHelper;
import org.hibernate.eclipse.console.utils.EclipseImages;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.console.wizards.NewReverseEngineeringFileWizard;
import org.hibernate.eclipse.launch.DirectoryBrowseField;
import org.hibernate.eclipse.launch.ExporterAttributes;
import org.hibernate.eclipse.launch.PathHelper;

public class CodeGenerationSettingsTab
extends AbstractLaunchConfigurationTab {
    public static final String NULL_CONFIG = "<None>";
    private ComboDialogField consoleConfigurationName;
    private IStructuredSelection selection;
    private SelectionButtonDialogField reverseengineer;
    private StringButtonDialogField outputdir;
    private StringButtonDialogField reverseEngineeringSettings;
    private StringButtonDialogField reverseEngineeringStrategy;
    private StringDialogField packageName;
    private SelectionButtonDialogField preferRawCompositeIds;
    private SelectionButtonDialogField autoVersioning;
    private SelectionButtonDialogField autoManyToMany;
    private SelectionButtonDialogField autoOneToOne;
    private SelectionButtonDialogField useOwnTemplates;
    private DirectoryBrowseField templatedir;
    private SelectionButtonDialogField useExternalProcess;

    public void createControl(Composite parent) {
        ScrolledComposite sc = new ScrolledComposite(parent, 768);
        sc.setExpandHorizontal(true);
        sc.setExpandVertical(true);
        Composite container = new Composite((Composite)sc, 0);
        sc.setContent((Control)container);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 4;
        layout.verticalSpacing = 10;
        IDialogFieldListener fieldlistener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                CodeGenerationSettingsTab.this.dialogChanged();
            }
        };
        this.useExternalProcess = new SelectionButtonDialogField(32);
        this.useExternalProcess.setDialogFieldListener(fieldlistener);
        this.useExternalProcess.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_use_generation_in_external_process);
        this.consoleConfigurationName = new ComboDialogField(8);
        this.consoleConfigurationName.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_console_configuration);
        ConsoleConfiguration[] cfg = LaunchHelper.findFilteredSortedConsoleConfigs();
        String[] names = new String[cfg.length + 1];
        names[0] = NULL_CONFIG;
        int i = 0;
        while (i < cfg.length) {
            ConsoleConfiguration configuration = cfg[i];
            names[i + 1] = configuration.getName();
            ++i;
        }
        this.consoleConfigurationName.setItems(names);
        this.consoleConfigurationName.setDialogFieldListener(fieldlistener);
        this.outputdir = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IPath[] paths = DialogSelectionHelper.chooseFolderEntries(CodeGenerationSettingsTab.this.getShell(), (IPath)PathHelper.pathOrNull(CodeGenerationSettingsTab.this.outputdir.getText()), HibernateConsoleMessages.CodeGenerationSettingsTab_select_output_dir, HibernateConsoleMessages.CodeGenerationSettingsTab_choose_dir_for_generated_files, false);
                if (paths != null && paths.length == 1) {
                    CodeGenerationSettingsTab.this.outputdir.setText(paths[0].toOSString());
                }
            }
        });
        this.outputdir.setDialogFieldListener(fieldlistener);
        this.outputdir.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_output_dir);
        this.outputdir.setButtonLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_browse);
        this.templatedir = new DirectoryBrowseField(null, null, HibernateConsoleMessages.CodeGenerationSettingsTab_select_template_dir, HibernateConsoleMessages.CodeGenerationSettingsTab_choose_dir_custom_templates);
        this.templatedir.setDialogFieldListener(fieldlistener);
        this.templatedir.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_template_directory);
        this.templatedir.setFilesystemBrowseLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_filesystem);
        this.templatedir.setWorkspaceBrowseLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_workspace);
        this.packageName = new StringDialogField();
        this.packageName.setDialogFieldListener(fieldlistener);
        this.packageName.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_package);
        this.reverseEngineeringStrategy = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                String string = DialogSelectionHelper.chooseImplementation(ReverseEngineeringStrategy.class.getName(), CodeGenerationSettingsTab.this.reverseEngineeringStrategy.getText(), HibernateConsoleMessages.CodeGenerationSettingsTab_choose_reverse_engineering_strategy, CodeGenerationSettingsTab.this.getShell());
                if (string != null) {
                    CodeGenerationSettingsTab.this.reverseEngineeringStrategy.setText(string);
                }
            }
        });
        this.reverseEngineeringStrategy.setDialogFieldListener(fieldlistener);
        this.reverseEngineeringStrategy.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_reveng_strategy);
        this.reverseEngineeringStrategy.setButtonLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_browse);
        this.reverseEngineeringSettings = new StringButtonDialogField(new IStringButtonAdapter(){

            public void changeControlPressed(DialogField field) {
                IPath[] paths;
                int defaultChoice = 0;
                IPath reverseEngineeringSettingsFile = CodeGenerationSettingsTab.this.getReverseEngineeringSettingsFile();
                defaultChoice = reverseEngineeringSettingsFile == null ? 0 : 1;
                MessageDialog dialog = new MessageDialog(CodeGenerationSettingsTab.this.getShell(), HibernateConsoleMessages.CodeGenerationSettingsTab_setup_reverse_engineering, null, HibernateConsoleMessages.CodeGenerationSettingsTab_do_you_want_create_reveng_xml, 3, new String[]{HibernateConsoleMessages.CodeGenerationSettingsTab_create_new, HibernateConsoleMessages.CodeGenerationSettingsTab_use_existing, IDialogConstants.CANCEL_LABEL}, defaultChoice);
                int answer = dialog.open();
                if (answer == 0) {
                    NewReverseEngineeringFileWizard wizard = new NewReverseEngineeringFileWizard();
                    wizard.init(PlatformUI.getWorkbench(), CodeGenerationSettingsTab.this.selection);
                    wizard.setSelectConfiguration(CodeGenerationSettingsTab.this.getConfigurationName());
                    IWorkbenchWindow win = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                    WizardDialog wdialog = new WizardDialog(win.getShell(), (IWizard)wizard);
                    wdialog.open();
                    IPath createdFilePath = wizard.getCreatedFilePath();
                    if (createdFilePath != null) {
                        CodeGenerationSettingsTab.this.reverseEngineeringSettings.setText(createdFilePath.toOSString());
                    }
                } else if (answer == 1 && (paths = DialogSelectionHelper.chooseFileEntries(CodeGenerationSettingsTab.this.getShell(), reverseEngineeringSettingsFile, new IPath[0], HibernateConsoleMessages.CodeGenerationSettingsTab_select_reverse_engineering_settings_file, HibernateConsoleMessages.CodeGenerationSettingsTab_choose_file_read_reverse_settings, new String[]{HibernateConsoleMessages.CodeGenerationSettingsTab_reveng_xml_1}, false, false, true)) != null && paths.length == 1) {
                    CodeGenerationSettingsTab.this.reverseEngineeringSettings.setText(paths[0].toOSString());
                }
            }
        });
        this.reverseEngineeringSettings.setDialogFieldListener(fieldlistener);
        this.reverseEngineeringSettings.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_reveng_xml_2);
        this.reverseEngineeringSettings.setButtonLabel(HibernateConsoleMessages.CodeGenerationSettingsTab_setup);
        this.reverseengineer = new SelectionButtonDialogField(32);
        this.reverseengineer.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_reverse_engineer_from_jdbc_connection);
        this.reverseengineer.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates = new SelectionButtonDialogField(32);
        this.useOwnTemplates.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_use_custom_templates);
        this.preferRawCompositeIds = new SelectionButtonDialogField(32);
        this.preferRawCompositeIds.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_generate_basic_typed_composite_ids);
        this.preferRawCompositeIds.setSelection(true);
        this.preferRawCompositeIds.setDialogFieldListener(fieldlistener);
        this.autoManyToMany = new SelectionButtonDialogField(32);
        this.autoManyToMany.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_detect_many_to_many_tables);
        this.autoManyToMany.setSelection(true);
        this.autoManyToMany.setDialogFieldListener(fieldlistener);
        this.autoOneToOne = new SelectionButtonDialogField(32);
        this.autoOneToOne.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_detect_one_to_one_associations);
        this.autoOneToOne.setSelection(true);
        this.autoOneToOne.setDialogFieldListener(fieldlistener);
        this.autoVersioning = new SelectionButtonDialogField(32);
        this.autoVersioning.setLabelText(HibernateConsoleMessages.CodeGenerationSettingsTab_detect_optimistic_lock_columns);
        this.autoVersioning.setSelection(true);
        this.autoVersioning.setDialogFieldListener(fieldlistener);
        this.useOwnTemplates.attachDialogField((DialogField)this.templatedir);
        this.reverseengineer.attachDialogFields(new DialogField[]{this.packageName, this.preferRawCompositeIds, this.reverseEngineeringSettings, this.reverseEngineeringStrategy, this.autoManyToMany, this.autoOneToOne, this.autoVersioning});
        this.useExternalProcess.setSelection(false);
        this.consoleConfigurationName.doFillIntoGrid(container, 4);
        Control[] controls = this.outputdir.doFillIntoGrid(container, 4);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        this.reverseengineer.doFillIntoGrid(container, 4);
        this.packageName.doFillIntoGrid(container, 4);
        this.reverseEngineeringSettings.doFillIntoGrid(container, 4);
        this.reverseEngineeringStrategy.doFillIntoGrid(container, 4);
        this.fillLabel(container);
        this.preferRawCompositeIds.doFillIntoGrid(container, 3);
        this.fillLabel(container);
        this.autoVersioning.doFillIntoGrid(container, 3);
        this.fillLabel(container);
        this.autoManyToMany.doFillIntoGrid(container, 3);
        this.fillLabel(container);
        this.autoOneToOne.doFillIntoGrid(container, 3);
        this.useOwnTemplates.doFillIntoGrid(container, 4);
        controls = this.templatedir.doFillIntoGrid(container, 4);
        ((GridData)controls[1].getLayoutData()).grabExcessHorizontalSpace = true;
        sc.setMinSize(container.computeSize(-1, -1));
        this.dialogChanged();
        this.setControl((Control)sc);
    }

    private void fillLabel(Composite container) {
        new Label(container, 0);
    }

    private void dialogChanged() {
        IStatus val;
        boolean configSelected = this.getConfigurationName().length() == 0;
        this.outputdir.setEnabled(!configSelected);
        this.reverseengineer.setEnabled(!configSelected);
        this.useOwnTemplates.setEnabled(!configSelected);
        this.useExternalProcess.setEnabled(!configSelected);
        boolean useExternalProcessFlag = this.useExternalProcess.isSelected();
        this.preferRawCompositeIds.setEnabled(this.reverseengineer.isSelected() && !configSelected && !useExternalProcessFlag);
        if (useExternalProcessFlag) {
            this.preferRawCompositeIds.setSelection(true);
        }
        if (configSelected) {
            this.updateStatus(HibernateConsoleMessages.CodeGenerationSettingsTab_console_cfg_must_be_specified);
            return;
        }
        String msg = PathHelper.checkDirectory(this.outputdir.getText(), HibernateConsoleMessages.CodeGenerationSettingsTab_output_directory, true);
        if (msg != null) {
            this.updateStatus(msg);
            return;
        }
        String warning = null;
        if (this.packageName.isEnabled() && this.getOutputPackage().length() > 0) {
            val = JavaConventions.validatePackageName((String)this.getOutputPackage());
            if (val.getSeverity() == 4) {
                this.updateStatus(val.getMessage());
                return;
            }
            if (val.getSeverity() == 2) {
                warning = val.getMessage();
            }
        }
        if (this.reverseEngineeringSettings.isEnabled() && this.reverseEngineeringSettings.getText().trim().length() > 0 && (msg = PathHelper.checkFile(this.reverseEngineeringSettings.getText(), HibernateConsoleMessages.CodeGenerationSettingsTab_reveng_xml_3, true)) != null) {
            this.updateStatus(msg);
            return;
        }
        if (this.reverseEngineeringStrategy.isEnabled() && this.reverseEngineeringStrategy.getText().trim().length() > 0) {
            val = JavaConventions.validateJavaTypeName((String)this.getReverseEngineeringStrategy(), (String)"1.5", (String)"1.5");
            if (val.getSeverity() == 4) {
                this.updateStatus(val.getMessage());
                return;
            }
            if (val.getSeverity() == 2) {
                warning = val.getMessage();
            }
        }
        if (this.useOwnTemplates.isSelected() && (msg = PathHelper.checkDirectory(this.templatedir.getText(), HibernateConsoleMessages.CodeGenerationSettingsTab_template_dir, true)) != null) {
            this.updateStatus(msg);
            return;
        }
        if (warning != null) {
            this.setMessage(warning);
        } else {
            this.setMessage(null);
        }
        this.updateStatus(null);
    }

    protected String checkFile(IPath path, String name) {
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
        if (res != null) {
            int resType = res.getType();
            if (resType == 1) {
                return null;
            }
            return NLS.bind((String)HibernateConsoleMessages.CodeGenerationSettingsTab_must_be_file, (Object)name);
        }
        return NLS.bind((String)HibernateConsoleMessages.CodeGenerationSettingsTab_does_not_exist, (Object)name);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.getErrorMessage() == null;
    }

    private void updateStatus(String message) {
        this.setErrorMessage(message);
        this.updateLaunchConfigurationDialog();
    }

    public String getConfigurationName() {
        String text = this.consoleConfigurationName.getText();
        return NULL_CONFIG.equals(text) ? "" : text;
    }

    public boolean isReverseEngineerEnabled() {
        return this.reverseengineer.isSelected();
    }

    private String resolve(String expression) {
        if (expression == null) {
            return null;
        }
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        try {
            return variableManager.performStringSubstitution(expression, false);
        }
        catch (CoreException coreException) {
            return expression;
        }
    }

    String getOutputPackage() {
        return this.packageName.getText();
    }

    private IPath getReverseEngineeringSettingsFile() {
        return PathHelper.pathOrNull(this.reverseEngineeringSettings.getText());
    }

    private String getReverseEngineeringStrategy() {
        return this.reverseEngineeringStrategy.getText();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        ExporterAttributes attributes = null;
        try {
            attributes = new ExporterAttributes(configuration);
        }
        catch (CoreException ce) {
            HibernateConsolePlugin.getDefault().logErrorMessage(HibernateConsoleMessages.CodeGenerationSettingsTab_problems_when_reading, ce);
        }
        if (attributes == null) {
            return;
        }
        if (attributes.getConsoleConfigurationName() == null || !KnownConfigurations.getInstance().isKnownConfiguration(attributes.getConsoleConfigurationName())) {
            this.consoleConfigurationName.setText(NULL_CONFIG);
        } else {
            this.consoleConfigurationName.setText(attributes.getConsoleConfigurationName());
        }
        this.preferRawCompositeIds.setSelection(attributes.isPreferBasicCompositeIds());
        this.autoManyToMany.setSelection(attributes.detectManyToMany());
        this.autoVersioning.setSelection(attributes.detectOptimisticLock());
        this.autoOneToOne.setSelection(attributes.detectOneToOne());
        this.outputdir.setText(this.safeText(attributes.getOutputPath()));
        this.reverseengineer.setSelection(attributes.isReverseEngineer());
        this.reverseEngineeringSettings.setText(this.safeText(attributes.getRevengSettings()));
        this.reverseEngineeringStrategy.setText(this.safeText(attributes.getRevengStrategy()));
        this.useOwnTemplates.setSelection(attributes.isUseOwnTemplates());
        this.packageName.setText(this.safeText(attributes.getPackageName()));
        this.templatedir.setText(this.safeText(attributes.getTemplatePath()));
        this.useExternalProcess.setSelection(false);
    }

    private String safeText(String text) {
        return text == null ? "" : text;
    }

    private String strOrNull(String text) {
        if (text == null || text.trim().length() == 0) {
            text = null;
        }
        return text;
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("org.hibernate.tools.outputdir", this.strOrNull(this.outputdir.getText()));
        config.setAttribute("org.hibernate.tools.prefercompositeids", this.preferRawCompositeIds.isSelected());
        config.setAttribute("org.hibernate.tools.reveng.detect_many_to_many", this.autoManyToMany.isSelected());
        config.setAttribute("org.hibernate.tools.reveng.detect_one_to_one", this.autoOneToOne.isSelected());
        config.setAttribute("org.hibernate.tools.reveng.detect_optimistc_lock", this.autoVersioning.isSelected());
        config.setAttribute("org.hibernate.tools.schema2hbm", this.isReverseEngineerEnabled());
        config.setAttribute("org.hibernate.tools.revengstrategy", this.strOrNull(this.reverseEngineeringStrategy.getText()));
        config.setAttribute("org.hibernate.tools.revEngFile", this.strOrNull(this.reverseEngineeringSettings.getText()));
        config.setAttribute("org.hibernate.tools.useOwnTemplates", this.useOwnTemplates.isSelected());
        config.setAttribute("org.hibernate.tools.templatepath", this.strOrNull(this.templatedir.getText()));
        config.setAttribute("org.hibernate.tools.configurationname", this.getConfigurationName());
        config.setAttribute("org.hibernate.tools.package", this.getOutputPackage());
        config.setAttribute("org.hibernate.tools.useExternalProcess", this.useExternalProcess.isSelected());
    }

    public String getName() {
        return HibernateConsoleMessages.CodeGenerationSettingsTab_main;
    }

    public Image getImage() {
        return EclipseImages.getImage("images/hicon.gif");
    }
}

