/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.meta.action.impl;

import org.jboss.tools.common.meta.XAttribute;
import org.jboss.tools.common.meta.XModelEntity;
import org.jboss.tools.common.meta.XModelMetaData;
import org.jboss.tools.common.meta.action.XAttributeData;
import org.jboss.tools.common.meta.action.XEntityData;
import org.jboss.tools.common.meta.action.impl.XEntityDataImpl;
import org.jboss.tools.common.meta.impl.XMetaDataConstants;
import org.jboss.tools.common.meta.impl.XModelMetaDataImpl;
import org.w3c.dom.Element;

public class XAttributeDataImpl
implements XAttributeData,
XMetaDataConstants {
    private String entityname;
    private String attributename;
    private XAttribute attribute;
    private boolean mandatory;
    private boolean isAdvanced;
    private String value = null;
    private boolean references = false;
    private XEntityDataImpl entityData;

    @Override
    public XEntityData getEntityData() {
        return this.entityData;
    }

    public void setEntityData(XEntityDataImpl entityData) {
        this.entityData = entityData;
    }

    @Override
    public boolean getMandatoryFlag() {
        return this.mandatory && !this.isAdvanced;
    }

    @Override
    public boolean isAdvanced() {
        return this.isAdvanced;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public XAttribute getAttribute() {
        return this.references ? this.attribute : (this.attribute = this.loadReference());
    }

    private XAttribute loadReference() {
        this.references = true;
        XModelMetaData meta = XModelMetaDataImpl.getInstance();
        if (meta == null) {
            return null;
        }
        XModelEntity ent = meta.getEntity(this.entityname);
        if (ent == null) {
            return null;
        }
        XAttribute[] attr = ent.getAttributes();
        int i = 0;
        while (i < attr.length) {
            if (attr[i].getName().equals(this.attributename)) {
                return attr[i];
            }
            ++i;
        }
        return null;
    }

    public void setDefaultValue() {
        XAttribute a = this.getAttribute();
        if (a != null) {
            this.setValue(a.getDefaultValue());
        }
    }

    public void load(Element el) {
        this.attributename = el.getAttribute("AttributeName");
        this.entityname = ((Element)el.getParentNode()).getAttribute("EntityName");
        String m = el.getAttribute("Mandatory");
        this.mandatory = "yes".equals(m) || "".equals(m);
        m = el.getAttribute("Advanced");
        this.isAdvanced = "yes".equals(m);
    }

    public String getAttributeName() {
        return this.attributename;
    }

    public static XAttributeDataImpl create(String entityname, String attributename, boolean mandatory) {
        XAttributeDataImpl impl = new XAttributeDataImpl();
        impl.entityname = entityname;
        impl.attributename = attributename;
        impl.mandatory = mandatory;
        return impl;
    }
}

