/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.KnownConfigurationsAdapter;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.ConfigurationNode;

public class ConfigurationListNode
extends BaseNode {
    private boolean childrenCreated;
    private final KnownConfigurations kc;

    public ConfigurationListNode(KnownConfigurations kc) {
        super(null, null);
        this.kc = kc;
        kc.addConsoleConfigurationListener(new KnownConfigurationsAdapter(){

            @Override
            public void configurationAdded(ConsoleConfiguration root) {
                this.markChildrenForReload();
            }

            private void markChildrenForReload() {
                ConfigurationListNode.this.children.clear();
                ConfigurationListNode.this.childrenCreated = false;
            }

            @Override
            public void configurationRemoved(ConsoleConfiguration root, boolean forUpdate) {
                this.markChildrenForReload();
            }

            @Override
            public void configurationReset(ConsoleConfiguration ccfg) {
                this.markChildrenForReload();
            }
        });
    }

    @Override
    protected void checkChildren() {
        if (!this.childrenCreated) {
            ConsoleConfiguration[] configurations = this.kc.getConfigurationsSortedByName();
            int i = 0;
            while (i < configurations.length) {
                this.children.add(new ConfigurationNode(this, configurations[i]));
                ++i;
            }
            this.childrenCreated = true;
        }
    }

    @Override
    public String getHQL() {
        return null;
    }
}

