/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Platform;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.options.SharableConstants;
import org.jboss.tools.common.model.options.SharableElement;
import org.jboss.tools.common.model.options.impl.PreferenceImportExport;
import org.jboss.tools.common.model.options.impl.SharableElementImpl;
import org.jboss.tools.common.model.options.impl.SharableLoaderImpl;
import org.jboss.tools.common.model.options.impl.XStudioContribution;
import org.jboss.tools.common.model.options.impl.XStudioContributions;
import org.jboss.tools.common.model.options.impl.XStudioLoaderPeer;
import org.jboss.tools.common.model.plugin.ModelPlugin;
import org.jboss.tools.common.model.util.XMLUtil;
import org.jboss.tools.common.model.util.XModelObjectLoaderUtil;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XStudioDataLoaderImpl
implements SharableConstants {
    private SharableElement studio = null;
    private XStudioLoaderPeer peer = XStudioLoaderPeer.instance();

    public void load(XModelObject _studio) {
        this.peer.init(_studio);
        this.studio = (SharableElement)_studio;
        this.peer.setIsLoadingOn(true);
        this.studio.setScope("project");
        new SharableLoaderImpl().loadSystemSharable(this.studio);
        XStudioContribution[] cs = XStudioContributions.getContributions();
        int i = 0;
        while (i < cs.length) {
            InputStream s = cs[i].getInputStream();
            this.load(LIST[0], s);
            ++i;
        }
        boolean e = false;
        int i2 = 1;
        while (i2 < LIST.length) {
            File[] fs = this.peer.getFilesForScope(LIST[i2]);
            int j = 0;
            while (j < fs.length) {
                e = this.load(LIST[i2], fs[j]);
                ++j;
            }
            ++i2;
        }
        this.mergeGeneralToProject((SharableElementImpl)this.studio, !e);
        this.peer.setIsLoadingOn(false);
        _studio.setModified(false);
        File f = this.peer.getProjectPreferencesFile();
        if (f != null && f.exists()) {
            PreferenceImportExport.getInstance().apply(f);
        }
    }

    private boolean load(String scopename, File file) {
        Element element = XMLUtil.getElement(file.getAbsolutePath());
        return this.load(scopename, element);
    }

    private boolean load(String scopename, InputStream s) {
        Element element = XMLUtil.getElement(s);
        return this.load(scopename, element);
    }

    private boolean load(String scopename, Element element) {
        if (element == null) {
            return false;
        }
        SharableLoaderImpl loader = new SharableLoaderImpl();
        loader.loadSharable(element, this.studio, scopename);
        return true;
    }

    public boolean save(XModelObject _studio) {
        if (!_studio.isModified()) {
            return true;
        }
        this.peer.init(_studio);
        this.studio = (SharableElement)_studio;
        int i = 0;
        while (i < LIST.length) {
            if (i == 1) {
                this.saveProject();
            }
            ++i;
        }
        _studio.setModified(false);
        return true;
    }

    private void saveProject() {
        File[] fs = this.peer.getFilesForScope("project");
        boolean isPaletteModified = this.studio.getChildByPath("Palette").isModified() || this.studio.getChildByPath("Icons").isModified();
        boolean isPreferencesModified = this.studio.getChildByPath("Options").isModified();
        if (!fs[0].exists() || isPaletteModified) {
            this.savePalette(fs[0]);
        }
        if (!fs[1].exists() || isPreferencesModified) {
            this.savePreferences(fs[1]);
        }
    }

    private void savePalette(File f) {
        if (this.handleReadOnly(this.studio, "project", f) != 0) {
            return;
        }
        this.save(this.studio, "project", f, new String[]{"Palette", "XStudioIcons"});
        this.studio.getChildByPath("Palette").setModified(false);
        this.studio.getChildByPath("Icons").setModified(false);
    }

    private void savePreferences(File f) {
        if (this.handleReadOnly(this.studio, LIST[1], f) != 0) {
            return;
        }
        this.save(this.studio, "project", f, new String[]{"Options"});
        this.studio.getChildByPath("Options").setModified(false);
    }

    private void save(SharableElement q, String scopename, File f, String[] names) {
        if (!(!f.exists() || f.isFile() && f.canWrite())) {
            return;
        }
        try {
            if (!f.exists()) {
                f.createNewFile();
            }
        }
        catch (IOException e1) {
            ModelPlugin.getPluginLog().logError("XStudioDataLoaderImpl:save:Cannot create file:" + e1.getMessage());
            return;
        }
        Element e = XMLUtil.createDocumentElement("dummyroot");
        new SharableLoaderImpl().saveSharable(e, q, scopename);
        NodeList x = e.getElementsByTagName("XStudio");
        if (x == null || x.getLength() == 0) {
            return;
        }
        Element xs = (Element)x.item(0);
        this.check(xs.getChildNodes(), names);
        try {
            XModelObjectLoaderUtil.serialize(xs, f.getAbsolutePath());
        }
        catch (IOException e2) {
            ModelPlugin.getPluginLog().logError((Throwable)e2);
        }
    }

    private void check(NodeList l, String[] names) {
        Node[] ns = new Node[l.getLength()];
        int i = 0;
        while (i < ns.length) {
            ns[i] = l.item(i);
            ++i;
        }
        i = 0;
        while (i < ns.length) {
            this.check(ns[i], names);
            ++i;
        }
    }

    private void check(Node n, String[] names) {
        if (n.getNodeType() != 1) {
            return;
        }
        int i = 0;
        while (i < names.length) {
            if (names[i].equals(n.getNodeName())) {
                return;
            }
            ++i;
        }
        n.getParentNode().removeChild(n);
    }

    private void mergeGeneralToProject(SharableElementImpl object, boolean merge_all) {
        object.merge("general", "project", merge_all);
    }

    private int handleReadOnly(XModelObject o, String scope, File f) {
        if (!"project".equals(scope)) {
            return 1;
        }
        int i = 0;
        while (i == 0 && f.exists() && !f.canWrite()) {
            i = o.getModel().getService().showDialog("Question", this.getReadOnlyMessage(f), new String[]{"Retry", "Discard"}, null, 0);
        }
        return i;
    }

    private String getReadOnlyMessage(File f) {
        return MessageFormat.format("File {0} is read-only.\nPlease make it writable to allow for saving options.", f.getAbsolutePath());
    }

    private InputStream readGeneral() {
        try {
            Bundle b = Platform.getBundle((String)"org.jboss.tools.common.model");
            URL u = b.getResource("meta/options_general.xml");
            URLConnection c = u.openConnection();
            return c.getInputStream();
        }
        catch (IOException e) {
            ModelPlugin.getPluginLog().logError((Throwable)e);
            return null;
        }
    }
}

