/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.plugins.builtin.project;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.forge.maven.MavenPluginFacet;
import org.jboss.forge.parser.java.util.Strings;
import org.jboss.forge.project.Facet;
import org.jboss.forge.project.Project;
import org.jboss.forge.project.dependencies.Dependency;
import org.jboss.forge.project.dependencies.DependencyBuilder;
import org.jboss.forge.project.dependencies.DependencyInstaller;
import org.jboss.forge.project.dependencies.DependencyRepository;
import org.jboss.forge.project.dependencies.ScopeType;
import org.jboss.forge.project.facets.DependencyFacet;
import org.jboss.forge.project.facets.FacetNotFoundException;
import org.jboss.forge.project.facets.MetadataFacet;
import org.jboss.forge.project.facets.PackagingFacet;
import org.jboss.forge.project.facets.events.InstallFacets;
import org.jboss.forge.project.facets.events.RemoveFacets;
import org.jboss.forge.project.services.FacetFactory;
import org.jboss.forge.shell.PromptType;
import org.jboss.forge.shell.Shell;
import org.jboss.forge.shell.ShellColor;
import org.jboss.forge.shell.ShellMessages;
import org.jboss.forge.shell.ShellPrintWriter;
import org.jboss.forge.shell.plugins.Alias;
import org.jboss.forge.shell.plugins.Command;
import org.jboss.forge.shell.plugins.DefaultCommand;
import org.jboss.forge.shell.plugins.Help;
import org.jboss.forge.shell.plugins.Option;
import org.jboss.forge.shell.plugins.PipeOut;
import org.jboss.forge.shell.plugins.Plugin;
import org.jboss.forge.shell.plugins.RequiresFacet;
import org.jboss.forge.shell.plugins.RequiresProject;
import org.jboss.forge.shell.plugins.Topic;
import org.jboss.forge.shell.plugins.builtin.project.AvailableFacetsCompleter;
import org.jboss.forge.shell.plugins.builtin.project.DependencyPropertyCompleter;
import org.jboss.forge.shell.plugins.builtin.project.InstalledFacetsCompleter;
import org.jboss.forge.shell.plugins.builtin.project.PluginRepositoryCompleter;
import org.jboss.forge.shell.plugins.builtin.project.RepositoryCompleter;
import org.jboss.forge.shell.util.ConstraintInspector;

@Alias(value="project")
@Topic(value="Project")
@RequiresProject
@RequiresFacet(value={DependencyFacet.class, MavenPluginFacet.class, PackagingFacet.class})
@Help(value="Perform actions involving the project status, build system, or dependency management system.")
public class ProjectPlugin
implements Plugin {
    private Project project;
    private Shell shell;
    private FacetFactory factory;
    private Event<InstallFacets> installFacets;
    private Event<RemoveFacets> removeFacets;
    private DependencyInstaller dependencyInstaller;

    public ProjectPlugin() {
    }

    @Inject
    public ProjectPlugin(Project project, Shell shell, FacetFactory factory, Event<InstallFacets> installFacets, Event<RemoveFacets> removeFacets, DependencyInstaller installer) {
        this.project = project;
        this.shell = shell;
        this.factory = factory;
        this.installFacets = installFacets;
        this.removeFacets = removeFacets;
        this.dependencyInstaller = installer;
    }

    @DefaultCommand
    public void info(PipeOut out) {
        out.print(ShellColor.BOLD, " name: ");
        out.println(((MetadataFacet)this.project.getFacet(MetadataFacet.class)).getProjectName());
        out.print(ShellColor.BOLD, " groupId:  ");
        out.println(((MetadataFacet)this.project.getFacet(MetadataFacet.class)).getTopLevelPackage());
        out.print(ShellColor.BOLD, " final artifact:  ");
        out.println(((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getFinalArtifact().getName());
        out.print(ShellColor.BOLD, " packaging:  ");
        out.println(((PackagingFacet)this.project.getFacet(PackagingFacet.class)).getPackagingType().getType());
        out.print(ShellColor.BOLD, " dir:  ");
        out.println(this.project.getProjectRoot().getFullyQualifiedName());
    }

    @Command(value="install-facet")
    public void installFacet(@Option(required=true, completer=AvailableFacetsCompleter.class, description="Name of the facet to install") String facetName) {
        try {
            Facet facet = this.factory.getFacetByName(facetName);
            this.installFacets.fire((Object)new InstallFacets(facet.getClass()));
        }
        catch (FacetNotFoundException e) {
            throw new RuntimeException("Could not find a facet with the name: " + facetName + "; use 'project list-facets' to list all available facets.", e);
        }
    }

    @Command(value="remove-facet")
    public void removeFacet(@Option(required=true, completer=InstalledFacetsCompleter.class, description="Name of the facet to install") String facetName) {
        try {
            Facet facet = this.factory.getFacetByName(facetName);
            this.removeFacets.fire((Object)new RemoveFacets(facet.getClass()));
        }
        catch (FacetNotFoundException e) {
            throw new RuntimeException("Could not find a facet with the name: " + facetName + "; use 'project list-facets' to list all available facets.", e);
        }
    }

    @Command(value="add-dependency", help="Add a dependency to this project.")
    public void addDep(@Option(required=true, type=PromptType.DEPENDENCY_ID, description="[ groupId:artifactId {:version :scope :packaging} ]", help="dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"") Dependency gav, @Option(type=PromptType.DEPENDENCY_ID, name="exclude", description="[ groupId:artifactId ]", help="exclusion identifier, ex: \"org.jboss.forge:forge-api\"") Dependency exclusion, PipeOut out) {
        Dependency existingDep;
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        boolean hasEffectiveManagedDependency = deps.hasEffectiveManagedDependency(gav);
        DependencyBuilder gavCopy = DependencyBuilder.create((Dependency)gav);
        if (hasEffectiveManagedDependency && !this.shell.promptBoolean(String.format("Dependency is managed [%s:%s:%s], reference the managed dependency?", (existingDep = deps.getEffectiveManagedDependency(gav)).getGroupId(), existingDep.getArtifactId(), existingDep.getVersion()), true) && Strings.isNullOrEmpty((String)gavCopy.getVersion())) {
            gavCopy = (Dependency)this.shell.promptChoiceTyped("Add which version?", deps.resolveAvailableVersions((Dependency)gavCopy));
        }
        this.dependencyInstaller.install(this.project, (Dependency)gavCopy);
    }

    @Command(value="find-dependency", help="Search for dependencies in all configured project repositories.")
    public void searchDep(@Option(required=true, help="dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"", description="[ groupId:artifactId {:version:scope:packaging} ]", type=PromptType.DEPENDENCY_ID) Dependency gav, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (gav.getVersion() == null || gav.getVersion().trim().isEmpty()) {
            gav = DependencyBuilder.create((Dependency)gav).setVersion("[0,)");
        }
        List versions = deps.resolveAvailableVersions(gav);
        for (Dependency dep : versions) {
            out.println(DependencyBuilder.toString((Dependency)dep));
        }
        if (versions.isEmpty()) {
            out.println("No artifacts found for the query [" + gav + "]");
        }
    }

    @Command(value="remove-dependency", help="Remove a dependency from this project")
    public void removeDep(@Option(required=true, type=PromptType.DEPENDENCY_ID, description="[ groupId :artifactId {:version :scope :packaging} ]", help="dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"") Dependency gav, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (deps.hasEffectiveDependency(gav)) {
            deps.removeDependency(gav);
            out.println("Removed dependency [" + gav + "]");
        } else {
            out.println("Dependency [" + gav + "] not found in project... ");
        }
    }

    @Command(value="list-dependencies", help="List all dependencies this project includes")
    public void listDeps(PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        for (Dependency dep : deps.getDependencies()) {
            this.printDep(out, dep);
        }
    }

    @Command(value="add-managed-dependency", help="Add a managed dependency to this project.")
    public void addManDep(@Option(required=true, type=PromptType.DEPENDENCY_ID, description="[ groupId :artifactId {:version :scope :packaging} ]", help="managed dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"") Dependency gav, PipeOut out) {
        DependencyFacet manDeps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (!manDeps.hasEffectiveManagedDependency(gav) || this.shell.promptBoolean("Managed dependency already exists [" + gav.getGroupId() + ":" + gav.getArtifactId() + "], continue?", true)) {
            DependencyBuilder search = DependencyBuilder.create((Dependency)gav).setVersion("[0,)");
            List availableVersions = manDeps.resolveAvailableVersions((Dependency)search);
            if (availableVersions.isEmpty()) {
                throw new RuntimeException("No available versions resolved for managed dependency [" + gav + "]");
            }
            if (!availableVersions.contains(gav)) {
                ShellMessages.info((ShellPrintWriter)out, (String)("No artifact found for managed dependency [" + gav + "]"));
                if (availableVersions.size() > 1) {
                    gav = (Dependency)this.shell.promptChoiceTyped("Add which version?", availableVersions);
                } else if (this.shell.promptBoolean("Use [" + availableVersions.get(0) + "] instead?", true)) {
                    gav = (Dependency)availableVersions.get(0);
                } else {
                    throw new RuntimeException("Could not add managed dependency [" + gav + "]");
                }
            }
            if (manDeps.hasEffectiveManagedDependency(gav)) {
                Dependency managedDependency = manDeps.getManagedDependency(gav);
                manDeps.removeManagedDependency(managedDependency);
            }
            manDeps.addManagedDependency(gav);
            out.println("Added managed dependency [" + gav + "]");
        } else {
            ShellMessages.info((ShellPrintWriter)out, (String)"Aborted.");
        }
    }

    @Command(value="find-managed-dependency", help="Search for managed dependencies in all configured project repositories.")
    public void searchManDep(@Option(required=true, help="managed dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"", description="[ groupId:artifactId {:version:scope:packaging} ]", type=PromptType.DEPENDENCY_ID) Dependency gav, @Option(required=false, flagOnly=true, help="Perform a search only within the locally configured repository", name="offlineSearch") boolean offline, PipeOut out) {
        DependencyFacet manDeps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (gav.getVersion() == null || gav.getVersion().trim().isEmpty()) {
            gav = DependencyBuilder.create((Dependency)gav).setVersion("[0,)");
        }
        List versions = manDeps.resolveAvailableVersions(gav);
        for (Dependency manDep : versions) {
            out.println(DependencyBuilder.toString((Dependency)manDep));
        }
        if (versions.isEmpty()) {
            out.println("No artifacts found for the query [" + gav + "]");
        }
    }

    @Command(value="remove-managed-dependency", help="Remove a managed dependency from this project")
    public void removeManDep(@Option(required=true, type=PromptType.DEPENDENCY_ID, description="[ groupId :artifactId {:version :scope :packaging} ]", help="managed dependency identifier, ex: \"org.jboss.forge:forge-api:1.0.0\"") Dependency gav, PipeOut out) {
        DependencyFacet manDeps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (manDeps.hasEffectiveManagedDependency(gav)) {
            manDeps.removeManagedDependency(gav);
            out.println("Removed managed dependency [" + gav + "]");
        } else {
            out.println("Managed dependency [" + gav + "] not found in project... ");
        }
    }

    @Command(value="list-managed-dependencies", help="List all managed dependencies this project includes")
    public void listManDeps(PipeOut out) {
        DependencyFacet manDeps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        for (Dependency manDep : manDeps.getManagedDependencies()) {
            this.printDep(out, manDep);
        }
    }

    @Command(value="set-property")
    public void addProp(@Option(required=true, name="name", completer=DependencyPropertyCompleter.class) String name, @Option(required=true, name="value") String value, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (deps.getProperties().containsKey(name) && this.shell.promptBoolean("Update property [" + name + "=" + deps.getProperty(name) + "] to new value [" + value + "]", true)) {
            deps.setProperty(name, value);
            out.println("Updated...");
        } else {
            deps.setProperty(name, value);
            out.println("Set property [" + name + "=" + value + "]");
        }
    }

    @Command(value="remove-property")
    public void removeProp(@Option(required=true, description="propname", completer=DependencyPropertyCompleter.class) String name, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (deps.getProperties().containsKey(name)) {
            String value = deps.removeProperty(name);
            out.println("Removed property [" + name + "=" + value + "]");
        } else {
            out.println("No such property [" + name + "]");
        }
    }

    @Command(value="list-properties")
    public void listProps(PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        Map properties = deps.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            out.print((String)entry.getKey() + "=");
            out.println(ShellColor.BLUE, (String)entry.getValue());
        }
    }

    @Command(value="list-facets")
    public void listFacets(PipeOut out) {
        String name;
        Set facets = this.factory.getFacetTypes();
        out.println(ShellColor.BOLD, "NOT INSTALLED");
        for (Class type : facets) {
            name = ConstraintInspector.getName((Class)type);
            if (this.project.hasFacet(type)) continue;
            out.println("- " + name + "\t[" + type.getName() + "]");
        }
        out.println();
        out.println(ShellColor.BOLD, "INSTALLED");
        for (Class type : facets) {
            name = ConstraintInspector.getName((Class)type);
            if (this.project.hasFacet(type) && !this.project.getFacet(type).isInstalled()) {
                out.println(ShellColor.RED, "? " + name + "\t[" + type.getName() + " - WARN: facet is no longer available]");
                continue;
            }
            if (!this.project.hasFacet(type)) continue;
            out.println(ShellColor.GREEN, "+ " + name + "\t[" + type.getName() + "]");
        }
    }

    @Command(value="add-known-repository")
    public void repoAdd(@Option(description="type...", required=true) DependencyFacet.KnownRepository repo, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (deps.hasRepository(repo)) {
            out.println("Repository exists [" + repo.name() + "->" + repo.getUrl() + "]");
        } else {
            deps.addRepository(repo);
            out.println("Added repository [" + repo.name() + "->" + repo.getUrl() + "]");
        }
    }

    @Command(value="add-repository")
    public void repoAdd(@Option(description="repository name...", required=true) String name, @Option(description="repository URL...", required=true) String url, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        if (deps.hasRepository(url)) {
            out.println("Repository exists [" + url + "]");
        } else {
            deps.addRepository(name, url);
            out.println("Added repository [" + name + "->" + url + "]");
        }
    }

    @Command(value="remove-repository")
    public void repoRemove(@Option(required=true, description="repo url...", completer=RepositoryCompleter.class) String url, PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        DependencyRepository rep = deps.removeRepository(url);
        if (rep != null) {
            out.println("Removed repository [" + rep.getId() + "->" + rep.getUrl() + "]");
        } else {
            out.println("No repository with url [" + url + "]");
        }
    }

    @Command(value="list-repositories")
    public void repoList(PipeOut out) {
        DependencyFacet deps = (DependencyFacet)this.project.getFacet(DependencyFacet.class);
        List repos = deps.getRepositories();
        for (DependencyRepository repo : repos) {
            out.print(repo.getId() + "->");
            out.println(ShellColor.BLUE, repo.getUrl());
        }
    }

    @Command(value="list-plugin-repositories")
    public void pluginRepoList(PipeOut out) {
        MavenPluginFacet deps = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        List repos = deps.getPluginRepositories();
        for (DependencyRepository repo : repos) {
            out.print(repo.getId() + "->");
            out.println(ShellColor.BLUE, repo.getUrl());
        }
    }

    @Command(value="add-known-plugin-repository")
    public void pluginRepoAdd(@Option(description="type...", required=true) MavenPluginFacet.KnownRepository repo, PipeOut out) {
        MavenPluginFacet deps = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        if (deps.hasPluginRepository(repo)) {
            out.println("Plugin repository exists [" + repo.name() + "->" + repo.getUrl() + "]");
        } else {
            deps.addPluginRepository(repo);
            out.println("Added plugin repository [" + repo.name() + "->" + repo.getUrl() + "]");
        }
    }

    @Command(value="add-plugin-repository")
    public void pluginRepoAdd(@Option(description="repository name...", required=true) String name, @Option(description="repository URL...", required=true) String url, PipeOut out) {
        MavenPluginFacet deps = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        if (deps.hasPluginRepository(url)) {
            out.println("Plugin repository exists [" + url + "]");
        } else {
            deps.addPluginRepository(name, url);
            out.println("Added plugin repository [" + name + "->" + url + "]");
        }
    }

    @Command(value="remove-plugin-repository")
    public void pluginRepoRemove(@Option(required=true, description="repo url...", completer=PluginRepositoryCompleter.class) String url, PipeOut out) {
        MavenPluginFacet deps = (MavenPluginFacet)this.project.getFacet(MavenPluginFacet.class);
        DependencyRepository rep = deps.removePluginRepository(url);
        if (rep != null) {
            out.println("Removed plugin repository [" + rep.getId() + "->" + rep.getUrl() + "]");
        } else {
            out.println("No plugin repository with url [" + url + "]");
        }
    }

    private void printDep(PipeOut out, Dependency dep) {
        out.println(out.renderColor(ShellColor.BLUE, dep.getGroupId()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.BLUE, dep.getArtifactId()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.NONE, dep.getVersion() == null ? "" : dep.getVersion()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(ShellColor.NONE, dep.getPackagingType() == null ? "" : dep.getPackagingType().toLowerCase()) + out.renderColor(ShellColor.BOLD, " : ") + out.renderColor(this.determineDependencyShellColor(dep.getScopeTypeEnum()), dep.getScopeType() == null ? "compile" : dep.getScopeType().toLowerCase()));
    }

    private ShellColor determineDependencyShellColor(ScopeType type) {
        if (type == null) {
            return ShellColor.YELLOW;
        }
        switch (type) {
            case PROVIDED: {
                return ShellColor.GREEN;
            }
            case COMPILE: {
                return ShellColor.YELLOW;
            }
            case RUNTIME: {
                return ShellColor.MAGENTA;
            }
            case OTHER: {
                return ShellColor.BLACK;
            }
            case SYSTEM: {
                return ShellColor.BLACK;
            }
            case TEST: {
                return ShellColor.BLUE;
            }
        }
        return ShellColor.NONE;
    }
}

